/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.classes;

import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.data.StringData;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.columns.scripted.classes.BasePropertySpec;
import builderb0y.bigglobe.columns.scripted.classes.ClassHierarchy;
import builderb0y.bigglobe.columns.scripted.classes.CustomClassFormatException;
import builderb0y.bigglobe.columns.scripted.classes.ElementSpec;
import builderb0y.bigglobe.columns.scripted.classes.FieldSpec;
import builderb0y.bigglobe.columns.scripted.classes.MemberSpec;
import builderb0y.bigglobe.columns.scripted.classes.ObjectBase;
import builderb0y.bigglobe.columns.scripted.classes.OverrideTracker;
import builderb0y.bigglobe.columns.scripted.classes.TypeSpec;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.ClassCompileContext;
import builderb0y.scripting.bytecode.FieldCompileContext;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.AbstractObjectUpdaterInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.AbstractUpdaterInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.ReceiverObjectUpdaterInsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptClassLoader;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public abstract class BaseClassSpec
extends TypeSpec {
    public final @ExpressionParser.IdentifierName String name;
    public final @UseName(value="abstract") @DefaultBoolean(value=false) boolean isAbstract;
    public final @UseName(value="extends") @VerifyNullable class_6880<ElementSpec> parent;
    public final DelayedEntryList<ElementSpec> members;
    public transient TypeInfo typeInfo;
    public transient ClassCompileContext classCompileContext;
    public transient MethodCompileContext primaryConstructor;
    public transient DependencyView.MutableDependencyView primaryConstructorDependencies;
    public transient Map<MemberSpec, Object> memberCompileContexts;
    public transient OverrideTracker overrideTracker;

    public BaseClassSpec(@ExpressionParser.IdentifierName String name, boolean isAbstract, @Nullable class_6880<ElementSpec> parent, DelayedEntryList<ElementSpec> members) {
        this.name = name;
        this.isAbstract = isAbstract;
        this.parent = parent;
        this.members = members;
        this.memberCompileContexts = new Reference2ReferenceOpenHashMap();
        HashSet primaryConstructorDependencies = new HashSet();
        this.primaryConstructorDependencies = () -> primaryConstructorDependencies;
    }

    public <T> T getCompileContext(MemberSpec spec) {
        return (T)this.memberCompileContexts.get(spec);
    }

    public void setCompileContext(MemberSpec spec, Object value) {
        this.memberCompileContexts.put(spec, value);
    }

    public void applyDefaultFields(ClassHierarchy hierarchy, LoadInsnTree loadSelf, LoadInsnTree loadColumn) throws ScriptParsingException {
        for (OverrideTracker.TrackedField trackedField : this.overrideTracker.fields.values()) {
            FieldSpec fieldSpec = (FieldSpec)trackedField.declaration().comp_349();
            if (fieldSpec.defaultValue == null) continue;
            InsnTrees.putField(loadSelf, ((FieldCompileContext)this.getCompileContext((MemberSpec)fieldSpec)).info, InsnTrees.scoped(hierarchy.registry.parseCode(this.primaryConstructor, fieldSpec.defaultValue, loadColumn, null, loadSelf, this.primaryConstructorDependencies, MemberSpec.NO_EXTRAS))).emitBytecode(this.primaryConstructor);
        }
    }

    public InsnTree applyFields(ClassHierarchy hierarchy, InsnTree loadColumn, MapData map, InsnTree result) {
        for (Map.Entry entry : map.value.entrySet()) {
            StringData name = ((Data)entry.getKey()).tryAsString();
            if (name == null) {
                throw new IllegalArgumentException("Field or property name is non-string: " + String.valueOf(entry.getKey()));
            }
            OverrideTracker.TrackedField field = (OverrideTracker.TrackedField)this.overrideTracker.fields.get((Object)name.value);
            if (field != null) {
                FieldSpec fieldSpec = (FieldSpec)field.declaration().comp_349();
                FieldCompileContext context = (FieldCompileContext)this.getCompileContext(fieldSpec);
                InsnTree fieldConstant = BaseClassSpec.asType(fieldSpec.field_type).parseConstant(hierarchy, (Data)entry.getValue(), loadColumn);
                result = new ReceiverObjectUpdaterInsnTree(AbstractUpdaterInsnTree.CombinedMode.VOID_ASSIGN, AbstractObjectUpdaterInsnTree.ObjectUpdaterEmitters.forField(result, context.info, fieldConstant));
                continue;
            }
            OverrideTracker.TrackedProperty property = (OverrideTracker.TrackedProperty)this.overrideTracker.properties.get((Object)name.value);
            if (property != null) {
                BasePropertySpec propertySpec = (BasePropertySpec)property.declaration().comp_349();
                if (!propertySpec.isSettable()) {
                    throw new IllegalArgumentException("Property " + name.value + " is non-settable");
                }
                BasePropertySpec.PropertyCompileContext context = (BasePropertySpec.PropertyCompileContext)this.getCompileContext(propertySpec);
                InsnTree propertyConstant = BaseClassSpec.asType(propertySpec.getPropertyType()).parseConstant(hierarchy, (Data)entry.getValue(), loadColumn);
                result = new ReceiverObjectUpdaterInsnTree(AbstractUpdaterInsnTree.CombinedMode.VOID_ASSIGN, AbstractObjectUpdaterInsnTree.ObjectUpdaterEmitters.forGetterSetter(result, context.get.info, context.set.info, propertyConstant));
                continue;
            }
            throw new IllegalArgumentException("Can't find field named " + name.value + " in class " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this))));
        }
        return result;
    }

    @Override
    public TypeInfo getTypeInfo() {
        if (this.typeInfo == null) {
            throw new IllegalStateException("Must progress to CREATE_TYPE_INFO before type info can be queried!");
        }
        return this.typeInfo;
    }

    @Override
    @Nullable
    public OverrideTracker getOverrideTracker() {
        if (this.overrideTracker == null) {
            throw new IllegalStateException("Must progress to CREATE_TYPE_INFO before override tracker can be queried!");
        }
        return this.overrideTracker;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public String name() {
        return this.name;
    }

    public abstract FieldInfo baseColumnField();

    public TypeInfo defaultSuperClass() {
        return this.baseColumnField().owner;
    }

    @MustBeInvokedByOverriders
    public void addReservedMembers() {
        this.overrideTracker.addReservedMethod("getClass", new TypeInfo[0]);
        this.overrideTracker.addReservedMethod("clone", new TypeInfo[0]);
        this.overrideTracker.addReservedMethod("notify", new TypeInfo[0]);
        this.overrideTracker.addReservedMethod("notifyAll", new TypeInfo[0]);
        this.overrideTracker.addReservedMethod("wait", new TypeInfo[0]);
        this.overrideTracker.addReservedMethod("wait", TypeInfos.LONG);
        this.overrideTracker.addReservedMethod("wait", TypeInfos.LONG, TypeInfos.INT);
        this.overrideTracker.addReservedMethod("finalize", new TypeInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTypeInfo(ClassHierarchy hierarchy, LinkedHashSet<class_6880<ElementSpec>> cyclicDetector) throws CustomClassFormatException {
        class_6880<ElementSpec> entry = hierarchy.entryOf(this);
        if (cyclicDetector.add(entry)) {
            try {
                TypeInfo superClass;
                if (this.parent != null) {
                    TypeSpec superSpec = BaseClassSpec.asType(this.parent);
                    if (superSpec.canProgressTo(TypeSpec.CompileStep.CREATE_TYPE_INFO)) {
                        superSpec.createTypeInfo(hierarchy, cyclicDetector);
                    }
                    superClass = superSpec.getTypeInfo();
                    this.overrideTracker = new OverrideTracker(hierarchy, hierarchy.entryOf(this), superSpec.getOverrideTracker());
                } else {
                    superClass = this.defaultSuperClass();
                    this.overrideTracker = new OverrideTracker(hierarchy, hierarchy.entryOf(this));
                    this.addReservedMembers();
                }
                this.typeInfo = TypeInfo.makeClass(Type.getObjectType((String)(ObjectBase.INFO.type.getInternalName() + "$" + this.name + "_" + ScriptClassLoader.CLASS_UNIQUIFIER.getAndIncrement())), superClass, (TypeInfo[])TypeInfo.ARRAY_FACTORY.empty(), false);
            }
            finally {
                cyclicDetector.remove(entry);
            }
        } else {
            throw new CustomClassFormatException("Cyclic inheritance chain: " + cyclicDetector.stream().dropWhile(e -> e != entry).map(UnregisteredObjectException::getID).map(class_2960::toString).collect(Collectors.joining(" -> ")) + " -> " + String.valueOf(UnregisteredObjectException.getID(entry)));
        }
    }

    @Override
    public void verify(ClassHierarchy hierarchy) throws CustomClassFormatException {
        if (this.parent != null && BaseClassSpec.asType(this.parent).isFinal()) {
            throw new CustomClassFormatException("Class " + String.valueOf(UnregisteredObjectException.getID(this.parent)) + " cannot be extended.");
        }
        for (class_6880<ElementSpec> element : this.members.entryList()) {
            MemberSpec member = BaseClassSpec.asMember(element);
            member.verify(hierarchy, this);
            member.track(this.overrideTracker);
        }
        boolean isAbstract = this.overrideTracker.hasAnyAbstractMethods();
        if (this.isAbstract && !isAbstract) {
            BigGlobeMod.LOGGER.warn("Custom class " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this))) + " is marked as abstract, but has no abstract methods. This may be a mistake.");
        } else if (!this.isAbstract && isAbstract) {
            throw new CustomClassFormatException("Custom class " + String.valueOf(UnregisteredObjectException.getID(hierarchy.entryOf(this))) + " is not marked as abstract, but contains or inherits abstract members: " + this.overrideTracker.getAbstractMembers().map(UnregisteredObjectException::getID).map(class_2960::toString).collect(Collectors.joining(", ", "[", "]")));
        }
    }

    @Override
    public void createClass(ClassHierarchy hierarchy) {
        this.classCompileContext = new ClassCompileContext(this.isAbstract ? 1025 : 1, this.getTypeInfo());
    }

    @Override
    public void createMembers(ClassHierarchy hierarchy) {
        for (class_6880<ElementSpec> member : this.members.entryList()) {
            BaseClassSpec.asMember(member).create(hierarchy, this);
        }
    }

    @Override
    public void compileMembers(ClassHierarchy hierarchy) throws ScriptParsingException {
        for (class_6880<ElementSpec> member : this.members.entryList()) {
            BaseClassSpec.asMember(member).compile(hierarchy, this);
        }
    }

    @Override
    public void link(ScriptClassLoader loader) {
        loader.recursiveAddClasses(this.classCompileContext, DUMP_DIRECTORY, null);
    }

    @Override
    public void setupEnvironment(MutableScriptEnvironment environment, @Nullable InsnTree loadCustomClass) {
        super.setupEnvironment(environment, loadCustomClass);
        for (class_6880<ElementSpec> member : this.members.entryList()) {
            BaseClassSpec.asMember(member).setupEnvironment(environment, this, loadCustomClass);
        }
    }
}

