/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.dependencies;

import builderb0y.autocodec.util.HashStrategies;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.columns.scripted.dependencies.DependencyView;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.columns.scripted.traits.WorldTraits;
import builderb0y.bigglobe.dynamicRegistries.BetterRegistry;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class DependencyDepthSorter {
    public static final Hash.Strategy<class_6880<?>> REGISTRY_ENTRY_STRATEGY = HashStrategies.map((Hash.Strategy)HashStrategies.identityStrategy(), UnregisteredObjectException::getKey);
    public static final Object2ObjectLinkedOpenHashMap<String, CompletableFuture<Void>> saveTasks = new Object2ObjectLinkedOpenHashMap();
    public static final String GRAPH_DIRECTORY_NAME = "bigglobe_dependency_graphs";
    public static final Path GRAPH_DIRECTORY_PATH = FabricLoader.getInstance().getGameDir().resolve("bigglobe_dependency_graphs");
    public static final File GRAPH_DIRECTORY_FILE = GRAPH_DIRECTORY_PATH.toFile();
    public final WorldTraits traits;
    public final List<List<class_6880<? extends DependencyView>>> results = new ArrayList<List<class_6880<? extends DependencyView>>>(16);
    public final Object2IntOpenCustomHashMap<class_6880<? extends DependencyView>> cache = new Object2IntOpenCustomHashMap(256, REGISTRY_ENTRY_STRATEGY);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(WorldTraits traits, BetterRegistry<ColumnEntry> columns, String name) {
        Object2ObjectLinkedOpenHashMap<String, CompletableFuture<Void>> object2ObjectLinkedOpenHashMap = saveTasks;
        synchronized (object2ObjectLinkedOpenHashMap) {
            CompletableFuture future = (CompletableFuture)saveTasks.get((Object)name);
            if (future != null) {
                future.join();
            }
            saveTasks.put((Object)name, (Object)CompletableFuture.runAsync(() -> {
                DependencyDepthSorter sorter = new DependencyDepthSorter(traits);
                columns.streamEntries().forEach(sorter::recursiveComputeDepth);
                sorter.outputResults(name);
            }).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    BigGlobeMod.LOGGER.error("Exception generating dependency graph:", throwable);
                }
            }));
        }
    }

    public DependencyDepthSorter(WorldTraits traits) {
        this.cache.defaultReturnValue(-1);
        this.traits = traits;
    }

    public int recursiveComputeDepth(class_6880<? extends DependencyView> entry) {
        int depth = this.cache.getInt(entry);
        if (depth < 0) {
            OptionalInt optional = DependencyDepthSorter.skipNonColumnEntries(((DependencyView)entry.comp_349()).streamDirectDependencies(entry, this.traits), this.traits).mapToInt(this::recursiveComputeDepth).max();
            depth = optional.isPresent() ? optional.getAsInt() + 1 : 0;
            this.cache.put(entry, depth);
            while (this.results.size() <= depth) {
                this.results.add(new ArrayList(16));
            }
            this.results.get(depth).add(entry);
        }
        return depth;
    }

    public static Stream<? extends class_6880<? extends DependencyView>> skipNonColumnEntries(Stream<? extends class_6880<? extends DependencyView>> stream, WorldTraits traits) {
        return stream.flatMap(element -> element.comp_349() instanceof ColumnEntry ? Stream.of(element) : DependencyDepthSorter.skipNonColumnEntries(((DependencyView)element.comp_349()).streamDirectDependencies((class_6880<? extends DependencyView>)element, traits), traits));
    }

    public void outputResults(String name) {
        BigGlobeMod.LOGGER.info("Generating column value dependency tree debug files, as requested in your config file...");
        GRAPH_DIRECTORY_FILE.mkdir();
        if (this.outputGraphViz(name) || !new File(GRAPH_DIRECTORY_FILE, name + ".png").exists()) {
            try (Graph graph = new Graph(this);){
                graph.doAllTheThings(this.traits, name);
            }
        } else {
            BigGlobeMod.LOGGER.info(".minecraft/bigglobe_dependency_graphs/" + name + ".gv.txt already exists and contents are up-to-date. Skipping image generation.");
        }
    }

    public boolean outputGraphViz(String name) {
        try {
            Path path = GRAPH_DIRECTORY_PATH.resolve(name + ".gv.txt");
            String text = this.getGraphVizText();
            if (Files.exists(path, new LinkOption[0]) && Files.readString(path).equals(text)) {
                return false;
            }
            Files.writeString(path, (CharSequence)text, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return true;
        }
        catch (IOException exception) {
            BigGlobeMod.LOGGER.warn("Exception generating graphviz file: ", (Throwable)exception);
            return false;
        }
    }

    public String getGraphVizText() {
        StringWriter writer = new StringWriter(65536);
        PrintWriter out = new PrintWriter(writer);
        out.println("digraph bigglobe_column_values {");
        out.println("\trankdir=\"RL\"");
        SubGraph root = new SubGraph();
        for (class_6880 entry2 : this.cache.keySet()) {
            String[] split;
            String identifier = DependencyDepthSorter.keyToString(UnregisteredObjectException.getKey(entry2));
            SubGraph graph = root;
            for (String part : split = identifier.split("[/:]")) {
                graph = graph.computeIfAbsent(part, $ -> new SubGraph());
            }
            graph.fullName = identifier;
        }
        root.printAll(out, null, 0);
        this.cache.keySet().stream().sorted(Comparator.comparing(UnregisteredObjectException::getID)).forEachOrdered(entry -> {
            String dependencyString = DependencyDepthSorter.skipNonColumnEntries(((DependencyView)entry.comp_349()).streamDirectDependencies((class_6880<? extends DependencyView>)entry, this.traits), this.traits).map(UnregisteredObjectException::getKey).sorted(Comparator.comparing(class_5321::method_29177)).map(DependencyDepthSorter::keyToString).map(id -> "\"" + id + "\"").collect(Collectors.joining(" "));
            if (!dependencyString.isEmpty()) {
                out.println("\t\"" + DependencyDepthSorter.keyToString(UnregisteredObjectException.getKey(entry)) + "\" -> { " + dependencyString + " }");
            }
        });
        out.println('}');
        return writer.toString();
    }

    public static String keyToString(class_5321<?> key) {
        return String.valueOf(key.method_41185()) + ":" + String.valueOf(key.method_29177());
    }

    public static class Graph
    implements AutoCloseable {
        public static final int FONT_SIZE = 16;
        public static final int RECTANGLE_HEIGHT = 64;
        public static final int MARGIN = 32;
        public static final int HORIZONTAL_SPACING = 256;
        public static final int VERTICAL_SPACING = 32;
        public static final int RECTANGLE_CURVE = 16;
        public Map<class_6880<? extends DependencyView>, Cell> cellLookup;
        public List<Column> columns;
        public Font font;
        public FontRenderContext fontRenderContext;
        public BufferedImage image;
        public Graphics2D graphics;
        public int largestColumn;

        public Graph(DependencyDepthSorter sorter) {
            BigGlobeMod.LOGGER.debug("Constructing dependency graph.");
            this.font = new Font(null, 0, 16);
            this.fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
            this.cellLookup = new Object2ObjectOpenCustomHashMap(256, REGISTRY_ENTRY_STRATEGY);
            int columnCount = sorter.results.size();
            this.columns = new ArrayList<Column>(columnCount);
            int columnPosition = 32;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                Column column = new Column(this, columnIndex, columnPosition);
                this.columns.add(column);
                int columnWidth = 0;
                for (class_6880<? extends DependencyView> entry : sorter.results.get(columnIndex)) {
                    Cell cell = new Cell(column, UnregisteredObjectException.getID(entry).toString(), columnIndex);
                    this.cellLookup.put(entry, cell);
                    this.addCell(cell);
                    columnWidth = Math.max(columnWidth, cell.textBounds.width);
                }
                column.width = columnWidth + 16;
                columnPosition += column.width + 256;
                this.largestColumn = Math.max(this.largestColumn, sorter.results.get(columnIndex).size());
            }
        }

        public void doAllTheThings(WorldTraits traits, String name) {
            BigGlobeMod.LOGGER.info("Linking " + name + " dependency graph...");
            this.link(traits);
            BigGlobeMod.LOGGER.info("Filing cells in " + name + " dependency graph...");
            this.fillCells();
            BigGlobeMod.LOGGER.info("Organizing " + name + " dependency graph...");
            this.organize();
            BigGlobeMod.LOGGER.info("Creating image for " + name + " dependency graph...");
            this.createImage();
            BigGlobeMod.LOGGER.info("Saving image for " + name + " dependency graph...");
            this.saveImage(name);
            BigGlobeMod.LOGGER.info("Done outputting " + name + " dependency graph results.");
        }

        public void link(WorldTraits traits) {
            for (Map.Entry<class_6880<? extends DependencyView>, Cell> dependant : this.cellLookup.entrySet()) {
                DependencyDepthSorter.skipNonColumnEntries(((DependencyView)dependant.getKey().comp_349()).streamDirectDependencies(dependant.getKey(), traits), traits).forEach(dependency -> {
                    Cell left = this.cellLookup.get(dependency);
                    ((Cell)dependant.getValue()).leftCells.add(left);
                    left.rightCells.add((Cell)dependant.getValue());
                });
            }
        }

        public void fillCells() {
            int collumnCount = this.columns.size();
            for (int columnIndex = 0; columnIndex < collumnCount; ++columnIndex) {
                Column column = this.columns.get(columnIndex);
                while (column.rows.size() < this.largestColumn) {
                    column.addCell(new Cell(column, null, columnIndex));
                }
            }
        }

        public void organize() {
            boolean swappedAny = true;
            while (swappedAny) {
                swappedAny = false;
                for (Column column : this.columns) {
                    int index1 = 0;
                    int limit = column.rows.size() - 1;
                    while (index1 < limit) {
                        int index2 = index1 + 1;
                        Cell cell1 = column.rows.get(index1);
                        Cell cell2 = column.rows.get(index2);
                        double initialDistance = cell1.sumDistances() + cell2.sumDistances();
                        int slotY = cell1.slotY;
                        cell1.slotY = cell2.slotY;
                        cell2.slotY = slotY;
                        double finalDistance = cell1.sumDistances() + cell2.sumDistances();
                        if (finalDistance < initialDistance) {
                            column.rows.set(index1, cell2);
                            column.rows.set(index2, cell1);
                            swappedAny = true;
                        } else {
                            cell2.slotY = cell1.slotY;
                            cell1.slotY = slotY;
                        }
                        index1 = index2;
                    }
                }
            }
        }

        public void createImage() {
            Column lastColumn = this.columns.get(this.columns.size() - 1);
            int width = lastColumn.posX + lastColumn.width + 32;
            int height = this.largestColumn * 96 - 32 + 64;
            this.image = new BufferedImage(width, height, 2);
            this.graphics = this.image.createGraphics();
            this.fillImage();
            this.drawLines();
            this.drawCells();
        }

        public void fillImage() {
            int[] pixel = new int[]{-1};
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.image.getRaster().setDataElements(x, y, pixel);
                }
            }
        }

        public void drawLines() {
            for (Column column : this.columns) {
                for (Cell from : column.rows) {
                    for (Cell to : from.rightCells) {
                        this.drawLine(from, to);
                    }
                }
            }
        }

        public void drawLine(Cell from, Cell to) {
            int x0 = from.getRightCenterX();
            int x1 = to.getLeftCenterX();
            int y0 = from.getRightCenterY();
            int y1 = to.getLeftCenterY();
            int c0 = from.color;
            int c1 = to.color;
            int prevY = y0;
            int[] pixel = new int[1];
            for (int x = x0; x < x1; ++x) {
                int color;
                float fraction = Interpolator.unmixLinear(x0, x1, x);
                int currY = (int)Interpolator.mixSmooth(y0, y1, fraction);
                int stepY = Integer.signum(currY - prevY);
                pixel[0] = color = (int)Interpolator.mixLinear(c0 >>> 16 & 0xFF, c1 >>> 16 & 0xFF, fraction) << 16 | (int)Interpolator.mixLinear(c0 >>> 8 & 0xFF, c1 >>> 8 & 0xFF, fraction) << 8 | (int)Interpolator.mixLinear(c0 & 0xFF, c1 & 0xFF, fraction) | 0xFF000000;
                if (prevY == currY) {
                    this.image.getRaster().setDataElements(x, currY, pixel);
                } else {
                    for (int y = prevY; y != currY; y += stepY) {
                        this.image.getRaster().setDataElements(x, y, pixel);
                    }
                }
                prevY = currY;
            }
        }

        public void drawCells() {
            for (Column column : this.columns) {
                for (Cell row : column.rows) {
                    row.draw();
                }
            }
        }

        public void saveImage(String name) {
            try {
                ImageIO.write((RenderedImage)this.image, "png", new File(GRAPH_DIRECTORY_FILE, name + ".png"));
            }
            catch (IOException exception) {
                BigGlobeMod.LOGGER.warn("Exception saving column value dependency chart image: ", (Throwable)exception);
            }
        }

        public void addCell(Cell cell) {
            Column column = this.columns.get(cell.slotX);
            column.addCell(cell);
            this.largestColumn = Math.max(this.largestColumn, column.rows.size());
        }

        @Override
        public void close() {
            if (this.graphics != null) {
                this.graphics.dispose();
                this.graphics = null;
            }
            this.image = null;
        }
    }

    public static class SubGraph
    extends HashMap<String, SubGraph> {
        public String fullName;

        public void printAll(PrintWriter stream, String name, int depth) {
            String indentation = "\t".repeat(depth);
            if (this.isEmpty()) {
                stream.println(indentation + "\"" + this.fullName + "\" [ label = \"" + name + "\" ]");
            } else {
                if (name != null) {
                    stream.println(indentation + "subgraph \"" + name + "\" {");
                    stream.println(indentation + "\tcluster = true");
                    stream.println(indentation + "\tlabel = \"" + name + "\"");
                }
                this.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> ((SubGraph)entry.getValue()).printAll(stream, (String)entry.getKey(), depth + 1));
                if (name != null) {
                    stream.println(indentation + "}");
                }
            }
        }
    }

    public static class Cell {
        public final Column column;
        public final String text;
        public final TextLayout layout;
        public final Rectangle textBounds;
        public int slotX;
        public int slotY;
        public int color;
        public Set<Cell> leftCells;
        public Set<Cell> rightCells;

        public Cell(Column column, String text, int depth) {
            this.column = column;
            this.text = text;
            this.layout = text == null ? null : new TextLayout(text, column.graph.font, column.graph.fontRenderContext);
            this.textBounds = this.layout == null ? new Rectangle() : this.layout.getPixelBounds(column.graph.fontRenderContext, 0.0f, 0.0f);
            this.slotX = depth;
            int n = this.color = text == null ? 0 : text.hashCode();
            while ((this.color & 0xFF) + (this.color >>> 8 & 0xFF) + (this.color >>> 16 & 0xFF) > 384) {
                this.color = HashCommon.mix((int)this.color);
            }
            this.color |= 0xFF000000;
            this.leftCells = new HashSet<Cell>(0);
            this.rightCells = new HashSet<Cell>(0);
        }

        public int getRectangleX() {
            return this.column.posX;
        }

        public int getRectangleY() {
            return this.slotY * 96 + 32;
        }

        public int getRectangleWidth() {
            return this.column.width;
        }

        public int getRectangleHeight() {
            return 64;
        }

        public int getTextX() {
            int desiredCenter = this.getRectangleX() + (this.getRectangleWidth() >> 1);
            int actualCenter = this.textBounds.x + (this.textBounds.width >> 1);
            return desiredCenter - actualCenter;
        }

        public int getTextY() {
            int desiredCenter = this.getRectangleY() + (this.getRectangleHeight() >> 1);
            int actualCenter = this.textBounds.y + (this.textBounds.height >> 1);
            return desiredCenter - actualCenter;
        }

        public int getLeftCenterX() {
            return this.getRectangleX();
        }

        public int getLeftCenterY() {
            return this.getRectangleY() + (this.getRectangleHeight() >> 1);
        }

        public int getRightCenterX() {
            return this.getRectangleX() + this.getRectangleWidth();
        }

        public int getRightCenterY() {
            return this.getRectangleY() + (this.getRectangleHeight() >> 1);
        }

        public double sumDistances() {
            double distance = 0.0;
            for (Cell left : this.leftCells) {
                distance += Math.sqrt(BigGlobeMath.squareI(this.getLeftCenterX() - left.getRightCenterX(), this.getLeftCenterY() - left.getRightCenterY()));
            }
            for (Cell right : this.rightCells) {
                distance += Math.sqrt(BigGlobeMath.squareD(right.getLeftCenterX() - this.getRightCenterX(), right.getLeftCenterY() - this.getRightCenterY()));
            }
            return distance;
        }

        public void draw() {
            if (this.layout == null) {
                return;
            }
            Graphics2D graphics = this.column.graph.graphics;
            graphics.setColor(Color.WHITE);
            graphics.fillRoundRect(this.getRectangleX(), this.getRectangleY(), this.getRectangleWidth(), this.getRectangleHeight(), 16, 16);
            graphics.setColor(new Color(this.color));
            graphics.drawRoundRect(this.getRectangleX(), this.getRectangleY(), this.getRectangleWidth(), this.getRectangleHeight(), 16, 16);
            this.layout.draw(graphics, this.getTextX(), this.getTextY());
        }
    }

    public static class Column {
        public final Graph graph;
        public List<Cell> rows;
        public int slotX;
        public int posX;
        public int width;

        public Column(Graph graph, int slotX, int posX) {
            this.graph = graph;
            this.slotX = slotX;
            this.posX = posX;
            this.rows = new ArrayList<Cell>(16);
        }

        public void addCell(Cell cell) {
            cell.slotY = this.rows.size();
            this.rows.add(cell);
        }
    }
}

