/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted2.entries;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.common.FactoryContext;
import builderb0y.autocodec.data.BooleanData;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.columns.scripted.MappedRangeArray;
import builderb0y.bigglobe.columns.scripted.MappedRangeNumberArray;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.classes.ElementSpec;
import builderb0y.bigglobe.columns.scripted2.AccessSchema;
import builderb0y.bigglobe.columns.scripted2.ColumnEntryRegistry;
import builderb0y.bigglobe.columns.scripted2.ColumnValueException;
import builderb0y.bigglobe.columns.scripted2.Valid;
import builderb0y.bigglobe.columns.scripted2.entries.NonConstantColumnEntry;
import builderb0y.bigglobe.noise.Grid2D;
import builderb0y.bigglobe.noise.Grid3D;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.settings.Seed;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.lang.annotation.Annotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UseCoder(name="new", in=Coder.class, usage=MemberUsage.METHOD_IS_FACTORY)
public class NoiseColumnEntry
extends NonConstantColumnEntry {
    @Nullable
    public final Seed seed;
    public final Grid2D grid2D;
    public final Grid3D grid3D;

    public NoiseColumnEntry(AccessSchema params, @VerifyNullable Valid valid, boolean cache, Grid2D grid2D, Grid3D grid3D, @Nullable Seed seed) {
        super(params, valid, cache);
        this.seed = seed;
        this.grid2D = grid2D;
        this.grid3D = grid3D;
    }

    @Override
    public void verify(ColumnEntryRegistry registry) throws ColumnValueException {
        super.verify(registry);
        if (!ElementSpec.asType(this.params.type()).getTypeInfo().isFloat()) {
            throw new ColumnValueException("Noise-based column values must be of type float or double.");
        }
    }

    @Override
    public InsnTree makeComputer(ColumnEntryRegistry registry, NonConstantColumnEntry.NonConstantColumnEntryContext context) throws ScriptParsingException {
        InsnTree loadColumn = registry.columnCompileContext.loadColumn();
        if (this.params.is_3d()) {
            return InsnTrees.invokeInstance(InsnTrees.ldc(this.grid3D, InsnTrees.type(Grid3D.class)), Grid3D.INFO.getValue, InsnTrees.ldc(this.seed(registry)), InsnTrees.invokeInstance(loadColumn, ScriptedColumn.INFO.x, new InsnTree[0]), InsnTrees.load("y", TypeInfos.INT), InsnTrees.invokeInstance(loadColumn, ScriptedColumn.INFO.z, new InsnTree[0]));
        }
        return InsnTrees.invokeInstance(InsnTrees.ldc(this.grid2D, InsnTrees.type(Grid2D.class)), Grid2D.INFO.getValue, InsnTrees.ldc(this.seed(registry)), InsnTrees.invokeInstance(loadColumn, ScriptedColumn.INFO.x, new InsnTree[0]), InsnTrees.invokeInstance(loadColumn, ScriptedColumn.INFO.z, new InsnTree[0]));
    }

    @Override
    public InsnTree makeBulkComputer(ColumnEntryRegistry registry, NonConstantColumnEntry.NonConstantColumnEntryContext context) throws ScriptParsingException {
        assert (this.params.is_3d()) : "Requesting bulk computer for 2D noise";
        LoadInsnTree loadColumn = InsnTrees.load("this", registry.columnCompileContext.columnTypeInfo());
        InsnTree loadMappedArray = InsnTrees.getField(loadColumn, context.valueField.info);
        return InsnTrees.invokeInstance(InsnTrees.ldc(this.grid3D, InsnTrees.type(Grid3D.class)), Grid3D.INFO.getBulkY, InsnTrees.ldc(this.seed(registry)), InsnTrees.invokeInstance(loadColumn, ScriptedColumn.INFO.x, new InsnTree[0]), InsnTrees.getField(loadMappedArray, MappedRangeArray.INFO.minCached), InsnTrees.invokeInstance(loadColumn, ScriptedColumn.INFO.z, new InsnTree[0]), InsnTrees.invokeInstance(loadMappedArray, MappedRangeNumberArray.CACHED_PREFIX, new InsnTree[0]));
    }

    public long seed(ColumnEntryRegistry registry) {
        return this.seed != null ? this.seed.value : Permuter.permute(0L, UnregisteredObjectException.getID(registry.entryOf(this)));
    }

    public static class Coder
    extends AutoCoder.NamedCoder<NoiseColumnEntry> {
        public final AutoCoder<AccessSchema> params;
        public final AutoCoder<Valid> valid;
        public final AutoCoder<Boolean> cache;
        public final AutoCoder<Grid2D> grid2D;
        public final AutoCoder<Grid3D> grid3D;
        public final AutoCoder<Seed> seed;

        public Coder(FactoryContext<NoiseColumnEntry> context) {
            super(context.type);
            this.params = context.type(ReifiedType.from(AccessSchema.class)).forceCreateCoder();
            this.valid = context.type(ReifiedType.from(Valid.class).addAnnotation((Annotation)VerifyNullable.INSTANCE)).forceCreateCoder();
            this.cache = context.type((ReifiedType)new ReifiedType<Boolean>(this){}).forceCreateCoder();
            this.grid2D = context.type(ReifiedType.from(Grid2D.class)).forceCreateCoder();
            this.grid3D = context.type(ReifiedType.from(Grid3D.class)).forceCreateCoder();
            this.seed = context.type((ReifiedType)new ReifiedType<Seed>(this){}).forceCreateCoder();
        }

        @Nullable
        public <T_Encoded> NoiseColumnEntry decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
            Seed seed;
            if (context.isEmpty()) {
                return null;
            }
            AccessSchema params = (AccessSchema)((DecodeContext)context.forceGetMember("params")).decodeWith(this.params);
            Valid valid = (Valid)((DecodeContext)context.forceGetMember("valid")).decodeWith(this.valid);
            boolean cache = (Boolean)((DecodeContext)context.forceGetMember("cache")).decodeWith(this.cache);
            DecodeContext encodedSeed = (DecodeContext)context.forceGetMember("seed");
            Seed seed2 = seed = encodedSeed.isEmpty() ? null : (Seed)encodedSeed.decodeWith(this.seed);
            if (params.is_3d()) {
                Grid3D grid = (Grid3D)((DecodeContext)context.forceGetMember("grid")).decodeWith(this.grid3D);
                return new NoiseColumnEntry(params, valid, cache, null, grid, seed);
            }
            Grid2D grid = (Grid2D)((DecodeContext)context.forceGetMember("grid")).decodeWith(this.grid2D);
            return new NoiseColumnEntry(params, valid, cache, grid, null, seed);
        }

        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, NoiseColumnEntry> context) throws EncodeException {
            NoiseColumnEntry entry = (NoiseColumnEntry)context.object;
            if (entry == null) {
                return EmptyData.INSTANCE;
            }
            MapData map = new MapData(8);
            map.put("params", context.object((Object)entry.params).encodeWith(this.params));
            if (entry.valid != null) {
                map.put("valid", context.object((Object)entry.valid).encodeWith(this.valid));
            }
            if (!entry.cache) {
                map.put("cache", (Data)new BooleanData(false));
            }
            map.put("grid", entry.params.is_3d() ? context.object((Object)entry.grid3D).encodeWith(this.grid3D) : context.object((Object)entry.grid2D).encodeWith(this.grid2D));
            if (entry.seed != null) {
                map.put("seed", context.object((Object)entry.seed).encodeWith(this.seed));
            }
            return map;
        }
    }
}

