/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted2.entries;

import builderb0y.autocodec.annotations.AddPseudoField;
import builderb0y.autocodec.annotations.DefaultBoolean;
import builderb0y.autocodec.annotations.DefaultDouble;
import builderb0y.autocodec.annotations.DefaultEmpty;
import builderb0y.autocodec.annotations.DefaultString;
import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.classes.ElementSpec;
import builderb0y.bigglobe.columns.scripted.classes.TypeSpec;
import builderb0y.bigglobe.columns.scripted.classes.VoronoiBase;
import builderb0y.bigglobe.columns.scripted2.AccessSchema;
import builderb0y.bigglobe.columns.scripted2.ColumnEntryRegistry;
import builderb0y.bigglobe.columns.scripted2.ColumnValueException;
import builderb0y.bigglobe.columns.scripted2.Valid;
import builderb0y.bigglobe.columns.scripted2.entries.NonConstantColumnEntry;
import builderb0y.bigglobe.mixinInterfaces.AdjustableRegistryOps;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.randomLists.RandomList;
import builderb0y.bigglobe.settings.VoronoiDiagram2D;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.fields.NullableInstanceGetFieldInsnTree;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleRBTreeMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3542;
import net.minecraft.class_6880;

@AddPseudoField(value="decodeContext")
public class VoronoiColumnEntry
extends NonConstantColumnEntry {
    public static final MethodHandle RANDOMIZE;
    public final VoronoiDiagram2D diagram;
    public final class_6880<ElementSpec> base_class;
    public final class_2960 classes;
    public final transient Object2DoubleMap<class_6880<ElementSpec>> weightedClasses;

    public VoronoiColumnEntry(AccessSchema params, @VerifyNullable Valid valid, VoronoiDiagram2D diagram, class_6880<ElementSpec> base_class, class_2960 classes, DecodeContext<?> decodeContext) throws DecodeException {
        super(params, valid, true);
        this.diagram = diagram;
        this.base_class = base_class;
        this.classes = classes;
        this.weightedClasses = VoronoiOptions.load(decodeContext.ops, classes);
    }

    public DecodeContext<?> decodeContext() {
        return null;
    }

    @Override
    public void verify(ColumnEntryRegistry registry) throws ColumnValueException {
        super.verify(registry);
        if (this.params.is_3d()) {
            throw new ColumnValueException("3D voronoi column values are not yet supported.");
        }
        TypeInfo baseTypeInfo = ElementSpec.asType(this.base_class).getTypeInfo();
        if (!baseTypeInfo.extendsOrImplements(VoronoiBase.INFO.type)) {
            throw new ColumnValueException(String.valueOf(UnregisteredObjectException.getID(registry.entryOf(this))) + " uses non-voronoi base_class " + String.valueOf(UnregisteredObjectException.getID(this.base_class)));
        }
        for (class_6880 entry : this.weightedClasses.keySet()) {
            TypeSpec type = ElementSpec.asType((class_6880<ElementSpec>)entry);
            if (!type.getTypeInfo().extendsOrImplements(baseTypeInfo)) {
                throw new ColumnValueException(String.valueOf(UnregisteredObjectException.getID(registry.entryOf(this))) + " includes " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in its classes tag, but that class does not extend the base_class " + String.valueOf(UnregisteredObjectException.getID(this.base_class)));
            }
            if (!type.isAbstract()) continue;
            throw new ColumnValueException(String.valueOf(UnregisteredObjectException.getID(registry.entryOf(this))) + " includes " + String.valueOf(UnregisteredObjectException.getID(entry)) + " in its classes tag, but that class is abstract.");
        }
    }

    @Override
    public InsnTree makeComputer(ColumnEntryRegistry registry, NonConstantColumnEntry.NonConstantColumnEntryContext context) throws ScriptParsingException {
        InsnTree loadColumn = registry.columnCompileContext.loadColumn();
        return InsnTrees.invokeDynamic(MethodInfo.inCaller("createRandomizer"), new MethodInfo(9, TypeInfos.OBJECT, "randomize", ElementSpec.asType(this.base_class).getTypeInfo(), InsnTrees.type(ScriptedColumn.class), InsnTrees.type(VoronoiDiagram2D.class)), (ConstantValue[])Stream.concat(Stream.of(InsnTrees.constant(Permuter.permute(0L, UnregisteredObjectException.getID(registry.entryOf(this))))), this.weightedClasses.object2DoubleEntrySet().stream().flatMap(entry -> Stream.of(InsnTrees.constant(ElementSpec.asType((class_6880<ElementSpec>)((class_6880)entry.getKey())).getTypeInfo()), InsnTrees.constant(entry.getDoubleValue())))).toArray((IntFunction<A[]>)ConstantValue.ARRAY_FACTORY), new InsnTree[]{loadColumn, InsnTrees.invokeInstance(InsnTrees.ldc(this.diagram, InsnTrees.type(VoronoiDiagram2D.class)), MethodInfo.findMethod(VoronoiDiagram2D.class, "getNearestCell", VoronoiDiagram2D.Cell.class, Integer.TYPE, Integer.TYPE, VoronoiDiagram2D.Cell.class), InsnTrees.invokeInstance(loadColumn, ScriptedColumn.INFO.x, new InsnTree[0]), InsnTrees.invokeInstance(loadColumn, ScriptedColumn.INFO.z, new InsnTree[0]), new NullableInstanceGetFieldInsnTree(InsnTrees.getField(loadColumn, context.valueField.info), VoronoiBase.INFO.$cell))});
    }

    public static CallSite createRandomizer(MethodHandles.Lookup caller, String name, MethodType methodType, long seed, Object ... options) throws Throwable {
        if (!VoronoiBase.class.isAssignableFrom((Class<?>)methodType.returnType())) {
            throw new IllegalArgumentException("Invalid super class: " + String.valueOf(((Class)methodType.returnType()).getSuperclass()));
        }
        if ((options.length & 1) != 0) {
            throw new IllegalArgumentException("Options array is odd-length");
        }
        if (options.length == 0) {
            if (Modifier.isAbstract(((Class)methodType.returnType()).getModifiers())) {
                throw new IllegalArgumentException("No options");
            }
            return new ConstantCallSite(caller.findConstructor((Class<?>)methodType.returnType(), methodType.changeReturnType(Void.TYPE)));
        }
        MethodType constructorType = methodType.changeReturnType(Void.TYPE);
        MethodType factoryType = methodType.changeReturnType(VoronoiBase.class);
        RandomList<VoronoiBase.Factory> list = new RandomList<VoronoiBase.Factory>(options.length >> 1);
        for (int baseIndex = 0; baseIndex < options.length; baseIndex += 2) {
            Class clazz = ((Class)options[baseIndex]).asSubclass(methodType.returnType());
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new IllegalArgumentException(String.valueOf(clazz) + " is abstract.");
            }
            double weight = (Double)options[baseIndex | 1];
            VoronoiBase.Factory factory = LambdaMetafactory.metafactory(caller, "create", MethodType.methodType(VoronoiBase.Factory.class), factoryType, caller.findConstructor(clazz, constructorType), methodType).getTarget().invokeExact();
            list.add(factory, weight);
        }
        return new ConstantCallSite(MethodHandles.insertArguments(RANDOMIZE, 0, list.optimize(), seed).asType(methodType));
    }

    public static VoronoiBase randomize(IRandomList<VoronoiBase.Factory> factories, long baseSeed, ScriptedColumn column, VoronoiDiagram2D.Cell cell) {
        return factories.getRandomElement(cell.center.getSeed(baseSeed)).create(column, cell);
    }

    @Override
    public InsnTree makeBulkComputer(ColumnEntryRegistry registry, NonConstantColumnEntry.NonConstantColumnEntryContext context) throws ScriptParsingException {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            RANDOMIZE = MethodHandles.lookup().findStatic(VoronoiColumnEntry.class, "randomize", MethodType.methodType(VoronoiBase.class, IRandomList.class, Long.TYPE, ScriptedColumn.class, VoronoiDiagram2D.Cell.class));
        }
        catch (Exception exception) {
            throw AutoCodecUtil.rethrow((Throwable)exception);
        }
    }

    public record VoronoiOptions(@DefaultBoolean(value=false) boolean replace, VoronoiOption @DefaultEmpty [] values) {
        public static final AutoCoder<VoronoiOptions> CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(VoronoiOptions.class);

        public static <T> Object2DoubleMap<class_6880<ElementSpec>> load(DynamicOps<T> ops, class_2960 tagID) throws DecodeException {
            Object2DoubleRBTreeMap result = new Object2DoubleRBTreeMap(Comparator.comparing(UnregisteredObjectException::getID));
            for (class_3298 resource : BigGlobeMod.getResourceManager().method_14489(IdentifierVersions.create(tagID.method_12836(), "worldgen/bigglobe_voronoi_options/" + tagID.method_12832() + ".json"))) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        ((VoronoiOptions)BigGlobeAutoCodec.AUTO_CODEC.decode(CODER, (Object)JsonParser.parseReader((Reader)reader), ((AdjustableRegistryOps)ops).bigglobe_changeType(JsonOps.INSTANCE))).addTo((Object2DoubleMap<class_6880<ElementSpec>>)result);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException exception) {
                    throw new DecodeException((Throwable)exception);
                }
            }
            return result;
        }

        public void addTo(Object2DoubleMap<class_6880<ElementSpec>> classes) {
            if (this.replace) {
                classes.clear();
            }
            for (VoronoiOption value : this.values) {
                value.addTo(classes);
            }
        }
    }

    public record VoronoiOption(@DefaultString(value="add") Operation operation, @UseName(value="class") class_6880<ElementSpec> clazz, @DefaultDouble(value=1.0) double weight) {
        public void addTo(Object2DoubleMap<class_6880<ElementSpec>> classes) {
            switch (this.operation.ordinal()) {
                case 0: {
                    classes.put(this.clazz, this.weight);
                    break;
                }
                case 1: {
                    classes.removeDouble(this.clazz);
                }
            }
        }

        public static enum Operation implements class_3542
        {
            ADD,
            REMOVE;

            public final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);

            public String method_15434() {
                return this.lowerCaseName;
            }
        }
    }
}

