/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.compat.dhChunkGen;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.chunkgen.QuadHolder;
import builderb0y.bigglobe.chunkgen.scripted.BlockSegmentList;
import builderb0y.bigglobe.chunkgen.scripted.Layer;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.compat.DistantHorizonsCompat;
import builderb0y.bigglobe.compat.dhChunkGen.DataPointListBuilder;
import builderb0y.bigglobe.util.AsyncRunner;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.versions.RegistryVersions;
import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGeneratorReturnType;
import com.seibel.distanthorizons.api.interfaces.block.IDhApiBiomeWrapper;
import com.seibel.distanthorizons.api.interfaces.override.worldGenerator.IDhApiWorldGenerator;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.objects.data.DhApiChunk;
import com.seibel.distanthorizons.api.objects.data.IDhApiFullDataSource;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.minecraft.class_1972;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class DhScriptedWorldGenerator
implements IDhApiWorldGenerator {
    public final IDhApiLevelWrapper level;
    public final class_3218 serverWorld;
    public final BigGlobeScriptedChunkGenerator chunkGenerator;
    public final ThreadLocal<ScriptedColumn[]> columns;
    public final byte topSkylight;

    public DhScriptedWorldGenerator(IDhApiLevelWrapper level, class_3218 serverWorld, BigGlobeScriptedChunkGenerator chunkGenerator) {
        this.level = level;
        this.serverWorld = serverWorld;
        this.chunkGenerator = chunkGenerator;
        this.columns = new ThreadLocal();
        this.topSkylight = (byte)(serverWorld.method_8597().comp_642() ? 15 : 0);
    }

    public ScriptedColumn[] getColumns(int length) {
        ScriptedColumn[] columns = this.columns.get();
        if (columns == null || columns.length < length) {
            columns = new ScriptedColumn[length];
            ScriptedColumn.Params params = new ScriptedColumn.Params(this.chunkGenerator, 0, 0, ScriptedColumn.ColumnUsage.RAW_GENERATION.normalHints());
            ScriptedColumn.Factory factory = this.chunkGenerator.columnEntryRegistry.columnFactory;
            for (int index = 0; index < length; ++index) {
                if (columns[index] == null) {
                    columns[index] = factory.create(params);
                    continue;
                }
                columns[index].setParamsUnchecked(params);
            }
            this.columns.set(columns);
        }
        return columns;
    }

    public byte getLargestDataDetailLevel() {
        return 20;
    }

    public CompletableFuture<Void> generateLod(int chunkPosMinX, int chunkPosMinZ, int lodPosX, int lodPosZ, byte detailLevel, IDhApiFullDataSource pooledFullDataSource, EDhApiDistantGeneratorMode generatorMode, ExecutorService worldGeneratorThreadPool, Consumer<IDhApiFullDataSource> resultConsumer) {
        return CompletableFuture.runAsync(() -> {
            int step = 1 << detailLevel;
            int startX = chunkPosMinX << 4;
            int startZ = chunkPosMinZ << 4;
            int width = pooledFullDataSource.getWidthInDataColumns();
            int totalColumns = width * width;
            BigGlobeScriptedChunkGenerator generator = this.chunkGenerator;
            ScriptedColumn[] columns = this.getColumns(totalColumns);
            IDhApiBiomeWrapper biome = DhApi.Delayed.wrapperFactory.getBiomeWrapper(new Object[]{RegistryVersions.getEntry(this.serverWorld.method_30349(), class_1972.field_9451)}, this.level);
            int yOffset = generator.height.min_y();
            DataPointListBuilder[] dataPointBuilders = new DataPointListBuilder[totalColumns];
            for (int index = 0; index < totalColumns; ++index) {
                dataPointBuilders[index] = new DataPointListBuilder(this.level, 0, biome, yOffset);
            }
            Layer layer = (Layer)generator.layer.comp_349();
            ScriptedColumn.Params params = new ScriptedColumn.Params(this.chunkGenerator, 0, 0, ScriptedColumn.ColumnUsage.RAW_GENERATION.dhHints(detailLevel));
            try (AsyncRunner async = BigGlobeThreadPool.lodRunner();){
                for (int offsetZ = 0; offsetZ < width; offsetZ += 2) {
                    int offsetZ_ = offsetZ;
                    for (int offsetX = 0; offsetX < width; offsetX += 2) {
                        int offsetX_ = offsetX;
                        async.submit(() -> {
                            int baseIndex = offsetZ_ * width + offsetX_;
                            int quadX = startX | offsetX_ << detailLevel;
                            int quadZ = startZ | offsetZ_ << detailLevel;
                            QuadHolder.QuadColumn quadColumn = new QuadHolder.QuadColumn();
                            quadColumn.loadFromArray(columns, baseIndex, width);
                            quadColumn.at(params, quadX, quadZ, step);
                            QuadHolder.QuadList quadList = new QuadHolder.QuadList();
                            quadList.createNew(generator.height.min_y(), generator.height.max_y());
                            QuadHolder.generate(quadColumn, quadList, layer);
                            this.convertToDataPoints(quadList, dataPointBuilders, baseIndex, width);
                        });
                    }
                }
            }
            for (int offsetZ = 0; offsetZ < width; ++offsetZ) {
                for (int offsetX = 0; offsetX < width; ++offsetX) {
                    pooledFullDataSource.setApiDataPointColumn(offsetX, offsetZ, (List)dataPointBuilders[offsetZ * width + offsetX]);
                }
            }
            resultConsumer.accept(pooledFullDataSource);
        }, worldGeneratorThreadPool);
    }

    public CompletableFuture<Void> generateApiChunks(int chunkPosMinX, int chunkPosMinZ, byte granularity, byte targetDataDetail, EDhApiDistantGeneratorMode generatorMode, ExecutorService worldGeneratorThreadPool, Consumer<DhApiChunk> resultConsumer) {
        return this.generateApiChunks(chunkPosMinX, chunkPosMinZ, 1 << granularity - 4, targetDataDetail, generatorMode, worldGeneratorThreadPool, resultConsumer);
    }

    public CompletableFuture<Void> generateApiChunks(int chunkPosMinX, int chunkPosMinZ, int chunkWidth, byte targetDataDetail, EDhApiDistantGeneratorMode generatorMode, ExecutorService worldGeneratorThreadPool, Consumer<DhApiChunk> resultConsumer) {
        return CompletableFuture.runAsync(() -> {
            int chunkPosMaxX = chunkPosMinX + chunkWidth;
            int chunkPosMaxZ = chunkPosMinZ + chunkWidth;
            for (int chunkZ = chunkPosMinZ; chunkZ < chunkPosMaxZ; ++chunkZ) {
                for (int chunkX = chunkPosMinX; chunkX < chunkPosMaxX; ++chunkX) {
                    try {
                        resultConsumer.accept(this.generateChunkOfDataPoints(chunkX, chunkZ));
                        continue;
                    }
                    catch (Throwable throwable) {
                        BigGlobeMod.LOGGER.error("An error occurred in a hyperspeed DH world generator for chunk [" + chunkX + ", " + chunkZ + "]", throwable);
                        throw AutoCodecUtil.rethrow((Throwable)throwable);
                    }
                }
            }
        }, worldGeneratorThreadPool);
    }

    public DhApiChunk generateChunkOfDataPoints(int chunkX, int chunkZ) {
        IDhApiBiomeWrapper biome = DhApi.Delayed.wrapperFactory.getBiomeWrapper(new Object[]{RegistryVersions.getEntry(this.serverWorld.method_30349(), class_1972.field_9451)}, this.level);
        DataPointListBuilder[] dataPointBuilders = new DataPointListBuilder[256];
        for (int index = 0; index < 256; ++index) {
            dataPointBuilders[index] = new DataPointListBuilder(this.level, 0, biome, 0);
        }
        ScriptedColumn[] columns = this.chunkGenerator.chunkReuseColumns.get();
        ScriptedColumn.Params params = new ScriptedColumn.Params(this.chunkGenerator, 0, 0, ScriptedColumn.ColumnUsage.RAW_GENERATION.dhHints(0));
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        try (AsyncRunner async = BigGlobeThreadPool.lodRunner();){
            for (int offsetZ = 0; offsetZ < 16; offsetZ += 2) {
                int offsetZ_ = offsetZ;
                for (int offsetX = 0; offsetX < 16; offsetX += 2) {
                    int offsetX_ = offsetX;
                    async.submit(() -> {
                        int minY = this.chunkGenerator.height.min_y();
                        int maxY = this.chunkGenerator.height.max_y();
                        Layer layer = (Layer)this.chunkGenerator.layer.comp_349();
                        int baseIndex = offsetZ_ << 4 | offsetX_;
                        int quadX = startX | offsetX_;
                        int quadZ = startZ | offsetZ_;
                        QuadHolder.QuadColumn quadColumn = new QuadHolder.QuadColumn();
                        quadColumn.loadFromArray(columns, baseIndex, 16);
                        quadColumn.at(params, quadX, quadZ, 1);
                        QuadHolder.QuadList quadList = new QuadHolder.QuadList();
                        quadList.createNew(minY, maxY);
                        QuadHolder.generate(quadColumn, quadList, layer);
                        this.convertToDataPoints(quadList, dataPointBuilders, baseIndex, 16);
                    });
                }
            }
        }
        int chunkBottomY = this.chunkGenerator.height.min_y();
        int chunkTopY = this.chunkGenerator.height.max_y();
        DhApiChunk results = DistantHorizonsCompat.DHCode.newChunk(chunkX, chunkZ, chunkBottomY, chunkTopY);
        for (int index = 0; index < 256; ++index) {
            results.setDataPoints(index & 0xF, index >>> 4, (List)dataPointBuilders[index]);
        }
        return results;
    }

    public void convertToDataPoints(QuadHolder.QuadList quadList, DataPointListBuilder[] dataPointBuilders, int baseIndex, int zOffset) {
        this.convertToDataPoints(dataPointBuilders[baseIndex], (BlockSegmentList)((Object)quadList.object00));
        this.convertToDataPoints(dataPointBuilders[baseIndex + 1], (BlockSegmentList)((Object)quadList.object01));
        this.convertToDataPoints(dataPointBuilders[baseIndex + zOffset], (BlockSegmentList)((Object)quadList.object10));
        this.convertToDataPoints(dataPointBuilders[baseIndex + zOffset + 1], (BlockSegmentList)((Object)quadList.object11));
    }

    public void convertToDataPoints(DataPointListBuilder builder, BlockSegmentList segments) {
        segments.computeLightLevels(this.topSkylight);
        int index = segments.size();
        while (--index >= 0) {
            BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)segments.get(index);
            builder.skyLightLevel = segment.skylightLevel;
            builder.add((class_2680)segment.value, segment.minY, segment.maxY + 1);
        }
    }

    public EDhApiWorldGeneratorReturnType getReturnType() {
        return EDhApiWorldGeneratorReturnType.API_DATA_SOURCES;
    }

    public void preGeneratorTaskStart() {
    }

    public void close() {
    }
}

