/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.entities;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.entities.BigGlobeEntityRenderer;
import builderb0y.bigglobe.entities.StringEntity;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.versions.EntityVersions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class StringEntityRenderer
extends BigGlobeEntityRenderer<StringEntity, State> {
    public static final class_2960 TEXTURE = BigGlobeMod.modID("textures/entity/string.png");

    public StringEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public class_1921 getRenderLayer() {
        return class_1921.method_23572((class_2960)TEXTURE);
    }

    @Override
    public void doRender(final State state, final class_4587.class_4665 matrix, final class_4588 buffer, class_243 cameraPosition, final int light) {
        Vector3d scratch = new Vector3d();
        class VertexHelper {
            VertexHelper() {
            }

            public VertexHelper add(Vector3d pos, float u, float v, Vector3d normal, double normalMultiplier) {
                return this.add(pos, u, v, normal, normalMultiplier, class_765.method_23687((int)VertexHelper.lerpInt(class_765.method_24186((int)light), class_765.method_24186((int)state.lightC), u), (int)VertexHelper.lerpInt(class_765.method_24187((int)light), class_765.method_24187((int)state.lightC), u)));
            }

            public VertexHelper add(Vector3d pos, float u, float v, Vector3d normal, double normalMultiplier, int lightLevel) {
                buffer.method_22918(matrix.method_23761(), (float)(pos.x - state.posB.field_1352), (float)(pos.y - state.posB.field_1351), (float)(pos.z - state.posB.field_1350)).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(lightLevel).method_60831(matrix, (float)(normal.x * normalMultiplier), (float)(normal.y * normalMultiplier), (float)(normal.z * normalMultiplier));
                return this;
            }

            public static int lerpInt(int low, int high, float level) {
                return Math.min(BigGlobeMath.floorI(Interpolator.mixLinear(low, high + 1, level)), high);
            }
        }
        VertexHelper helper = new VertexHelper();
        if (state.nextEntity) {
            BendVector from = new BendVector(state.posA, state.posB, state.posC, state.posD);
            BendVector to = new BendVector(from);
            from.setFrac(0.0);
            if (!state.prevEntity) {
                helper.add(scratch.set((Vector3dc)from.position).sub((Vector3dc)from.right).add((Vector3dc)from.up), 0.0f, 0.5f, from.forward, -1.0, state.lightB).add(scratch.set((Vector3dc)from.position).sub((Vector3dc)from.right), 0.0f, 0.625f, from.forward, -1.0, state.lightB).add(scratch.set((Vector3dc)from.position).add((Vector3dc)from.right), 0.125f, 0.625f, from.forward, -1.0, state.lightB).add(scratch.set((Vector3dc)from.position).add((Vector3dc)from.right).add((Vector3dc)from.up), 0.125f, 0.5f, from.forward, -1.0, state.lightB);
            }
            int segmentCount = Math.max(this.calcSegments(state.posA, state.posB, state.posC), this.calcSegments(state.posB, state.posC, state.posD));
            for (int segment = 0; segment < segmentCount; ++segment) {
                to.setFrac((double)(segment + 1) / (double)segmentCount);
                float u0 = (float)segment / (float)segmentCount;
                float u1 = (float)(segment + 1) / (float)segmentCount;
                helper.add(scratch.set((Vector3dc)from.position).sub((Vector3dc)from.right).add((Vector3dc)from.up), u0, 0.0f, from.up, 8.0).add(scratch.set((Vector3dc)from.position).add((Vector3dc)from.right).add((Vector3dc)from.up), u0, 0.125f, from.up, 8.0).add(scratch.set((Vector3dc)to.position).add((Vector3dc)to.right).add((Vector3dc)to.up), u1, 0.125f, to.up, 8.0).add(scratch.set((Vector3dc)to.position).sub((Vector3dc)to.right).add((Vector3dc)to.up), u1, 0.0f, to.up, 8.0).add(scratch.set((Vector3dc)from.position).add((Vector3dc)from.right).add((Vector3dc)from.up), u0, 0.125f, from.right, 16.0).add(scratch.set((Vector3dc)from.position).add((Vector3dc)from.right), u0, 0.25f, from.right, 16.0).add(scratch.set((Vector3dc)to.position).add((Vector3dc)to.right), u1, 0.25f, to.right, 16.0).add(scratch.set((Vector3dc)to.position).add((Vector3dc)to.right).add((Vector3dc)to.up), u1, 0.125f, to.right, 16.0).add(scratch.set((Vector3dc)to.position).sub((Vector3dc)to.right).add((Vector3dc)to.up), u1, 0.25f, to.right, -16.0).add(scratch.set((Vector3dc)to.position).sub((Vector3dc)to.right), u1, 0.375f, to.right, -16.0).add(scratch.set((Vector3dc)from.position).sub((Vector3dc)from.right), u0, 0.375f, from.right, -16.0).add(scratch.set((Vector3dc)from.position).sub((Vector3dc)from.right).add((Vector3dc)from.up), u0, 0.25f, from.right, -16.0).add(scratch.set((Vector3dc)from.position).add((Vector3dc)from.right), u0, 0.375f, from.up, -8.0).add(scratch.set((Vector3dc)from.position).sub((Vector3dc)from.right), u0, 0.5f, from.up, -8.0).add(scratch.set((Vector3dc)to.position).sub((Vector3dc)to.right), u1, 0.5f, to.up, -8.0).add(scratch.set((Vector3dc)to.position).add((Vector3dc)to.right), u1, 0.375f, to.up, -8.0);
                BendVector tmp = from;
                from = to;
                to = tmp;
            }
            if (!state.nextNextEntity) {
                helper.add(scratch.set((Vector3dc)from.position).add((Vector3dc)from.right).add((Vector3dc)from.up), 0.875f, 0.5f, from.forward, 1.0, state.lightC).add(scratch.set((Vector3dc)from.position).add((Vector3dc)from.right), 0.875f, 0.625f, from.forward, 1.0, state.lightC).add(scratch.set((Vector3dc)from.position).sub((Vector3dc)from.right), 1.0f, 0.625f, from.forward, 1.0, state.lightC).add(scratch.set((Vector3dc)from.position).sub((Vector3dc)from.right).add((Vector3dc)from.up), 1.0f, 0.5f, from.forward, 1.0, state.lightC);
            }
        } else if (!state.prevEntity) {
            Vector3d origin = new Vector3d(state.posB.field_1352, state.posB.field_1351, state.posB.field_1350);
            Vector3d normal = new Vector3d();
            normal.set(0.0, 0.0, -1.0);
            helper.add(scratch.set((Vector3dc)origin).add(0.0625, 0.125, -0.0625), 0.0f, 0.875f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.0, -0.0625), 0.0f, 1.0f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(-0.0625, 0.0, -0.0625), 0.125f, 1.0f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(-0.0625, 0.125, -0.0625), 0.125f, 0.875f, normal, 1.0, state.lightB);
            normal.set(-1.0, 0.0, 0.0);
            helper.add(scratch.set((Vector3dc)origin).add(-0.0625, 0.125, -0.0625), 0.125f, 0.875f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(-0.0625, 0.0, -0.0625), 0.125f, 1.0f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(-0.0625, 0.0, 0.0625), 0.25f, 1.0f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(-0.0625, 0.125, 0.0625), 0.25f, 0.875f, normal, 1.0, state.lightB);
            normal.set(0.0, 0.0, 1.0);
            helper.add(scratch.set((Vector3dc)origin).add(-0.0625, 0.125, 0.0625), 0.25f, 0.875f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(-0.0625, 0.0, 0.0625), 0.25f, 1.0f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.0, 0.0625), 0.375f, 1.0f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.125, 0.0625), 0.375f, 0.875f, normal, 1.0, state.lightB);
            normal.set(1.0, 0.0, 0.0);
            helper.add(scratch.set((Vector3dc)origin).add(0.0625, 0.125, 0.0625), 0.375f, 0.875f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.0, 0.0625), 0.375f, 1.0f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.0, -0.0625), 0.5f, 1.0f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.125, -0.0625), 0.5f, 0.875f, normal, 1.0, state.lightB);
            normal.set(0.0, 1.0, 0.0);
            helper.add(scratch.set((Vector3dc)origin).add(-0.0625, 0.125, -0.0625), 0.0f, 0.75f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(-0.0625, 0.125, 0.0625), 0.0f, 0.875f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.125, 0.0625), 0.125f, 0.875f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.125, -0.0625), 0.125f, 0.75f, normal, 1.0, state.lightB);
            normal.set(0.0, -1.0, 0.0);
            helper.add(scratch.set((Vector3dc)origin).add(-0.0625, 0.0, 0.0625), 0.125f, 0.75f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(-0.0625, 0.0, -0.0625), 0.125f, 0.875f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.0, -0.0625), 0.25f, 0.875f, normal, 1.0, state.lightB).add(scratch.set((Vector3dc)origin).add(0.0625, 0.0, 0.0625), 0.25f, 0.75f, normal, 1.0, state.lightB);
        }
    }

    @Nullable
    public static class_243 getPos(class_1297 entity, float tickDelta) {
        return entity == null ? null : new class_243(Interpolator.mixLinear(EntityVersions.prevX(entity), entity.method_23317(), (double)tickDelta), Interpolator.mixLinear(EntityVersions.prevY(entity), entity.method_23318(), (double)tickDelta), Interpolator.mixLinear(EntityVersions.prevZ(entity), entity.method_23321(), (double)tickDelta));
    }

    public int calcSegments(class_243 a, class_243 b, class_243 c) {
        a = a.method_1020(b);
        c = c.method_1020(b);
        double div = a.method_1027() * c.method_1027();
        if (div == 0.0) {
            return 1;
        }
        double dot = a.method_1026(c) / Math.sqrt(div);
        dot = class_3532.method_15350((double)dot, (double)-1.0, (double)1.0);
        return Math.min(Math.max(BigGlobeMath.ceilI(Math.sqrt(dot + 1.0) * 8.0), 1), 8);
    }

    public class_2960 getTexture(StringEntity entity) {
        return TEXTURE;
    }

    @Override
    public State createState() {
        return new State();
    }

    @Override
    public void updateState(StringEntity entity, State state, float partialTicks) {
        class_1297 class_12972;
        class_1297 prevEntity = entity.getPrevEntity();
        class_1297 nextEntity = entity.getNextEntity();
        if (nextEntity instanceof StringEntity) {
            StringEntity string = (StringEntity)nextEntity;
            class_12972 = string.getNextEntity();
        } else {
            class_12972 = null;
        }
        class_1297 nextNextEntity = class_12972;
        state.posA = StringEntityRenderer.getPos(prevEntity, partialTicks);
        state.posB = StringEntityRenderer.getPos(entity, partialTicks);
        state.posC = StringEntityRenderer.getPos(nextEntity, partialTicks);
        state.posD = StringEntityRenderer.getPos(nextNextEntity, partialTicks);
        if (state.posA == null) {
            state.posA = state.posB;
        }
        if (state.posD == null) {
            state.posD = state.posC;
        }
        state.lightB = this.field_4676.method_23839((class_1297)entity, partialTicks);
        state.lightC = entity.getNextEntity() != null ? this.field_4676.method_23839(entity.getNextEntity(), partialTicks) : 0;
        state.prevEntity = prevEntity != null;
        state.nextEntity = nextEntity != null;
        state.nextNextEntity = nextNextEntity != null;
    }

    public static class State
    extends BigGlobeEntityRenderer.State {
        public class_243 posA;
        public class_243 posB;
        public class_243 posC;
        public class_243 posD;
        public int lightB;
        public int lightC;
        public boolean prevEntity;
        public boolean nextEntity;
        public boolean nextNextEntity;
    }

    public static class BendVector {
        public static final Vector3d UP = new Vector3d(0.0, 1.0, 0.0);
        public final BendComponent x;
        public final BendComponent y;
        public final BendComponent z;
        public final Vector3d position;
        public final Vector3d forward;
        public final Vector3d right;
        public final Vector3d up;

        public BendVector(class_243 a, class_243 b, class_243 c, class_243 d) {
            this.x = new BendComponent(a.field_1352, b.field_1352, c.field_1352, d.field_1352);
            this.y = new BendComponent(a.field_1351, b.field_1351, c.field_1351, d.field_1351);
            this.z = new BendComponent(a.field_1350, b.field_1350, c.field_1350, d.field_1350);
            this.position = new Vector3d();
            this.forward = new Vector3d();
            this.right = new Vector3d();
            this.up = new Vector3d();
        }

        public BendVector(BendVector that) {
            this.x = new BendComponent(that.x);
            this.y = new BendComponent(that.y);
            this.z = new BendComponent(that.z);
            this.position = new Vector3d((Vector3dc)that.position);
            this.forward = new Vector3d((Vector3dc)that.forward);
            this.right = new Vector3d((Vector3dc)that.right);
            this.up = new Vector3d((Vector3dc)that.up);
        }

        public void setFrac(double frac) {
            this.x.setFrac(frac);
            this.y.setFrac(frac);
            this.z.setFrac(frac);
            this.position.set(this.x.value, this.y.value, this.z.value);
            this.forward.set(this.x.derivative, this.y.derivative, this.z.derivative);
            this.forward.cross((Vector3dc)UP, this.right);
            this.right.cross((Vector3dc)this.forward, this.up);
            this.forward.normalize();
            this.right.normalize(0.0625);
            this.up.normalize(0.125);
        }
    }

    public static class BendComponent {
        public final double term1;
        public final double term2;
        public final double term3;
        public final double term4;
        public double value;
        public final double derivativeTerm1;
        public final double derivativeTerm2;
        public final double derivativeTerm3;
        public double derivative;

        public BendComponent(double a, double b, double c, double d) {
            this.term1 = Interpolator.cubicTerm1(a, b, c, d);
            this.term2 = Interpolator.cubicTerm2(a, b, c, d);
            this.term3 = Interpolator.cubicTerm3(a, b, c, d);
            this.term4 = Interpolator.cubicTerm4(a, b, c, d);
            this.derivativeTerm1 = Interpolator.cubicDerivativeTerm1(a, b, c, d);
            this.derivativeTerm2 = Interpolator.cubicDerivativeTerm2(a, b, c, d);
            this.derivativeTerm3 = Interpolator.cubicDerivativeTerm3(a, b, c, d);
        }

        public BendComponent(BendComponent that) {
            this.term1 = that.term1;
            this.term2 = that.term2;
            this.term3 = that.term3;
            this.term4 = that.term4;
            this.value = that.value;
            this.derivativeTerm1 = that.derivativeTerm1;
            this.derivativeTerm2 = that.derivativeTerm2;
            this.derivativeTerm3 = that.derivativeTerm3;
            this.derivative = that.derivative;
        }

        public void setFrac(double frac) {
            this.value = Interpolator.combineCubicTerms(this.term1, this.term2, this.term3, this.term4, frac);
            this.derivative = Interpolator.combineCubicDerivativeTerms(this.derivativeTerm1, this.derivativeTerm2, this.derivativeTerm3, frac);
        }
    }
}

