/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.features;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.ScriptedColumnLookup;
import builderb0y.bigglobe.features.BigGlobeFeatures;
import builderb0y.bigglobe.features.FlowerFeature;
import builderb0y.bigglobe.features.SingleBlockFeature;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Grid2D;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.RestrictedList;
import builderb0y.bigglobe.randomSources.RandomSource;
import builderb0y.bigglobe.util.AsyncConsumer;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import builderb0y.bigglobe.util.WorldUtil;
import com.mojang.serialization.Codec;
import java.util.Comparator;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowerControllerFeature
extends class_3031<Config> {
    public FlowerControllerFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public FlowerControllerFeature() {
        this((Codec<Config>)BigGlobeAutoCodec.AUTO_CODEC.createDFUCodec(Config.class));
    }

    public boolean method_13151(class_5821<Config> context) {
        ScriptedColumnLookup columns = ScriptedColumnLookup.GLOBAL.getCurrent();
        if (columns == null) {
            class_2794 class_27942 = context.method_33653();
            if (class_27942 instanceof BigGlobeScriptedChunkGenerator) {
                BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
                columns = new ScriptedColumnLookup.Impl(generator.columnEntryRegistry.columnFactory, new ScriptedColumn.Params(generator, 0, 0, ScriptedColumn.ColumnUsage.FEATURES.maybeDhHints()));
            } else {
                BigGlobeMod.LOGGER.warn("Attempt to place flower controller feature outside of a Big Globe world.");
                return false;
            }
        }
        try (AsyncConsumer<QueuedPlacement> async = new AsyncConsumer<QueuedPlacement>(BigGlobeThreadPool.autoExecutor(), placement -> {
            if (placement != null) {
                this.placeQueued(context, (QueuedPlacement)((Object)placement));
            }
        });){
            int startX = context.method_33655().method_10263() & 0xFFFFFFF0;
            int startZ = context.method_33655().method_10260() & 0xFFFFFFF0;
            for (int index = 0; index < 256; ++index) {
                ScriptedColumn column = columns.lookupColumn(startX | index & 0xF, startZ | index >>> 4);
                async.submit(() -> this.getQueuedPlacement(context, column));
            }
        }
        return true;
    }

    public QueuedPlacement getQueuedPlacement(class_5821<Config> context, ScriptedColumn column) {
        int y = ((Config)context.method_33656()).y_level.get(column);
        if (context.method_33652().method_31601(y)) {
            return null;
        }
        long overlapSeed = Permuter.permute(context.method_33652().method_8412() ^ 0x3C8F9545BAE6971FL, column.x(), column.z());
        int overlapChance = 0;
        FlowerFeature.Entry chosen = null;
        RestrictedList validEntries = new RestrictedList(null, column, y);
        for (FlowerFeature.Config link : ((Config)context.method_33656()).getFlattenedFlowers()) {
            validEntries.elements = link.entries.elements;
            long groupSeed = link.seed.xor(context.method_33652().method_8412());
            int scale = link.distance;
            int variation = link.variation;
            int inGridX = BigGlobeMath.modulus_BP(column.x(), scale);
            int inGridZ = BigGlobeMath.modulus_BP(column.z(), scale);
            int gridStartX = column.x() - inGridX;
            int gridStartZ = column.z() - inGridZ;
            Grid2D flowerNoise = link.noise;
            double noise = flowerNoise.getValue(groupSeed, column.x(), column.z());
            for (int offsetX = -scale; offsetX <= scale; offsetX += scale) {
                for (int offsetZ = -scale; offsetZ <= scale; offsetZ += scale) {
                    RandomSource radiusSource;
                    FlowerFeature.Entry entry;
                    int otherGridStartX = gridStartX + offsetX;
                    int otherGridStartZ = gridStartZ + offsetZ;
                    long otherGridSeed = Permuter.permute(groupSeed ^ 0xA2BBF085229FA361L, otherGridStartX, otherGridStartZ);
                    if (!Permuter.nextChancedBoolean(otherGridSeed += -7046029254386353131L, link.spawn_chance)) continue;
                    if (Permuter.nextChancedBoolean(otherGridSeed += -7046029254386353131L, link.randomize_chance)) {
                        entry = (FlowerFeature.Entry)validEntries.getRandomElement(Permuter.permute(otherGridSeed += -7046029254386353131L, column.x(), column.z()));
                        if (entry == null) continue;
                        radiusSource = link.randomize_radius;
                    } else {
                        entry = (FlowerFeature.Entry)validEntries.getRandomElement(Permuter.stafford(otherGridSeed += -7046029254386353131L));
                        if (entry == null) continue;
                        radiusSource = entry.radius();
                    }
                    double radius = radiusSource.get(column, y, Permuter.stafford(otherGridSeed += -7046029254386353131L));
                    double otherGridCenterX = Permuter.nextPositiveDouble(otherGridSeed += -7046029254386353131L) * (double)variation + (double)offsetX;
                    double otherGridCenterZ = Permuter.nextPositiveDouble(otherGridSeed += -7046029254386353131L) * (double)variation + (double)offsetZ;
                    double distanceSquaredToCenter = BigGlobeMath.squareD((double)inGridX - otherGridCenterX, (double)inGridZ - otherGridCenterZ);
                    double groupNoise = noise - (distanceSquaredToCenter /= BigGlobeMath.squareD(radius)) * flowerNoise.maxValue();
                    if (!Permuter.nextChancedBoolean(overlapSeed += -7046029254386353131L, groupNoise) || overlapChance++ != 0 && Permuter.nextBoundedInt(overlapSeed += -7046029254386353131L, overlapChance) != 0) continue;
                    chosen = entry;
                }
            }
        }
        return chosen != null ? new QueuedPlacement(column.x(), y, column.z(), chosen) : null;
    }

    public void placeQueued(class_5821<Config> context, QueuedPlacement placement) {
        class_5281 world = context.method_33652();
        class_2338.class_2339 pos = WorldUtil.findNonReplaceableGroundMutable((class_1922)world, placement);
        if (pos == null) {
            return;
        }
        long seed = Permuter.permute(world.method_8412() ^ 0x9A99AA4557D5FE0FL, (class_2382)placement);
        int groundY = pos.method_10264();
        int flowerY = groundY + 1;
        if (placement.entry.under() != null) {
            class_2680 oldState = world.method_8320((class_2338)pos);
            if (SingleBlockFeature.place((class_1936)world, (class_2338)pos.method_33098(groundY), seed ^ 0xFF2635C589727C53L, placement.entry.under()) && !SingleBlockFeature.place((class_1936)world, (class_2338)pos.method_33098(flowerY), seed ^ 0x4E991C867DC4A20AL, placement.entry.state())) {
                world.method_8652((class_2338)pos.method_33098(groundY), oldState, 3);
            }
        } else {
            SingleBlockFeature.place((class_1936)world, (class_2338)pos.method_33098(flowerY), seed ^ 0x61425E46B2DFE013L, placement.entry.state());
        }
    }

    public static class Config
    implements class_3037 {
        public final ColumnScript.ColumnToIntScript.Holder y_level;
        public final DelayedEntryList<class_2975<?, ?>> flowers;
        public transient FlowerFeature.Config @Nullable [] flattenedFlowers;

        public Config(ColumnScript.ColumnToIntScript.Holder y_level, DelayedEntryList<class_2975<?, ?>> flowers) {
            this.y_level = y_level;
            this.flowers = flowers;
        }

        public FlowerFeature.Config @NotNull [] getFlattenedFlowers() {
            if (this.flattenedFlowers == null) {
                this.flattenedFlowers = (FlowerFeature.Config[])this.flowers.entryStream().filter(entry -> {
                    if (((class_2975)entry.comp_349()).comp_332() == BigGlobeFeatures.FLOWER) {
                        return true;
                    }
                    BigGlobeMod.LOGGER.warn("A flower controller references " + String.valueOf(UnregisteredObjectException.getID(entry)) + ", but this feature is not of type \"bigglobe:flower\". It will be ignored.");
                    return false;
                }).sorted(Comparator.comparing(UnregisteredObjectException::getID)).map(entry -> ((class_2975)entry.comp_349()).comp_333()).toArray(FlowerFeature.Config[]::new);
            }
            return this.flattenedFlowers;
        }
    }

    public static class QueuedPlacement
    extends class_2338.class_2339 {
        public final FlowerFeature.Entry entry;

        public QueuedPlacement(int i, int j, int k, FlowerFeature.Entry entry) {
            super(i, j, k);
            this.entry = entry;
        }
    }
}

