/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.hyperspace;

import builderb0y.autocodec.annotations.EncodeInline;
import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseFixer;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.data.AbstractNumberData;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.ListData;
import builderb0y.autocodec.data.MapData;
import builderb0y.autocodec.fixers.AutoFixer;
import builderb0y.autocodec.fixers.DataFixContext;
import builderb0y.autocodec.fixers.DataFixException;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.hyperspace.PackedPos;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;

@UseFixer(name="FIXER", in=PackedWorldPos.class, usage=MemberUsage.FIELD_CONTAINS_HANDLER)
public record PackedWorldPos(class_5321<class_1937> world, @EncodeInline PackedPos pos) {
    public static final AutoFixer<PackedWorldPos> FIXER = new AutoFixer.NamedFixer<PackedWorldPos>("PackedWorldPos.FIXER"){

        @ApiStatus.OverrideOnly
        @NotNull
        public <T_Encoded> DataFixContext<T_Encoded> fixData(@NotNull DataFixContext<T_Encoded> context) throws DataFixException {
            ListData pos;
            MapData map = context.data.tryAsMap();
            if (map != null && (pos = map.get("pos").tryAsList()) != null && pos.size() == 3) {
                map = map.without("pos");
                AbstractNumberData x = pos.get(0).tryAsNumber();
                AbstractNumberData y = pos.get(1).tryAsNumber();
                AbstractNumberData z = pos.get(2).tryAsNumber();
                if (x != null) {
                    map.put("x", (Data)x);
                }
                if (y != null) {
                    map.put("y", (Data)y);
                }
                if (z != null) {
                    map.put("z", (Data)z);
                }
                context = (DataFixContext)context.withData((Data)map);
            }
            return context;
        }
    };
    public static final PackedWorldPos ZERO = new PackedWorldPos((class_5321<class_1937>)class_1937.field_25179, PackedPos.ZERO);

    public PackedWorldPos(class_5321<class_1937> world, double x, double y, double z) {
        this(world, new PackedPos(x, y, z));
    }

    public PackedWorldPos(class_5321<class_1937> world, int x, int y, int z) {
        this(world, new PackedPos(x, y, z));
    }

    public PackedWorldPos(class_5321<class_1937> world, class_243 vector) {
        this(world, new PackedPos(vector));
    }

    public PackedWorldPos(class_5321<class_1937> world, Vector3dc vector) {
        this(world, new PackedPos(vector));
    }

    public double x() {
        return this.pos.x();
    }

    public double y() {
        return this.pos.y();
    }

    public double z() {
        return this.pos.z();
    }

    public int packedX() {
        return this.pos.packedX();
    }

    public int packedY() {
        return this.pos.packedY();
    }

    public int packedZ() {
        return this.pos.packedZ();
    }

    public void writePositionOnly(class_2540 buffer) {
        this.pos.write(buffer);
    }

    public static PackedWorldPos readPositionOnly(class_2540 buffer, class_5321<class_1937> world) {
        return new PackedWorldPos(world, PackedPos.read(buffer));
    }

    public void write(class_2540 buffer) {
        buffer.method_44116(this.world);
        this.writePositionOnly(buffer);
    }

    public static PackedWorldPos read(class_2540 buffer) {
        return new PackedWorldPos((class_5321<class_1937>)buffer.method_44112(class_7924.field_41223), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public void writeBulk(class_2540 buffer, Object2IntMap<class_5321<class_1937>> worlds) {
        buffer.method_10804(worlds.getInt(this.world));
        this.writePositionOnly(buffer);
    }

    public static PackedWorldPos readBulk(class_2540 buffer, List<class_5321<class_1937>> worlds) {
        return new PackedWorldPos(worlds.get(buffer.method_10816()), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static class CoderHolder {
        public static final AutoCoder<PackedWorldPos> CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(PackedWorldPos.class);
    }
}

