/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.math;

public class BigGlobeMath {
    public static final double TAU = Math.PI * 2;
    public static final double LN_2 = Math.log(2.0);
    public static final double LOG2_E = 1.0 / LN_2;
    public static final double GOLDEN_RATIO = 1.618033988749895;
    public static final double GOLDEN_ANGLE = 2.3999632297286535;

    public static int squareI(int i) {
        return i * i;
    }

    public static long squareL(long l) {
        return l * l;
    }

    public static long squareL(int i) {
        return BigGlobeMath.squareL((long)i);
    }

    public static float squareF(float f) {
        return f * f;
    }

    public static float squareF(int i) {
        return BigGlobeMath.squareF((float)i);
    }

    public static double squareD(double d) {
        return d * d;
    }

    public static double squareD(int i) {
        return BigGlobeMath.squareD((double)i);
    }

    public static double squareD(long l) {
        return BigGlobeMath.squareD((double)l);
    }

    public static double squareD(float f) {
        return BigGlobeMath.squareD((double)f);
    }

    public static int squareI(int i1, int i2) {
        return i1 * i1 + i2 * i2;
    }

    public static long squareL(long l1, long l2) {
        return l1 * l1 + l2 * l2;
    }

    public static long squareL(int i1, int i2) {
        return BigGlobeMath.squareL((long)i1, (long)i2);
    }

    public static float squareF(float f1, float f2) {
        return f1 * f1 + f2 * f2;
    }

    public static float squareF(int i1, int i2) {
        return BigGlobeMath.squareF((float)i1, (float)i2);
    }

    public static double squareD(double d1, double d2) {
        return d1 * d1 + d2 * d2;
    }

    public static double squareD(int i1, int i2) {
        return BigGlobeMath.squareD((double)i1, (double)i2);
    }

    public static double squareD(long l1, long l2) {
        return BigGlobeMath.squareD((double)l1, (double)l2);
    }

    public static double squareD(float f1, float f2) {
        return BigGlobeMath.squareD((double)f1, (double)f2);
    }

    public static int squareI(int i1, int i2, int i3) {
        return i1 * i1 + i2 * i2 + i3 * i3;
    }

    public static long squareL(long l1, long l2, long l3) {
        return l1 * l1 + l2 * l2 + l3 * l3;
    }

    public static long squareL(int i1, int i2, int i3) {
        return BigGlobeMath.squareL((long)i1, (long)i2, (long)i3);
    }

    public static float squareF(float f1, float f2, float f3) {
        return f1 * f1 + f2 * f2 + f3 * f3;
    }

    public static float squareF(int i1, int i2, int i3) {
        return BigGlobeMath.squareF((float)i1, (float)i2, (float)i3);
    }

    public static double squareD(double d1, double d2, double d3) {
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public static double squareD(int i1, int i2, int i3) {
        return BigGlobeMath.squareD((double)i1, (double)i2, (double)i3);
    }

    public static double squareD(long l1, long l2, long l3) {
        return BigGlobeMath.squareD((double)l1, (double)l2, (double)l3);
    }

    public static double squareD(float f1, float f2, float f3) {
        return BigGlobeMath.squareD((double)f1, (double)f2, (double)f3);
    }

    public static int floorI(float number) {
        int floor = (int)number;
        if ((float)floor > number) {
            --floor;
        }
        return floor;
    }

    public static int floorI(double number) {
        int floor = (int)number;
        if ((double)floor > number) {
            --floor;
        }
        return floor;
    }

    public static long floorL(float number) {
        long floor = (long)number;
        if ((float)floor > number) {
            --floor;
        }
        return floor;
    }

    public static long floorL(double number) {
        long floor = (long)number;
        if ((double)floor > number) {
            --floor;
        }
        return floor;
    }

    public static int ceilI(float number) {
        int ceil = (int)number;
        if ((float)ceil < number) {
            ++ceil;
        }
        return ceil;
    }

    public static int ceilI(double number) {
        int ceil = (int)number;
        if ((double)ceil < number) {
            ++ceil;
        }
        return ceil;
    }

    public static long ceilL(float number) {
        long ceil = (long)number;
        if ((float)ceil < number) {
            ++ceil;
        }
        return ceil;
    }

    public static long ceilL(double number) {
        long ceil = (long)number;
        if ((double)ceil < number) {
            ++ceil;
        }
        return ceil;
    }

    public static int roundI(float number) {
        return BigGlobeMath.floorI(number + 0.5f);
    }

    public static int roundI(double number) {
        return BigGlobeMath.floorI(number + 0.5);
    }

    public static long roundL(float number) {
        return BigGlobeMath.floorL(number + 0.5f);
    }

    public static long roundL(double number) {
        return BigGlobeMath.floorL(number + 0.5);
    }

    public static int modulus(int a, int b) {
        if (b > 0) {
            return BigGlobeMath.modulus_BP(a, b);
        }
        if (b < 0) {
            return BigGlobeMath.modulus_BN(a, b);
        }
        return 0;
    }

    public static int modulus_BP(int a, int b) {
        return (a %= b) < 0 ? a + b : a;
    }

    public static int modulus_BN(int a, int b) {
        return (a %= -b) > 0 ? a + b : a;
    }

    public static long modulus(long a, long b) {
        if (b > 0L) {
            return BigGlobeMath.modulus_BP(a, b);
        }
        if (b < 0L) {
            return BigGlobeMath.modulus_BN(a, b);
        }
        return 0L;
    }

    public static long modulus_BP(long a, long b) {
        return (a %= b) < 0L ? a + b : a;
    }

    public static long modulus_BN(long a, long b) {
        return (a %= -b) > 0L ? a + b : a;
    }

    public static float modulus(float a, float b) {
        if (b > 0.0f) {
            return BigGlobeMath.modulus_BP(a, b);
        }
        if (b < 0.0f) {
            return BigGlobeMath.modulus_BN(a, b);
        }
        return b;
    }

    public static float modulus_BP(float a, float b) {
        return a + ((a %= b) < 0.0f ? b : 0.0f);
    }

    public static float modulus_BN(float a, float b) {
        float mod = a % -b;
        if (mod > 0.0f) {
            mod += b;
        }
        mod = Float.intBitsToFloat(Float.floatToRawIntBits(mod) | Integer.MIN_VALUE);
        return mod;
    }

    public static double modulus(double a, double b) {
        if (b > 0.0) {
            return BigGlobeMath.modulus_BP(a, b);
        }
        if (b < 0.0) {
            return BigGlobeMath.modulus_BN(a, b);
        }
        return b;
    }

    public static double modulus_BP(double a, double b) {
        return a + ((a %= b) < 0.0 ? b : 0.0);
    }

    public static double modulus_BN(double a, double b) {
        double mod = a % -b;
        if (mod > 0.0) {
            mod += b;
        }
        mod = Double.longBitsToDouble(Double.doubleToRawLongBits(mod) | Long.MIN_VALUE);
        return mod;
    }

    public static float exp2(float value) {
        return (float)Math.exp((double)value * LN_2);
    }

    public static double exp2(double value) {
        return Math.exp(value * LN_2);
    }

    public static float exp(float value) {
        return (float)Math.exp(value);
    }

    public static double exp(double value) {
        return Math.exp(value);
    }

    public static float log2(float value) {
        return (float)(Math.log(value) / LN_2);
    }

    public static double log2(double value) {
        return Math.log(value) / LN_2;
    }

    public static float ln(float value) {
        return (float)Math.log(value);
    }

    public static double ln(double value) {
        return Math.log(value);
    }

    public static double asinh(double x) {
        return Math.copySign(Math.log(Math.sqrt(x * x + 1.0) + Math.abs(x)), x);
    }

    public static double acosh(double x) {
        return Math.log(Math.sqrt(x * x - 1.0) + x);
    }

    public static double atanh(double x) {
        return Math.log((1.0 + x) / (1.0 - x)) * 0.5;
    }

    public static float sigmoid01(float value) {
        return 1.0f / (BigGlobeMath.exp(-4.0f * value) + 1.0f);
    }

    public static double sigmoid01(double value) {
        return 1.0 / (BigGlobeMath.exp(-4.0 * value) + 1.0);
    }

    public static float sigmoidM11(float value) {
        return (float)Math.tanh(value);
    }

    public static double sigmoidM11(double value) {
        return Math.tanh(value);
    }

    public static float fogify(float width, float value) {
        return width / (BigGlobeMath.squareF(value) + width);
    }

    public static float fogify(float width, float x, float y) {
        return width / (BigGlobeMath.squareF(x, y) + width);
    }

    public static float fogify(float width, float x, float y, float z) {
        return width / (BigGlobeMath.squareF(x, y, z) + width);
    }

    public static float upsideDownFogify(float width, float value) {
        value *= value;
        return value / (value + width);
    }

    public static float upsideDownFogify(float width, float x, float y) {
        float value = BigGlobeMath.squareF(x, y);
        return value / (value + width);
    }

    public static float upsideDownFogify(float width, float x, float y, float z) {
        float value = BigGlobeMath.squareF(x, y, z);
        return value / (value + width);
    }

    public static float bellCurve(float width, float value) {
        return BigGlobeMath.exp(-BigGlobeMath.squareF(value) / width);
    }

    public static float bellCurve(float width, float x, float y) {
        return BigGlobeMath.exp(-BigGlobeMath.squareF(x, y) / width);
    }

    public static float bellCurve(float width, float x, float y, float z) {
        return BigGlobeMath.exp(-BigGlobeMath.squareF(x, y, z) / width);
    }

    public static byte toByteExact(int value) {
        byte b = (byte)value;
        if (value == b) {
            return b;
        }
        throw new ArithmeticException("Value too big for a byte: " + value);
    }

    public static short toShortExact(int value) {
        short s = (short)value;
        if (value == s) {
            return s;
        }
        throw new ArithmeticException("Value too big for a short: " + value);
    }

    public static byte toUnsignedByteExact(int value) {
        if (value == (value & 0xFF)) {
            return (byte)value;
        }
        throw new ArithmeticException("Value too big for an unsigned byte: " + value);
    }

    public static short toUnsignedShortExact(int value) {
        if (value == (value & 0xFFFF)) {
            return (short)value;
        }
        throw new ArithmeticException("Value too big for an unsigned short: " + value);
    }

    public static int toUnsignedIntExact(long value) {
        if (value == (value & 0xFFFFFFFFL)) {
            return (int)value;
        }
        throw new ArithmeticException("Value too big for an unsigned int: " + value);
    }

    public static char toCharExact(int value) {
        if (value == (char)value) {
            return (char)value;
        }
        throw new ArithmeticException("Value too big for a char: " + value);
    }

    public static int positiveProduct(int a, int b) {
        return a > 0 && b > 0 ? a * b : 0;
    }

    public static long positiveProduct(long a, long b) {
        return a > 0L && b > 0L ? a * b : 0L;
    }

    public static float positiveProduct(float a, float b) {
        return a > 0.0f && b > 0.0f ? a * b : 0.0f;
    }

    public static double positiveProduct(double a, double b) {
        return a > 0.0 && b > 0.0 ? a * b : 0.0;
    }
}

