/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.math;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.scripting.environments.MathScriptEnvironment;

public class Interpolator {
    public static float mixLinear(float low, float high, float value) {
        return (high - low) * value + low;
    }

    public static double mixLinear(double low, double high, double value) {
        return (high - low) * value + low;
    }

    public static float mixClamp(float low, float high, float value) {
        if (!(value > 0.0f)) {
            return low;
        }
        if (!(value < 1.0f)) {
            return high;
        }
        return Interpolator.mixLinear(low, high, value);
    }

    public static double mixClamp(double low, double high, double value) {
        if (!(value > 0.0)) {
            return low;
        }
        if (!(value < 1.0)) {
            return high;
        }
        return Interpolator.mixLinear(low, high, value);
    }

    public static float mixSmooth(float low, float high, float value) {
        if (!(value > 0.0f)) {
            return low;
        }
        if (!(value < 1.0f)) {
            return high;
        }
        return Interpolator.mixLinear(low, high, Interpolator.smooth(value));
    }

    public static double mixSmooth(double low, double high, double value) {
        if (!(value > 0.0)) {
            return low;
        }
        if (!(value < 1.0)) {
            return high;
        }
        return Interpolator.mixLinear(low, high, Interpolator.smooth(value));
    }

    public static float mixSmoother(float low, float high, float value) {
        if (!(value > 0.0f)) {
            return low;
        }
        if (!(value < 1.0f)) {
            return high;
        }
        return Interpolator.mixLinear(low, high, Interpolator.smoother(value));
    }

    public static double mixSmoother(double low, double high, double value) {
        if (!(value > 0.0)) {
            return low;
        }
        if (!(value < 1.0)) {
            return high;
        }
        return Interpolator.mixLinear(low, high, Interpolator.smoother(value));
    }

    public static float mixSmoothUnchecked(float low, float high, float value) {
        return Interpolator.mixLinear(low, high, Interpolator.smooth(value));
    }

    public static double mixSmoothUnchecked(double low, double high, double value) {
        return Interpolator.mixLinear(low, high, Interpolator.smooth(value));
    }

    public static float mixSmootherUnchecked(float low, float high, float value) {
        return Interpolator.mixLinear(low, high, Interpolator.smoother(value));
    }

    public static double mixSmootherUnchecked(double low, double high, double value) {
        return Interpolator.mixLinear(low, high, Interpolator.smoother(value));
    }

    public static float unmixLinear(float low, float high, float value) {
        return (value - low) / (high - low);
    }

    public static double unmixLinear(double low, double high, double value) {
        return (value - low) / (high - low);
    }

    public static float unmixClamp(float low, float high, float value) {
        return Interpolator.clamp(0.0f, 1.0f, Interpolator.unmixLinear(low, high, value));
    }

    public static double unmixClamp(double low, double high, double value) {
        return Interpolator.clamp(0.0, 1.0, Interpolator.unmixLinear(low, high, value));
    }

    public static float unmixSmooth(float low, float high, float value) {
        return Interpolator.smoothClamp(Interpolator.unmixLinear(low, high, value));
    }

    public static double unmixSmooth(double low, double high, double value) {
        return Interpolator.smoothClamp(Interpolator.unmixLinear(low, high, value));
    }

    public static float unmixSmoother(float low, float high, float value) {
        return Interpolator.smoothClamp(Interpolator.unmixLinear(low, high, value));
    }

    public static double unmixSmoother(double low, double high, double value) {
        return Interpolator.smoothClamp(Interpolator.unmixLinear(low, high, value));
    }

    public static int clamp(int low, int high, int value) {
        return Math.max(Math.min(value, high), low);
    }

    public static long clamp(long low, long high, long value) {
        return Math.max(Math.min(value, high), low);
    }

    public static float clamp(float low, float high, float value) {
        return MathScriptEnvironment.min(MathScriptEnvironment.max(value, low), high);
    }

    public static double clamp(double low, double high, double value) {
        return MathScriptEnvironment.min(MathScriptEnvironment.max(value, low), high);
    }

    public static double mixCubic(double a, double b, double c, double d, double f) {
        return b + 0.5 * f * (c - a + f * (2.0 * a - 5.0 * b + 4.0 * c - d + f * (3.0 * (b - c) + d - a)));
    }

    public static double combineCubicTerms(double term1, double term2, double term3, double term4, double f) {
        return ((term4 * f + term3) * f + term2) * f + term1;
    }

    public static double cubicTerm1(double a, double b, double c, double d) {
        return b;
    }

    public static double cubicTerm2(double a, double b, double c, double d) {
        return (c - a) * 0.5;
    }

    public static double cubicTerm3(double a, double b, double c, double d) {
        return a - 2.5 * b + 2.0 * c - 0.5 * d;
    }

    public static double cubicTerm4(double a, double b, double c, double d) {
        return 1.5 * (b - c) + 0.5 * (d - a);
    }

    public static double cubicDerivative(double a, double b, double c, double d, double f) {
        return ((1.5 * (d - a) + 4.5 * (b - c)) * f + (2.0 * a - 5.0 * b + 4.0 * c - d)) * f + 0.5 * (c - a);
    }

    public static double combineCubicDerivativeTerms(double term1, double term2, double term3, double f) {
        return (term1 * f + term2) * f + term3;
    }

    public static double cubicDerivativeTerm1(double a, double b, double c, double d) {
        return 1.5 * (d - a) + 4.5 * (b - c);
    }

    public static double cubicDerivativeTerm2(double a, double b, double c, double d) {
        return 2.0 * a - 5.0 * b + 4.0 * c - d;
    }

    public static double cubicDerivativeTerm3(double a, double b, double c, double d) {
        return 0.5 * (c - a);
    }

    public static double smooth(double value) {
        return (-2.0 * value + 3.0) * value * value;
    }

    public static float smooth(float value) {
        return (-2.0f * value + 3.0f) * value * value;
    }

    public static double smoothClamp(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= 1.0) {
            return 1.0;
        }
        return Interpolator.smooth(value);
    }

    public static float smoothClamp(float value) {
        if (value <= 0.0f) {
            return 0.0f;
        }
        if (value >= 1.0f) {
            return 1.0f;
        }
        return Interpolator.smooth(value);
    }

    public static double smootherClamp(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= 1.0) {
            return 1.0;
        }
        return Interpolator.smoother(value);
    }

    public static float smootherClamp(float value) {
        if (value <= 0.0f) {
            return 0.0f;
        }
        if (value >= 1.0f) {
            return 1.0f;
        }
        return Interpolator.smoother(value);
    }

    public static double smoothDerivative(double value) {
        return (value - value * value) * 6.0;
    }

    public static double smoother(double value) {
        return ((6.0 * value - 15.0) * value + 10.0) * value * value * value;
    }

    public static float smoother(float value) {
        return ((6.0f * value - 15.0f) * value + 10.0f) * value * value * value;
    }

    public static double smootherDerivative(double value) {
        return BigGlobeMath.squareD(value - value * value) * 30.0;
    }

    public static double dMixPerlinExplicit(double v0, double v1, double smoothF, double dv0, double dv1, double dSmoothF) {
        return (v1 - v0) * dSmoothF + (dv1 - dv0) * smoothF + dv0;
    }

    public static double dMixPerlin(double v0, double v1, double dv0, double dv1, double f) {
        return (v1 - v0) * Interpolator.smoothDerivative(f) + (dv1 - dv0) * Interpolator.smooth(f) + dv0;
    }
}

