/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.mixins;

import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.pointSequences.GoldenSpiralIterator;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2643;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2643.class})
public class EndGatewayBlockEntity_UseAlternateLogicInBigGlobeWorlds {
    @Unique
    private static Vector2d bigglobe_exitPosition;

    @Inject(method={"findTeleportLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bigglobe_useColumnMaxYForOutwardSearch(class_3218 world, class_2338 gatewayPos, CallbackInfoReturnable<class_243> callback) {
        bigglobe_exitPosition = null;
        class_2794 class_27942 = world.method_14178().method_12129();
        if (class_27942 instanceof BigGlobeScriptedChunkGenerator) {
            BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
            if (generator.end_overrides != null) {
                ScriptedColumn column = generator.newColumn((class_5539)world, 0, 0, ScriptedColumn.ColumnUsage.GENERIC.normalHints());
                Vector2d direction = new Vector2d((double)gatewayPos.method_10263(), (double)gatewayPos.method_10260()).normalize();
                Vector2d position = new Vector2d();
                double minRadius = generator.end_overrides.outer_gateways().min_radius();
                double maxRadius = generator.end_overrides.outer_gateways().max_radius();
                double step = generator.end_overrides.outer_gateways().step();
                ColumnScript.ColumnToBooleanScript.Holder condition = generator.end_overrides.outer_gateways().condition();
                for (double radius = minRadius; radius <= maxRadius; radius += step) {
                    position.set((Vector2dc)direction).mul(radius);
                    column.setParamsUnchecked(column.params.at(BigGlobeMath.floorI(position.x), BigGlobeMath.floorI(position.y)));
                    if (!condition.get(column)) continue;
                    bigglobe_exitPosition = position;
                    callback.setReturnValue((Object)new class_243(position.x, (double)generator.method_20402(BigGlobeMath.floorI(position.x), BigGlobeMath.floorI(position.y), class_2902.class_2903.field_13194, (class_5539)world, world.method_14178().method_41248()), position.y));
                    return;
                }
            }
        }
    }

    @Inject(method={"findPortalPosition"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bigglobe_useColumnMaxYForPositionInsideChunk(class_2818 chunk, CallbackInfoReturnable<class_2338> callback) {
        class_1937 world = chunk.method_12200();
        Vector2d basePosition = bigglobe_exitPosition;
        if (basePosition != null) {
            class_3215 manager;
            bigglobe_exitPosition = null;
            class_2802 class_28022 = world.method_8398();
            if (class_28022 instanceof class_3215 && (class_28022 = (manager = (class_3215)class_28022).method_12129()) instanceof BigGlobeScriptedChunkGenerator) {
                BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_28022;
                if (generator.end_overrides != null) {
                    class_2338.class_2339 mutablePos = new class_2338.class_2339();
                    GoldenSpiralIterator iterator = new GoldenSpiralIterator(basePosition.x, basePosition.y, 2.0, world.field_9229.method_43055());
                    while (iterator.radius <= 64.0) {
                        int topY = generator.method_16397(iterator.floorX(), iterator.floorY(), class_2902.class_2903.field_13194, (class_5539)world, manager.method_41248());
                        if (topY > HeightLimitViewVersions.getMinY((class_5539)world)) {
                            mutablePos.method_10103(iterator.floorX(), topY, iterator.floorY());
                            class_2791 newChunk = world.method_22350((class_2338)mutablePos);
                            if (BlockStateVersions.isOpaqueFullCube(newChunk.method_8320((class_2338)mutablePos.method_33098(topY - 1)), (class_1922)world, (class_2338)mutablePos) && newChunk.method_8320((class_2338)mutablePos.method_33098(topY)).method_26215() && newChunk.method_8320((class_2338)mutablePos.method_33098(topY + 1)).method_26215()) {
                                callback.setReturnValue((Object)mutablePos.method_33098(topY - 1).method_10062());
                                return;
                            }
                        }
                        iterator.next();
                    }
                    callback.setReturnValue(null);
                    return;
                }
            }
        }
    }

    @Inject(method={"findExitPortalPos"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bigglobe_useAlternateLogicForHighestYLevelSearch(class_1922 world, class_2338 pos, int searchRadius, boolean force, CallbackInfoReturnable<class_2338> callback) {
        class_3218 serverWorld;
        class_2794 class_27942;
        if (world instanceof class_3218 && (class_27942 = (serverWorld = (class_3218)world).method_14178().method_12129()) instanceof BigGlobeScriptedChunkGenerator) {
            BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
            if (generator.end_overrides != null) {
                class_2338.class_2339 search = new class_2338.class_2339();
                class_2338.class_2339 found = pos.method_25503().method_33098(HeightLimitViewVersions.getMinY((class_5539)world));
                for (int offsetX = -searchRadius; offsetX <= searchRadius; ++offsetX) {
                    block1: for (int offsetZ = -searchRadius; offsetZ <= searchRadius; ++offsetZ) {
                        search.method_10103(pos.method_10263() + offsetX, pos.method_10264(), pos.method_10260() + offsetZ);
                        while (EndGatewayBlockEntity_UseAlternateLogicInBigGlobeWorlds.bigglobe_canSpawnOn(world, (class_2338)search)) {
                            search.method_33098(search.method_10264() + 1);
                        }
                        while (!EndGatewayBlockEntity_UseAlternateLogicInBigGlobeWorlds.bigglobe_canSpawnOn(world, (class_2338)search)) {
                            search.method_33098(search.method_10264() - 1);
                            if (search.method_10264() >= found.method_10264()) continue;
                            continue block1;
                        }
                        found.method_10101((class_2382)search);
                    }
                }
                if (found.method_10264() == HeightLimitViewVersions.getMinY((class_5539)world)) {
                    found.method_10101((class_2382)pos);
                }
                callback.setReturnValue((Object)found.method_10062());
            }
        }
    }

    private static boolean bigglobe_canSpawnOn(class_1922 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26234(world, pos) && !state.method_27852(class_2246.field_9987);
    }
}

