/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.networking.packets;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.hyperspace.HyperspaceConstants;
import builderb0y.bigglobe.hyperspace.PackedWorldPos;
import builderb0y.bigglobe.hyperspace.PlayerWaypointData;
import builderb0y.bigglobe.hyperspace.PlayerWaypointManager;
import builderb0y.bigglobe.networking.base.BigGlobeNetwork;
import builderb0y.bigglobe.networking.base.C2SPlayPacketHandler;
import builderb0y.bigglobe.versions.EntityVersions;
import builderb0y.bigglobe.versions.GameProfileVersions;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class UseWaypointPacket
implements C2SPlayPacketHandler<Integer> {
    public static final UseWaypointPacket INSTANCE = new UseWaypointPacket();

    public void send(int id) {
        class_2540 buffer = this.buffer();
        buffer.method_10804(id);
        BigGlobeNetwork.INSTANCE.sendToServer(buffer);
    }

    @Override
    public Integer decode(class_3222 player, class_2540 buffer) {
        return buffer.method_10816();
    }

    @Override
    public void process(class_3222 player, Integer data, PacketSender responseSender) {
        if (player.method_30230()) {
            EntityVersions.setPortalCooldown((class_1297)player, 20);
            return;
        }
        if (!BigGlobeConfig.INSTANCE.get().hyperspaceEnabled && EntityVersions.getWorld((class_1297)player).method_27983() != HyperspaceConstants.WORLD_KEY) {
            player.method_7353((class_2561)class_2561.method_43471((String)"bigglobe.hyperspace.disabled").method_27692(class_124.field_1061), true);
            return;
        }
        PlayerWaypointManager manager = PlayerWaypointManager.get((class_1657)player);
        if (manager == null) {
            BigGlobeMod.LOGGER.warn(String.valueOf(player) + " has no waypoint manager?");
            return;
        }
        PlayerWaypointData waypoint = (PlayerWaypointData)manager.getWaypoint(data);
        if (waypoint == null) {
            BigGlobeMod.LOGGER.warn(String.valueOf(player) + " attempted to use a waypoint that doesn't exist: " + data);
            return;
        }
        if (waypoint.owner() != null && !waypoint.owner().equals(GameProfileVersions.getUUID(player.method_7334()))) {
            BigGlobeMod.LOGGER.warn(String.valueOf(player) + " attempted to use a waypoint that doesn't belong to them: " + String.valueOf(waypoint));
            return;
        }
        if (EntityVersions.getWorld((class_1297)player).method_27983() != waypoint.displayPosition().world() || !(player.method_33571().method_1028(waypoint.displayPosition().x(), waypoint.displayPosition().y(), waypoint.displayPosition().z()) <= 1.0)) {
            BigGlobeMod.LOGGER.warn(String.valueOf(player) + " attempted to use " + String.valueOf(waypoint) + " without being near it.");
            return;
        }
        if (EntityVersions.getWorld((class_1297)player).method_27983() == HyperspaceConstants.WORLD_KEY) {
            class_3218 destinationWorld = EntityVersions.getServer(player).method_3847(waypoint.destinationPosition().world());
            if (destinationWorld != null) {
                manager.entrance = null;
                PackedWorldPos destinationPosition = waypoint.destination().pos();
                class_3222 newPlayer = EntityVersions.teleport(player, destinationWorld, new class_243(destinationPosition.x(), destinationPosition.y() - 1.0, destinationPosition.z()), player.method_18798(), player.method_36454(), player.method_36455());
                if (newPlayer != null) {
                    EntityVersions.setPortalCooldown((class_1297)newPlayer, 20);
                }
            } else {
                BigGlobeMod.LOGGER.warn(String.valueOf(player) + " attempted to use " + String.valueOf(waypoint) + " but its destination leads to a non-existent world. Curious.");
            }
        } else {
            class_3218 hyperspace = EntityVersions.getServer(player).method_3847(HyperspaceConstants.WORLD_KEY);
            if (hyperspace != null) {
                manager.entrance = waypoint.destination().pos();
                class_3222 newPlayer = EntityVersions.teleport(player, hyperspace, class_243.field_1353, player.method_18798(), player.method_36454(), player.method_36455());
                if (newPlayer != null) {
                    EntityVersions.setPortalCooldown((class_1297)newPlayer, 20);
                }
            }
        }
    }
}

