/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.networking.packets;

import builderb0y.bigglobe.hyperspace.HyperspaceConstants;
import builderb0y.bigglobe.hyperspace.PackedWorldPos;
import builderb0y.bigglobe.hyperspace.PlayerWaypointManager;
import builderb0y.bigglobe.hyperspace.ServerPlayerWaypointManager;
import builderb0y.bigglobe.hyperspace.SyncedWaypointData;
import builderb0y.bigglobe.networking.base.BigGlobeNetwork;
import builderb0y.bigglobe.networking.base.S2CPlayPacketHandler;
import builderb0y.bigglobe.util.NbtIo2;
import builderb0y.bigglobe.util.TextCoding;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class WaypointAddS2CPacket
implements S2CPlayPacketHandler<SyncedWaypointData> {
    public static final WaypointAddS2CPacket INSTANCE = new WaypointAddS2CPacket();
    public static final int HAS_OWNER = 1;
    public static final int HAS_DISPLAYED_POSITION = 2;
    public static final int HAS_NAME = 4;

    public void send(ServerPlayerWaypointManager manager, SyncedWaypointData waypoint) {
        class_2520 name;
        int flags = 0;
        if (waypoint.owned()) {
            flags |= 1;
        }
        if (manager.entrance != null) {
            flags |= 2;
        }
        if ((name = TextCoding.toNbt(waypoint.name())) != null) {
            flags |= 4;
        }
        class_2540 buffer = this.buffer();
        buffer.method_52997(flags);
        buffer.method_10804(waypoint.id());
        buffer.method_10804(waypoint.entityId());
        waypoint.destinationPosition().write(buffer);
        if (manager.entrance != null) {
            waypoint.displayedPosition().writePositionOnly(buffer);
        }
        if (name != null) {
            NbtIo2.write((ByteBuf)buffer, name);
        }
        BigGlobeNetwork.INSTANCE.sendToPlayer(manager.serverPlayer(), buffer);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public SyncedWaypointData decode(class_2540 buffer) {
        byte flags = buffer.readByte();
        boolean owned = (flags & 1) != 0;
        boolean hasDisplayedPosition = (flags & 2) != 0;
        boolean hasName = (flags & 4) != 0;
        int id = buffer.method_10816();
        int entityID = buffer.method_10816();
        PackedWorldPos destination = PackedWorldPos.read(buffer);
        PackedWorldPos displayedPosition = hasDisplayedPosition ? PackedWorldPos.readPositionOnly(buffer, HyperspaceConstants.WORLD_KEY) : destination;
        class_2561 name = hasName ? TextCoding.read(buffer) : null;
        return new SyncedWaypointData(id, entityID, owned, destination, displayedPosition, name);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void process(SyncedWaypointData waypoint, PacketSender responseSender) {
        PlayerWaypointManager manager;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && (manager = PlayerWaypointManager.get((class_1657)player)) != null) {
            manager.addWaypoint(waypoint.resolve((class_1657)player), true);
        }
    }
}

