/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise;

import builderb0y.autocodec.annotations.DefaultEmpty;
import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.MultiLine;
import builderb0y.autocodec.annotations.UseVerifier;
import builderb0y.autocodec.annotations.VerifySorted;
import builderb0y.autocodec.logging.TaskLogger;
import builderb0y.autocodec.verifiers.VerifyContext;
import builderb0y.autocodec.verifiers.VerifyException;
import builderb0y.bigglobe.columns.scripted.ColumnEntryRegistry;
import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.scripting.ScriptErrorCatcher;
import builderb0y.scripting.bytecode.ClassCompileContext;
import builderb0y.scripting.bytecode.ClassType;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.fields.PutFieldInsnTree;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.Script;
import builderb0y.scripting.parsing.ScriptClassLoader;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;

public abstract class ScriptedGrid<G extends Grid>
extends ScriptErrorCatcher.Impl
implements Grid,
ColumnEntryRegistry.DelayedCompileable {
    public static final TypeInfo NUMBER_ARRAY_TYPE = InsnTrees.type(NumberArray.class);
    public final @MultiLine String script;
    public final @DefaultEmpty Map<@UseVerifier(name="verifyInputName", in=ScriptedGrid.class, usage=MemberUsage.METHOD_IS_HANDLER) String, G> inputs;
    public final double min;
    public final @VerifySorted(greaterThanOrEqual={"min"}) double max;

    public ScriptedGrid(@MultiLine String script, Map<String, G> inputs, double min, double max) {
        this.script = script;
        this.inputs = inputs;
        this.min = min;
        this.max = max;
    }

    @Override
    @Nullable
    public String getDebugName() {
        return null;
    }

    @Override
    @Nullable
    public String getSource() {
        return this.script;
    }

    public abstract Grid getDelegate();

    @Override
    public double minValue() {
        return this.min;
    }

    @Override
    public double maxValue() {
        return this.max;
    }

    public static <T_Encoded> void verifyInputName(VerifyContext<T_Encoded, String> context) throws VerifyException {
        String inputName = (String)context.object;
        if (inputName != null) {
            if (inputName.isEmpty()) {
                throw new VerifyException(() -> context.pathToStringBuilder().append(" cannot be an empty string.").toString());
            }
            if (inputName.equals("_")) {
                throw new VerifyException(() -> context.pathToStringBuilder().append(" cannot be _ as it is a reserved name.").toString());
            }
            char c = inputName.charAt(0);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
                throw new VerifyException(() -> context.pathToStringBuilder().append(" must start with an alphabetic character or an underscore.").toString());
            }
            int length = inputName.length();
            for (int index = 1; index < length; ++index) {
                c = inputName.charAt(index);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
                throw new VerifyException(() -> context.pathToStringBuilder().append(" must contain only alphabetic characters, numeric characters, and underscores.").toString());
            }
        }
    }

    public static LinkedHashMap<String, Input> processInputs(Map<String, ? extends Grid> inputs, GridTypeInfo info) {
        LinkedHashMap<String, Input> processedInputs = new LinkedHashMap<String, Input>(inputs.size());
        int index = 0;
        for (Map.Entry<String, ? extends Grid> entry : inputs.entrySet()) {
            processedInputs.put(entry.getKey(), new Input(entry.getKey(), index++, entry.getValue(), info));
        }
        return processedInputs;
    }

    public static class Input {
        public final String name;
        public final int index;
        public final Grid grid;
        public final GridTypeInfo info;

        public Input(String name, int index, Grid grid, GridTypeInfo info) {
            this.name = name;
            this.index = index;
            this.grid = grid;
            this.info = info;
        }

        public <G extends Grid> G grid() {
            return (G)this.grid;
        }

        public FieldInfo fieldInfo(MethodCompileContext method) {
            return new FieldInfo(17, method.clazz.info, this.name, this.info.type);
        }

        public FieldNode fieldNode() {
            return new FieldNode(17, this.name, this.info.desc, null, null);
        }

        public LazyVarInfo gridParameter() {
            return new LazyVarInfo(this.name, this.info.type);
        }

        public LazyVarInfo doubleParameter() {
            return new LazyVarInfo(this.name, TypeInfos.DOUBLE);
        }
    }

    public static class GridTypeInfo {
        public final Class<? extends Grid> gridClass;
        public final Class<? extends Parser> parserClass;
        public final String name;
        public final String desc;
        public final TypeInfo type;
        public final int dimensions;

        public GridTypeInfo(Class<? extends Grid> gridClass, Class<? extends Parser> parserClass, int dimensions) {
            this.gridClass = gridClass;
            this.parserClass = parserClass;
            this.name = Type.getInternalName(gridClass);
            this.desc = Type.getDescriptor(gridClass);
            this.type = TypeInfo.of(gridClass);
            this.dimensions = dimensions;
        }
    }

    public static class Environment
    implements ScriptEnvironment {
        public final LinkedHashMap<String, Input> inputs;
        public final GridTypeInfo gridTypeInfo;

        public Environment(LinkedHashMap<String, Input> inputs, GridTypeInfo gridTypeInfo) {
            this.inputs = inputs;
            this.gridTypeInfo = gridTypeInfo;
        }

        @Override
        @Nullable
        public InsnTree getVariable(ExpressionParser parser, String name) throws ScriptParsingException {
            char c;
            if (name.length() == 1 && (c = name.charAt(0)) >= 'x' && c < 120 + this.gridTypeInfo.dimensions) {
                return InsnTrees.load(name, TypeInfos.INT);
            }
            return this.inputs.containsKey(name) ? InsnTrees.load(name, TypeInfos.DOUBLE) : null;
        }

        @Override
        public Stream<ScriptEnvironment.IdentifierDescriptor> listIdentifiers() {
            return Stream.concat(IntStream.range(120, 120 + this.gridTypeInfo.dimensions).mapToObj(c -> new ScriptEnvironment.IdentifierDescriptor(String.valueOf((char)c), TaskLogger.lazyMessage(() -> "int " + (char)c + ": the " + (char)c + " coordinate of the current position"))), this.inputs.values().stream().map(input -> new ScriptEnvironment.IdentifierDescriptor(input.name, TaskLogger.lazyMessage(() -> "double " + input.name + ": user-defined input @ " + input.index))));
        }
    }

    public static abstract class Parser<G extends Grid>
    extends ExpressionParser {
        public static final MethodInfo CHECK_NAN = MethodInfo.getMethod(Parser.class, "checkNaN");
        public static final MethodInfo OBJECT_CONSTRUCTOR = MethodInfo.getConstructor(Object.class);
        public static final MethodInfo GETD = MethodInfo.getMethod(NumberArray.class, "getD");
        public static final MethodInfo SETD = MethodInfo.getMethod(NumberArray.class, "setD");
        public static final MethodInfo ALLOCATED = MethodInfo.getMethod(NumberArray.class, "allocateDoublesDirect");
        public static final MethodInfo LENGTH = MethodInfo.getMethod(NumberArray.class, "length");
        public LinkedHashMap<String, Input> gridInputs;
        public GridTypeInfo gridTypeInfo;

        public Parser(@MultiLine String script, LinkedHashMap<String, Input> gridInputs, GridTypeInfo gridTypeInfo, ClassCompileContext clazz, int flags) {
            super(script, clazz, clazz.newMethod(9, "evaluate", TypeInfos.DOUBLE, Parser.params(gridTypeInfo, gridInputs)), flags);
            this.gridInputs = gridInputs;
            this.gridTypeInfo = gridTypeInfo;
            for (Input input : this.gridInputs.values()) {
                this.environment.mutable().addVariableConstant(input.name + "Min", input.grid.minValue());
                this.environment.mutable().addVariableConstant(input.name + "Max", input.grid.maxValue());
            }
        }

        public static LazyVarInfo[] params(GridTypeInfo gridTypeInfo, LinkedHashMap<String, Input> gridInputs) {
            ArrayList<LazyVarInfo> list = new ArrayList<LazyVarInfo>(gridTypeInfo.dimensions + gridInputs.size() + 1);
            for (int dimension = 0; dimension < gridTypeInfo.dimensions; ++dimension) {
                list.add(new LazyVarInfo(Parser.coordName(dimension), TypeInfos.INT));
            }
            for (String name : gridInputs.keySet()) {
                list.add(new LazyVarInfo(name, TypeInfos.DOUBLE));
            }
            return list.toArray(new LazyVarInfo[list.size()]);
        }

        public Parser(@MultiLine String script, LinkedHashMap<String, Input> gridInputs, GridTypeInfo gridTypeInfo, int flags) {
            this(script, gridInputs, gridTypeInfo, new ClassCompileContext(4113, ClassType.CLASS, Type.getInternalName(gridTypeInfo.parserClass) + "$Generated_" + ScriptClassLoader.CLASS_UNIQUIFIER.getAndIncrement(), TypeInfos.OBJECT, new TypeInfo[]{TypeInfo.of(gridTypeInfo.gridClass), TypeInfo.of(Script.class)}), flags);
        }

        public static InsnTree newNumberArray(InsnTree length) {
            return InsnTrees.invokeStatic(ALLOCATED, length);
        }

        public static InsnTree numberArrayLoad(InsnTree array, InsnTree index) {
            return InsnTrees.invokeInstance(array, GETD, index);
        }

        public static InsnTree numberArrayStore(InsnTree array, InsnTree index, InsnTree value) {
            return InsnTrees.invokeInstance(array, SETD, index, value);
        }

        public static InsnTree numberArrayLength(InsnTree array) {
            return InsnTrees.invokeInstance(array, LENGTH, new InsnTree[0]);
        }

        public G parse() throws ScriptParsingException {
            this.addConstructor();
            this.addGetValue();
            int dimensions = this.gridTypeInfo.dimensions;
            if (this.gridInputs.size() == 1) {
                for (int dimension = 0; dimension < dimensions; ++dimension) {
                    this.addGetBulkOne(dimension);
                }
            } else {
                for (int dimension = 0; dimension < dimensions; ++dimension) {
                    this.addGetBulkMany(dimension);
                }
            }
            this.addEvaluate();
            this.addSource();
            this.addToString();
            return this.instantiate();
        }

        public abstract void addGetBulkOne(int var1);

        public abstract void addGetBulkMany(int var1);

        public G instantiate() throws ScriptParsingException {
            try {
                Class<?> clazz = this.compile(new ScriptClassLoader());
                Object[] parameterTypes = new Class[this.gridInputs.size()];
                Arrays.fill(parameterTypes, this.gridTypeInfo.gridClass);
                Constructor<?> constructor = clazz.getDeclaredConstructor((Class<?>[])parameterTypes);
                Object[] arguments = new Object[this.gridInputs.size()];
                for (Input input : this.gridInputs.values()) {
                    arguments[input.index] = input.grid;
                }
                return (G)((Grid)constructor.newInstance(arguments));
            }
            catch (Throwable throwable) {
                throw new ScriptParsingException(this.fatalError().toString(), throwable, null);
            }
        }

        public void addConstructor() {
            for (Input input : this.gridInputs.values()) {
                this.clazz.node.fields.add(input.fieldNode());
            }
            MethodCompileContext constructor = this.clazz.newMethod(1, "<init>", TypeInfos.VOID, (LazyVarInfo[])this.gridInputs.keySet().stream().map(name -> new LazyVarInfo((String)name, this.gridTypeInfo.type)).toArray(LazyVarInfo[]::new));
            LazyVarInfo self = new LazyVarInfo("this", constructor.clazz.info);
            InsnTrees.invokeInstance(InsnTrees.load(self), OBJECT_CONSTRUCTOR, new InsnTree[0]).emitBytecode(constructor);
            constructor.node.visitLabel(InsnTrees.label());
            for (Input input : this.gridInputs.values()) {
                LazyVarInfo parameter = input.gridParameter();
                new PutFieldInsnTree(new LoadInsnTree(self), input.fieldInfo(constructor), new LoadInsnTree(parameter)).emitBytecode(constructor);
                constructor.node.visitLabel(InsnTrees.label());
            }
            constructor.node.visitInsn(177);
            constructor.endCode();
        }

        public void addGetValue() {
            int dimension;
            int dimensions = this.gridTypeInfo.dimensions;
            ArrayList<LazyVarInfo> list = new ArrayList<LazyVarInfo>(dimensions + 1);
            list.add(new LazyVarInfo("seed", TypeInfos.LONG));
            for (int dimension2 = 0; dimension2 < dimensions; ++dimension2) {
                list.add(new LazyVarInfo(Parser.coordName(dimension2), TypeInfos.INT));
            }
            MethodCompileContext getValue = this.clazz.newMethod(1, "getValue", TypeInfos.DOUBLE, list.toArray(new LazyVarInfo[list.size()]));
            LazyVarInfo thisVar = new LazyVarInfo("this", getValue.clazz.info);
            LazyVarInfo seed = new LazyVarInfo("seed", TypeInfos.LONG);
            LazyVarInfo[] coordinates = new LazyVarInfo[dimensions];
            for (dimension = 0; dimension < dimensions; ++dimension) {
                coordinates[dimension] = new LazyVarInfo(Parser.coordName(dimension), TypeInfos.INT);
            }
            for (dimension = 0; dimension < dimensions; ++dimension) {
                InsnTrees.load(coordinates[dimension]).emitBytecode(getValue);
            }
            for (Input input : this.gridInputs.values()) {
                InsnTrees.invokeInstance(InsnTrees.getField(InsnTrees.load(thisVar), input.fieldInfo(getValue)), new MethodInfo(513, this.gridTypeInfo.type, "getValue", TypeInfos.DOUBLE, InsnTrees.types(Character.valueOf('J'), Character.valueOf('I'), dimensions)), (InsnTree[])Stream.concat(Stream.of(InsnTrees.load(seed)), Arrays.stream(coordinates).map(InsnTrees::load)).toArray(InsnTree[]::new)).emitBytecode(getValue);
            }
            getValue.node.visitMethodInsn(184, getValue.clazz.info.getInternalName(), "evaluate", "(" + "I".repeat(dimensions) + "D".repeat(this.gridInputs.size()) + ")D", false);
            getValue.node.visitInsn(175);
            getValue.endCode();
        }

        public void addEvaluate() throws ScriptParsingException {
            this.parseEntireInput().emitBytecode(this.method);
            this.method.endCode();
        }

        public void addSource() {
            MethodCompileContext getSource = this.clazz.newMethod(1, "getSource", TypeInfos.STRING, new LazyVarInfo[0]);
            InsnTrees.return_(InsnTrees.ldc(this.clazz.newConstant(this.input.getSource(), TypeInfos.STRING))).emitBytecode(getSource);
            getSource.endCode();
        }

        public void addToString() {
            this.clazz.addToString(this.getClass().getEnclosingClass().getSimpleName() + ".evaluate(): " + this.input.getSource());
        }

        @Override
        public InsnTree createReturn(InsnTree value) {
            return InsnTrees.return_(InsnTrees.invokeStatic(CHECK_NAN, value.cast(this, TypeInfos.DOUBLE, InsnTree.CastMode.IMPLICIT_THROW, false)));
        }

        public static String coordName(int dimension) {
            return String.valueOf((char)(120 + dimension));
        }

        public static InsnTree maybeAdd(ExpressionParser parser, LazyVarInfo variable, LazyVarInfo index, int variableDimension, int methodDimension) {
            return variableDimension == methodDimension ? InsnTrees.add(parser, (InsnTree)InsnTrees.load(variable), (InsnTree)InsnTrees.load(index)) : InsnTrees.load(variable);
        }

        public static double checkNaN(double result) {
            return result == result ? result : 0.0;
        }
    }
}

