/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.processing;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseVerifier;
import builderb0y.autocodec.verifiers.VerifyContext;
import builderb0y.autocodec.verifiers.VerifyException;
import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.noise.processing.UnaryGrid;

@UseVerifier(name="verify", usage=MemberUsage.METHOD_IS_HANDLER, strict=false)
public abstract class ChangeRangeGrid
implements UnaryGrid {
    public final double min;
    public final double max;
    public final transient double multiplier;
    public final transient double adder;

    public ChangeRangeGrid(Grid grid, double min, double max) {
        this.min = min;
        this.max = max;
        this.multiplier = (max - min) / (grid.maxValue() - grid.minValue());
        this.adder = min - grid.minValue() * this.multiplier;
    }

    public static <T_Encoded> void verify(VerifyContext<T_Encoded, ? extends ChangeRangeGrid> context) throws VerifyException {
        ChangeRangeGrid grid = (ChangeRangeGrid)context.object;
        if (!(grid == null || grid.multiplier != 0.0 && Double.isFinite(grid.multiplier) && Double.isFinite(grid.adder))) {
            throw new VerifyException(() -> context.pathToStringBuilder().append(" cannot change range from [").append(grid.getGrid().minValue()).append(", ").append(grid.getGrid().maxValue()).append("] to [").append(grid.min).append(", ").append(grid.max).append(']').toString());
        }
    }

    @Override
    public double minValue() {
        return this.min;
    }

    @Override
    public double maxValue() {
        return this.max;
    }

    @Override
    public double operate(double value) {
        return value * this.multiplier + this.adder;
    }
}

