/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.processing;

import builderb0y.bigglobe.noise.Grid1D;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.noise.processing.LayeredGrid;

public interface LayeredGrid1D
extends LayeredGrid,
Grid1D {
    public Grid1D[] getLayers();

    @Override
    default public double getValue(long seed, int x) {
        Grid1D[] layers = this.getLayers();
        double value = layers[0].getValue(seed, x);
        if (this.isProduct()) {
            int length = layers.length;
            for (int index = 1; index < length; ++index) {
                value *= layers[index].getValue(seed, x);
            }
        } else {
            int length = layers.length;
            for (int index = 1; index < length; ++index) {
                value += layers[index].getValue(seed, x);
            }
        }
        return value;
    }

    @Override
    default public void getBulkX(long seed, int startX, NumberArray samples) {
        if (samples.length() <= 0) {
            return;
        }
        Grid1D[] layers = this.getLayers();
        layers[0].getBulkX(seed, startX, samples);
        try (NumberArray scratch = NumberArray.allocateDoublesDirect(samples.length());){
            int length = layers.length;
            for (int layerIndex = 1; layerIndex < length; ++layerIndex) {
                layers[layerIndex].getBulkX(seed, startX, scratch);
                this.accumulate(samples, scratch);
            }
        }
    }
}

