/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.randomSources;

import builderb0y.autocodec.annotations.VerifySorted;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomSources.RandomSource;
import java.util.random.RandomGenerator;

public class AveragedRandomSource
implements RandomSource {
    public final double min;
    public final double max;
    public final @VerifySorted(greaterThan={"min"}, lessThan={"max"}) double average;
    public final transient double coefficient;

    public AveragedRandomSource(double min, double max, double average) {
        this.min = min;
        this.max = max;
        this.average = average;
        this.coefficient = AveragedRandomSource.computeCoefficient(Interpolator.unmixLinear(min, max, average));
    }

    public static double computeCoefficient(double average) {
        double firstPart = 1.0 / average - 1.0;
        double secondPart = 1.0 / Math.sqrt(firstPart * firstPart * firstPart);
        return secondPart - 1.0;
    }

    public static double applyBias(double unbiased, double coefficient) {
        return (coefficient * unbiased + unbiased) / (coefficient * unbiased + 1.0);
    }

    public double curve(double unbiased) {
        return this.mix(AveragedRandomSource.applyBias(unbiased, this.coefficient));
    }

    @Override
    public double get(ScriptedColumn column, int y, long seed) {
        return this.curve(Permuter.nextPositiveDouble(seed));
    }

    @Override
    public double get(ScriptedColumn column, int y, RandomGenerator random) {
        return this.curve(random.nextDouble());
    }

    @Override
    public double minValue() {
        return this.min;
    }

    @Override
    public double maxValue() {
        return this.max;
    }
}

