/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering;

import builderb0y.bigglobe.util.SafeCloseable;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class NativeMemory
implements SafeCloseable {
    public long address;
    public long capacity;
    public long used;

    public NativeMemory() {
    }

    public NativeMemory(long capacity) {
        this.address = MemoryUtil.nmemAllocChecked((long)capacity);
        if (this.address == 0L) {
            throw new OutOfMemoryError();
        }
        this.capacity = capacity;
    }

    public boolean isEmpty() {
        return this.used == 0L;
    }

    public void clear() {
        this.used = 0L;
    }

    public byte getByte(long byteOffset) {
        return MemoryUtil.memGetByte((long)(Objects.checkIndex(byteOffset, this.used) + this.address));
    }

    public short getShort(long byteOffset) {
        return MemoryUtil.memGetShort((long)(Objects.checkIndex(byteOffset, this.used - 1L) + this.address));
    }

    public int getInt(long byteOffset) {
        return MemoryUtil.memGetInt((long)(Objects.checkIndex(byteOffset, this.used - 3L) + this.address));
    }

    public long getLong(long byteOffset) {
        return MemoryUtil.memGetLong((long)(Objects.checkIndex(byteOffset, this.used - 7L) + this.address));
    }

    public float getFloat(long byteOffset) {
        return MemoryUtil.memGetFloat((long)(Objects.checkIndex(byteOffset, this.used - 3L) + this.address));
    }

    public double getDouble(long byteOffset) {
        return MemoryUtil.memGetDouble((long)(Objects.checkIndex(byteOffset, this.used - 7L) + this.address));
    }

    public long ensureCapacity(long minCapacity) {
        if (this.capacity < minCapacity) {
            long newCapacity = this.capacity << 1;
            newCapacity = newCapacity < 0L ? Long.MAX_VALUE : Math.max(Math.max(newCapacity, 1024L), minCapacity);
            this.address = this.address == 0L ? MemoryUtil.nmemAllocChecked((long)newCapacity) : MemoryUtil.nmemReallocChecked((long)this.address, (long)newCapacity);
            this.capacity = newCapacity;
        }
        return this.address;
    }

    public void appendEmpty(int dataSize) {
        this.used = Math.addExact(this.used, (long)dataSize);
        this.ensureCapacity(this.used);
    }

    public long addressForAppending(int dataSize) {
        long nextSize = Math.addExact(this.used, (long)dataSize);
        long address = this.ensureCapacity(nextSize) + this.used;
        this.used = nextSize;
        return address;
    }

    public void appendByte(byte value) {
        MemoryUtil.memPutByte((long)this.addressForAppending(1), (byte)value);
    }

    public void appendShort(short value) {
        MemoryUtil.memPutShort((long)this.addressForAppending(2), (short)value);
    }

    public void appendInt(int value) {
        MemoryUtil.memPutInt((long)this.addressForAppending(4), (int)value);
    }

    public void appendLong(long value) {
        MemoryUtil.memPutLong((long)this.addressForAppending(8), (long)value);
    }

    public void appendFloat(float value) {
        MemoryUtil.memPutFloat((long)this.addressForAppending(4), (float)value);
    }

    public void appendDouble(double value) {
        MemoryUtil.memPutDouble((long)this.addressForAppending(8), (double)value);
    }

    public void appendBytes(byte ... values) {
        long address = this.addressForAppending(values.length);
        for (byte value : values) {
            MemoryUtil.memPutByte((long)address, (byte)value);
            ++address;
        }
    }

    public void appendShorts(short ... values) {
        long address = this.addressForAppending(Math.multiplyExact(values.length, 2));
        for (short value : values) {
            MemoryUtil.memPutShort((long)address, (short)value);
            ++address;
        }
    }

    public void appendInts(int ... values) {
        long address = this.addressForAppending(Math.multiplyExact(values.length, 4));
        for (int value : values) {
            MemoryUtil.memPutInt((long)address, (int)value);
            ++address;
        }
    }

    public void appendLongs(long ... values) {
        long address = this.addressForAppending(Math.multiplyExact(values.length, 8));
        for (long value : values) {
            MemoryUtil.memPutLong((long)address, (long)value);
            ++address;
        }
    }

    public void appendFloats(float ... values) {
        long address = this.addressForAppending(Math.multiplyExact(values.length, 4));
        for (float value : values) {
            MemoryUtil.memPutFloat((long)address, (float)value);
            ++address;
        }
    }

    public void appendDoubles(double ... values) {
        long address = this.addressForAppending(Math.multiplyExact(values.length, 8));
        for (double value : values) {
            MemoryUtil.memPutDouble((long)address, (double)value);
            ++address;
        }
    }

    @Override
    public void close() {
        long address = this.address;
        if (address != 0L) {
            this.address = 0L;
            this.capacity = 0L;
            this.used = 0L;
            MemoryUtil.nmemFree((long)address);
        }
    }
}

