/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.hyperspace;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.rendering.ScreenTriangleShader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL20C;

@Environment(value=EnvType.CLIENT)
public class HyperspaceBackgroundShader
extends ScreenTriangleShader {
    public int inverseModelView;
    public int inverseProjection;
    public int cameraPosition;
    public int time;

    public HyperspaceBackgroundShader() {
        try {
            this.compileStage(this.fragmentStage, "#version 150\n\nuniform mat4 inverseModelView;\nuniform mat4 inverseProjection;\nuniform vec3 cameraPosition;\nuniform float time;\n\nin vec2 texcoord;\n\nout vec4 fragColor;\n\nconst float PI = 3.14159265359;\nconst float TAU = PI * 2.0;\n\nfloat square(float f) {\n\treturn f * f;\n}\n\nvec2 square(vec2 v) {\n\treturn v * v;\n}\n\nvec3 square(vec3 v) {\n\treturn v * v;\n}\n\nvec3 smoothify(vec3 v) {\n\treturn v * v * (v * -2.0 + 3.0);\n}\n\nvec2 hash21(float p) {\n\tvec3 p3 = fract(vec3(p) * vec3(0.1031, 0.1030, 0.0973));\n\tp3 += dot(p3, p3.yzx + 33.33);\n\treturn fract((p3.xx + p3.yz) * p3.zy);\n}\n\nvec3 unitVec(float seed) {\n\tvec2 surface = hash21(seed) * vec2(2.0, TAU) - vec2(1.0, 0.0);\n\tfloat r = sqrt(1.0 - surface.x * surface.x);\n\treturn vec3(vec2(cos(surface.y), sin(surface.y)) * r, surface.x);\n}\n\nvec2 hash23(vec3 p3) {\n\tp3 = fract(p3 * vec3(0.1031, 0.1030, 0.0973));\n\tp3 += dot(p3, p3.yzx + 33.33);\n\treturn fract((p3.xx + p3.yz) * p3.zy);\n}\n\nvec2 noise23(vec3 coord) {\n\tvec3  fractCoord = fract(coord);\n\tvec3  floorCoord = coord - fractCoord;\n\tvec3   ceilCoord = floorCoord + vec3(1.0);\n\tvec3 smoothCoord = smoothify(fractCoord);\n\n\treturn mix(\n\t\tmix(\n\t\t\tmix(\n\t\t\t\thash23(vec3(floorCoord.x, floorCoord.y, floorCoord.z)),\n\t\t\t\thash23(vec3(floorCoord.x, floorCoord.y,  ceilCoord.z)),\n\t\t\t\tsmoothCoord.z\n\t\t\t),\n\t\t\tmix(\n\t\t\t\thash23(vec3(floorCoord.x,  ceilCoord.y, floorCoord.z)),\n\t\t\t\thash23(vec3(floorCoord.x,  ceilCoord.y,  ceilCoord.z)),\n\t\t\t\tsmoothCoord.z\n\t\t\t),\n\t\t\tsmoothCoord.y\n\t\t),\n\t\tmix(\n\t\t\tmix(\n\t\t\t\thash23(vec3( ceilCoord.x, floorCoord.y, floorCoord.z)),\n\t\t\t\thash23(vec3( ceilCoord.x, floorCoord.y,  ceilCoord.z)),\n\t\t\t\tsmoothCoord.z\n\t\t\t),\n\t\t\tmix(\n\t\t\t\thash23(vec3( ceilCoord.x,  ceilCoord.y, floorCoord.z)),\n\t\t\t\thash23(vec3( ceilCoord.x,  ceilCoord.y,  ceilCoord.z)),\n\t\t\t\tsmoothCoord.z\n\t\t\t),\n\t\t\tsmoothCoord.y\n\t\t),\n\t\tsmoothCoord.x\n\t);\n}\n\nvec2 backgroundNoise(vec3 norm) {\n\tvec2 noise = noise23(norm);\n\treturn vec2(abs(noise.x - 0.5), noise.y);\n}\n\nvec3 smoothHue(float h) {\n\treturn sqrt(normalize(square(cos(h * TAU - vec3(0.0, 1.0, 2.0) * (TAU / 3.0)) * 0.5 + 0.5)));\n}\n\nvec4 hash42(vec2 p) {\n\tvec4 p4 = fract(p.xyxy * vec4(0.1031, 0.1030, 0.0973, 0.1099));\n\tp4 += dot(p4, p4.wzxy + 33.33);\n\treturn fract((p4.xxyz + p4.yzzw) * p4.zywx);\n}\n\nvoid main() {\n\tvec4 tmp = inverseProjection * vec4(texcoord * 2.0 - 1.0, 1.0, 1.0);\n\tvec3 norm = normalize(mat3(inverseModelView) * tmp.xyz);\n\tvec3 offsetNorm = norm + cameraPosition * 0.015625;\n\n\tvec2 noise = vec2(0.0);\n\tnoise += backgroundNoise(offsetNorm *  2.0) * 0.5;\n\tnoise += backgroundNoise(offsetNorm *  4.0) * 0.25;\n\tnoise += backgroundNoise(offsetNorm *  8.0) * 0.125;\n\tnoise += backgroundNoise(offsetNorm * 16.0) * 0.0625;\n\tnoise += backgroundNoise(offsetNorm * 32.0) * 0.03125;\n\tnoise += backgroundNoise(offsetNorm * 64.0) * 0.015625;\n\n\tvec3 color = mix(smoothHue(noise.y * 0.5 + 0.375), vec3(1.0), noise.x) * noise.x;\n\n\tvec3 starSum = vec3(0.0);\n\n\tfor (int planeIndex = 1; planeIndex <= 16; planeIndex++) {\n\t\tvec3 axis1 = unitVec( float(planeIndex));\n\t\tvec3 axis2 = unitVec(-float(planeIndex));\n\t\taxis2 = normalize(axis2 - axis1 * dot(axis1, axis2));\n\t\tvec2 planePos = vec2(dot(norm, axis1), dot(norm, axis2));\n\t\tfloat planeIntensity = 1.0 - dot(planePos, planePos);\n\t\tvec2 scaledPlanePos = planePos * 16.0;\n\t\tvec2 fractPos = fract(scaledPlanePos);\n\t\tvec2 floorPos = scaledPlanePos - fractPos;\n\t\tvec4 starData = hash42(floorPos);\n\t\tvec2  starPos = mix(starData.xy, vec2(0.5), starData.z);\n\t\tfloat starIntensity = max(1.0 - 2.0 * distance(fractPos, starPos) / starData.z, 0.0);\n\t\tstarIntensity = square(square(square(starIntensity)));\n\t\tstarIntensity *= sin(time + starData.w * TAU) * 0.5 + 0.5;\n\t\tvec3 starColor = exp2((starData.z * 8.0 - 7.0) * (vec3(1.0, 2.0, 4.0) / 4.0));\n\t\tstarSum += starColor * starIntensity * planeIntensity;\n\t}\n\tstarSum *= noise.x;\n\n\tcolor += starSum * 4.0;\n\tfloat distanceFromOrigin = length(cameraPosition);\n\tcolor *= exp2((dot(norm, cameraPosition) / distanceFromOrigin * -0.5 - 0.5) * distanceFromOrigin * 0.03125);\n\n\tfragColor = vec4(color, 1.0);\n}\n");
            this.link();
            this.inverseModelView = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"inverseModelView");
            this.inverseProjection = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"inverseProjection");
            this.cameraPosition = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"cameraPosition");
            this.time = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"time");
        }
        catch (Throwable throwable) {
            this.close();
            throw AutoCodecUtil.rethrow((Throwable)throwable);
        }
    }
}

