/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.rendering.ResourceTracker;
import builderb0y.bigglobe.rendering.lods.CompactVertexConsumer;
import builderb0y.bigglobe.rendering.lods.CompactVertexFormat;
import builderb0y.bigglobe.rendering.lods.VersionedVertexConsumerProvider;
import builderb0y.bigglobe.rendering.lods.VertexHeap;
import builderb0y.bigglobe.util.SafeCloseable;
import builderb0y.bigglobe.versions.RenderVersions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public record LodPasses(@Nullable Geometry opaque, @Nullable Geometry translucent) implements SafeCloseable
{
    @Nullable
    public Geometry getGeometry(boolean translucent) {
        return translucent ? this.translucent : this.opaque;
    }

    @Override
    public void close() {
        ResourceTracker.closeAll(this.opaque, this.translucent);
    }

    @Environment(value=EnvType.CLIENT)
    public record Geometry(CompactVertexFormat format, VertexHeap.Slice slice, int vertexCount, int indexCount) implements SafeCloseable
    {
        public static Geometry from(CompactVertexConsumer builder, VertexHeap heap) {
            try (CompactVertexConsumer compactVertexConsumer = builder;){
                if ((builder.vertexCount & 3) != 0) {
                    throw new IllegalArgumentException("Incomplete quad!");
                }
                VertexHeap.Slice slice = heap.allocate(builder.memory.address, builder.memory.used);
                if (slice != null) {
                    Geometry geometry = new Geometry(builder.format, slice, builder.vertexCount, builder.vertexCount / 4 * 6);
                    return geometry;
                }
                Geometry geometry = null;
                return geometry;
            }
        }

        public int baseVertex() {
            return Math.toIntExact(this.slice.key.position() / (long)this.format.byteStride);
        }

        @Override
        public void close() {
            this.slice.close();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Builder(CompactVertexConsumer opaque, CompactVertexConsumer translucent) implements SafeCloseable,
    VersionedVertexConsumerProvider
    {
        public Builder(CompactVertexFormat format, int initialVertexCount) {
            this(new CompactVertexConsumer(initialVertexCount, format), new CompactVertexConsumer(initialVertexCount, format));
        }

        public class_4588 getBuffer(class_1921 layer) {
            return RenderVersions.isTranslucent(layer) ? this.translucent : this.opaque;
        }

        public LodPasses build(VertexHeap heap) {
            try (ResourceTracker tracker = new ResourceTracker();){
                Geometry opaque = tracker.track(Geometry.from(this.opaque, heap));
                Geometry translucent = tracker.track(Geometry.from(this.translucent, heap));
                tracker.untrackAll();
                LodPasses lodPasses = new LodPasses(opaque, translucent);
                return lodPasses;
            }
        }

        @Override
        public void close() {
            ResourceTracker.closeAll(this.opaque, this.translucent);
        }
    }
}

