/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.rendering.GLException;
import builderb0y.bigglobe.rendering.NativeMemory;
import builderb0y.bigglobe.rendering.ResourceTracker;
import builderb0y.bigglobe.rendering.lods.AbstractLodRenderer;
import builderb0y.bigglobe.rendering.lods.LodPasses;
import builderb0y.bigglobe.rendering.lods.LodRenderer;
import builderb0y.bigglobe.rendering.lods.LodVertexFormat;
import builderb0y.bigglobe.rendering.lods.SeparateLodShader;
import builderb0y.bigglobe.rendering.lods.SidedLodPasses;
import builderb0y.bigglobe.rendering.lods.SimpleLodRenderer;
import builderb0y.bigglobe.rendering.lods.VersionedVertexConsumerProvider;
import builderb0y.bigglobe.util.SafeCloseable;
import builderb0y.bigglobe.versions.RenderVersions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL32C;

@Environment(value=EnvType.CLIENT)
public class SidedSeparateLodRenderer
extends AbstractLodRenderer {
    public SimpleLodRenderer.DefaultLodState state = new SimpleLodRenderer.DefaultLodState();
    public SeparateLodShader shader;
    public NativeMemory multiDrawStarts;
    public NativeMemory multiDrawSizes;
    public NativeMemory zeros;
    public int drawCount;

    @Override
    public void close() {
        ResourceTracker.closeAll(() -> super.close(), this.shader, this.multiDrawStarts, this.multiDrawSizes, this.zeros);
    }

    public SidedSeparateLodRenderer(int quadCount) {
        super(quadCount);
        try {
            this.shader = new SeparateLodShader();
            this.multiDrawStarts = new NativeMemory(20L);
            this.multiDrawSizes = new NativeMemory(20L);
            this.zeros = new NativeMemory(40L);
        }
        catch (Throwable throwable) {
            this.close();
            throw AutoCodecUtil.rethrow((Throwable)throwable);
        }
    }

    @Override
    public SafeCloseable bind(LodRenderer.LodRenderState state, boolean translucent) {
        if (translucent) {
            this.state.inTranslucentPass = true;
            this.state.setBlend(true);
            this.state.setBlendFunc(770, 771, 1, 0);
        } else {
            this.state.capture();
            this.state.setVao(this.vao);
            this.state.setElementBuffer(this.elementBuffer.glID);
            this.setupOpaqueState(this.state);
            this.state.setProgram(this.shader.program);
            this.shader.bindTextures();
            this.setupUniforms(state, this.shader);
        }
        return () -> {
            if (this.state.inTranslucentPass) {
                this.depthBuffer.copyTo(RenderVersions.glID(class_310.method_1551().method_1522()));
                this.state.restore();
            }
        };
    }

    @Override
    public VersionedVertexConsumerProvider beginMeshing() {
        return new SidedLodPasses.Builder(LodVertexFormat.FORMAT, 36992);
    }

    @Override
    public LodRenderer.MeshUploader finishMeshing() {
        final SafeCloseable unbinder = this.heap.bind();
        return new LodRenderer.MeshUploader(){
            final /* synthetic */ SidedSeparateLodRenderer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public SafeCloseable upload(VersionedVertexConsumerProvider provider) {
                SidedLodPasses.Builder builder = (SidedLodPasses.Builder)provider;
                return builder.build(this.this$0.heap);
            }

            @Override
            public void close() {
                unbinder.close();
            }
        };
    }

    @Override
    public void endMeshing(VersionedVertexConsumerProvider provider) {
        SidedLodPasses.Builder builder = (SidedLodPasses.Builder)provider;
        builder.close();
    }

    @Override
    public void draw(SafeCloseable token, float modelOffsetX, float modelOffsetY, float modelOffsetZ, float scale) {
        SidedLodPasses passes = (SidedLodPasses)token;
        SidedLodPasses.Pass pass = passes.getPass(this.state.inTranslucentPass);
        if (pass != null) {
            if (pass.all() != null) {
                this.recordDraw(pass.all());
            }
            if (pass.posX() != null && modelOffsetX < 0.0f) {
                this.recordDraw(pass.posX());
            }
            if (pass.posZ() != null && modelOffsetZ < 0.0f) {
                this.recordDraw(pass.posZ());
            }
            if (pass.negX() != null && modelOffsetX + scale * 64.0f > 0.0f) {
                this.recordDraw(pass.negX());
            }
            if (pass.negZ() != null && modelOffsetZ + scale * 64.0f > 0.0f) {
                this.recordDraw(pass.negZ());
            }
            if (this.drawCount > 0) {
                GL32C.glUniform4f((int)this.shader.modelOffset, (float)modelOffsetX, (float)modelOffsetY, (float)modelOffsetZ, (float)scale);
                GL32C.nglMultiDrawElementsBaseVertex((int)4, (long)this.multiDrawSizes.address, (int)5125, (long)this.zeros.address, (int)this.drawCount, (long)this.multiDrawStarts.address);
                GLException.check();
                this.multiDrawStarts.clear();
                this.multiDrawSizes.clear();
                this.zeros.clear();
                this.drawCount = 0;
            }
        }
    }

    public void recordDraw(LodPasses.Geometry geometry) {
        this.multiDrawStarts.appendInt(geometry.baseVertex());
        this.multiDrawSizes.appendInt(geometry.indexCount());
        this.elementBuffer.ensureCapacity(geometry.indexCount());
        this.zeros.appendLong(0L);
        ++this.drawCount;
    }
}

