/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.waypoints;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.rendering.ScreenTriangleShader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL20C;

@Environment(value=EnvType.CLIENT)
public class WaypointWarpShader
extends ScreenTriangleShader {
    public int colortex;
    public int depthtex;
    public int modelViewMatrix;
    public int inverseModelViewMatrix;
    public int projectionMatrix;
    public int inverseProjectionMatrix;
    public int time;
    public int waypointCount;
    public int waypoints;

    public WaypointWarpShader() {
        try {
            this.compileStage(this.fragmentStage, "#version 150\n\nuniform sampler2D colortex;\nuniform sampler2D depthtex;\nuniform mat4 modelViewMatrix;\nuniform mat4 inverseModelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 inverseProjectionMatrix;\nuniform float time;\nuniform int waypointCount;\nuniform vec4 waypoints[16];\n\nin vec2 texcoord;\n\nout vec4 fragColor;\n\nconst float PI = 3.14159265359;\nconst float TAU = PI * 2.0;\n\nfloat square(float f) {\n\treturn f * f;\n}\n\nvec2 square(vec2 v) {\n\treturn v * v;\n}\n\nvec3 square(vec3 v) {\n\treturn v * v;\n}\n\nvec3 smoothify(vec3 v) {\n\treturn v * v * (v * -2.0 + 3.0);\n}\n\nvec2 hash21(float p) {\n\tvec3 p3 = fract(vec3(p) * vec3(0.1031, 0.1030, 0.0973));\n\tp3 += dot(p3, p3.yzx + 33.33);\n\treturn fract((p3.xx + p3.yz) * p3.zy);\n}\n\nvec2 hash23(vec3 p3) {\n\tp3 = fract(p3 * vec3(0.1031, 0.1030, 0.0973));\n\tp3 += dot(p3, p3.yzx + 33.33);\n\treturn fract((p3.xx + p3.yz) * p3.zy);\n}\n\nvec4 hash42(vec2 p) {\n\tvec4 p4 = fract(p.xyxy * vec4(0.1031, 0.1030, 0.0973, 0.1099));\n\tp4 += dot(p4, p4.wzxy + 33.33);\n\treturn fract((p4.xxyz + p4.yzzw) * p4.zywx);\n}\n\nvec3 unitVec(float seed) {\n\tvec2 surface = hash21(seed) * vec2(2.0, TAU) - vec2(1.0, 0.0);\n\tfloat r = sqrt(1.0 - surface.x * surface.x);\n\treturn vec3(vec2(cos(surface.y), sin(surface.y)) * r, surface.x);\n}\n\nvec2 noise23(vec3 coord) {\n\tvec3  fractCoord = fract(coord);\n\tvec3  floorCoord = coord - fractCoord;\n\tvec3   ceilCoord = floorCoord + vec3(1.0);\n\tvec3 smoothCoord = smoothify(fractCoord);\n\n\treturn mix(\n\t\tmix(\n\t\t\tmix(\n\t\t\t\thash23(vec3(floorCoord.x, floorCoord.y, floorCoord.z)),\n\t\t\t\thash23(vec3(floorCoord.x, floorCoord.y,  ceilCoord.z)),\n\t\t\t\tsmoothCoord.z\n\t\t\t),\n\t\t\tmix(\n\t\t\t\thash23(vec3(floorCoord.x,  ceilCoord.y, floorCoord.z)),\n\t\t\t\thash23(vec3(floorCoord.x,  ceilCoord.y,  ceilCoord.z)),\n\t\t\t\tsmoothCoord.z\n\t\t\t),\n\t\t\tsmoothCoord.y\n\t\t),\n\t\tmix(\n\t\t\tmix(\n\t\t\t\thash23(vec3( ceilCoord.x, floorCoord.y, floorCoord.z)),\n\t\t\t\thash23(vec3( ceilCoord.x, floorCoord.y,  ceilCoord.z)),\n\t\t\t\tsmoothCoord.z\n\t\t\t),\n\t\t\tmix(\n\t\t\t\thash23(vec3( ceilCoord.x,  ceilCoord.y, floorCoord.z)),\n\t\t\t\thash23(vec3( ceilCoord.x,  ceilCoord.y,  ceilCoord.z)),\n\t\t\t\tsmoothCoord.z\n\t\t\t),\n\t\t\tsmoothCoord.y\n\t\t),\n\t\tsmoothCoord.x\n\t);\n}\n\nvec2 backgroundNoise(vec3 norm) {\n\tvec2 noise = noise23(norm);\n\treturn vec2(abs(noise.x - 0.5), noise.y);\n}\n\nvec3 smoothHue(float h) {\n\treturn sqrt(normalize(square(cos(h * TAU - vec3(0.0, 1.0, 2.0) * (TAU / 3.0)) * 0.5 + 0.5)));\n}\n\nvoid main() {\n\tvec3 uv = vec3(texcoord, texture(depthtex, texcoord).r);\n\tvec4 tmp = inverseModelViewMatrix * (inverseProjectionMatrix * vec4(uv * 2.0 - 1.0, 1.0));\n\tvec3 playerDir = normalize(tmp.xyz);\n\tfloat maxIntensity = 0.0;\n\tfor (int index = 0; index < waypointCount; index++) {\n\t\tvec4 waypoint = waypoints[index];\n\t\tfloat distanceFromOriginToClosest = max(dot(waypoint.xyz, playerDir), 0.0);\n\t\tvec3 closest = playerDir * distanceFromOriginToClosest;\n\t\tfloat distanceFromClosestToWaypoint = distance(closest, waypoint.xyz);\n\t\tif (distanceFromClosestToWaypoint < 1.0) {\n\t\t\tvec4 screenSpaceWaypoint = projectionMatrix * (modelViewMatrix * vec4(waypoint.xyz, 1.0));\n\t\t\tscreenSpaceWaypoint.xyz = screenSpaceWaypoint.xyz / screenSpaceWaypoint.w * 0.5 + 0.5;\n\t\t\tif (screenSpaceWaypoint.z < uv.z) {\n\t\t\t\tfloat intensity = square(1.0 - distanceFromClosestToWaypoint) * 4.0 * waypoint.w;\n\t\t\t\tmaxIntensity += intensity;\n\t\t\t\tuv.xy = mix(uv.xy, screenSpaceWaypoint.xy, intensity);\n\t\t\t}\n\t\t}\n\t}\n\tif (maxIntensity > 1.0) {\n\t\tvec2 noise = vec2(0.0);\n\t\tnoise += backgroundNoise(playerDir *  2.0) * 0.5;\n\t\tnoise += backgroundNoise(playerDir *  4.0) * 0.25;\n\t\tnoise += backgroundNoise(playerDir *  8.0) * 0.125;\n\t\tnoise += backgroundNoise(playerDir * 16.0) * 0.0625;\n\t\tnoise += backgroundNoise(playerDir * 32.0) * 0.03125;\n\t\tnoise += backgroundNoise(playerDir * 64.0) * 0.015625;\n\n\t\tvec3 color = mix(smoothHue(noise.y * 0.5 + 0.375), vec3(1.0), noise.x) * noise.x;\n\t\tvec3 starSum = vec3(0.0);\n\n\t\tfor (int planeIndex = 1; planeIndex <= 16; planeIndex++) {\n\t\t\tvec3 axis1 = unitVec( float(planeIndex));\n\t\t\tvec3 axis2 = unitVec(-float(planeIndex));\n\t\t\taxis2 = normalize(axis2 - axis1 * dot(axis1, axis2));\n\t\t\tvec2 planePos = vec2(dot(playerDir, axis1), dot(playerDir, axis2));\n\t\t\tfloat planeIntensity = 1.0 - dot(planePos, planePos);\n\t\t\tvec2 scaledPlanePos = planePos * 16.0;\n\t\t\tvec2 fractPos = fract(scaledPlanePos);\n\t\t\tvec2 floorPos = scaledPlanePos - fractPos;\n\t\t\tvec4 starData = hash42(floorPos);\n\t\t\tvec2  starPos = mix(starData.xy, vec2(0.5), starData.z);\n\t\t\tfloat starIntensity = max(1.0 - 2.0 * distance(fractPos, starPos) / starData.z, 0.0);\n\t\t\tstarIntensity = square(square(square(starIntensity)));\n\t\t\tstarIntensity *= sin(time + starData.w * TAU) * 0.5 + 0.5;\n\t\t\tvec3 starColor = exp2((starData.z * 8.0 - 7.0) * (vec3(1.0, 2.0, 4.0) / 4.0));\n\t\t\tstarSum += starColor * starIntensity * planeIntensity;\n\t\t}\n\t\tstarSum *= noise.x;\n\n\t\tfragColor = vec4(color + starSum * 4.0, 1.0);\n\t}\n\telse {\n\t\tfragColor = texture(colortex, uv.xy);\n\t}\n\tfragColor.rgb *= sqrt(abs(maxIntensity - 1.0));\n}");
            this.link();
            this.colortex = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"colortex");
            this.depthtex = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"depthtex");
            this.modelViewMatrix = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"modelViewMatrix");
            this.inverseModelViewMatrix = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"inverseModelViewMatrix");
            this.projectionMatrix = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"projectionMatrix");
            this.inverseProjectionMatrix = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"inverseProjectionMatrix");
            this.time = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"time");
            this.waypointCount = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"waypointCount");
            this.waypoints = GL20C.glGetUniformLocation((int)this.program, (CharSequence)"waypoints");
        }
        catch (Throwable throwable) {
            this.close();
            throw AutoCodecUtil.rethrow((Throwable)throwable);
        }
    }
}

