/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.environments;

import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.RandomSwitch;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.environments.BuiltinScriptEnvironment;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.InfoHolder;
import builderb0y.scripting.util.TypeInfos;
import com.google.common.collect.ObjectArrays;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.random.RandomGenerator;
import java.util.stream.Stream;

public class RandomScriptEnvironment {
    public static final RandomGeneratorInfo RNG_INFO = new RandomGeneratorInfo();
    public static final PermuterInfo PERMUTER_INFO = new PermuterInfo();
    public static final MethodInfo ASSERT_FAIL = MethodInfo.findConstructor(AssertionError.class, String.class);
    public static final MutableScriptEnvironment BASE = new MutableScriptEnvironment().addType("Random", RandomGenerator.class).addQualifiedFunction(InsnTrees.type(RandomGenerator.class), "new", new MutableScriptEnvironment.FunctionHandler.Named("Random.new(long [, int...])", (parser, name, arguments) -> {
        if (arguments.length == 0) {
            return null;
        }
        MutableScriptEnvironment.CastResult seed = RandomScriptEnvironment.createSeed(parser, arguments);
        return new MutableScriptEnvironment.CastResult(InsnTrees.newInstance(RandomScriptEnvironment.PERMUTER_INFO.constructor, seed.tree()), seed.requiredCasting());
    })).addMethodInvoke("nextInt", RandomScriptEnvironment.RNG_INFO.nextInt).addMethodInvoke("nextInt", RandomScriptEnvironment.RNG_INFO.nextIntBound).addMethodInvoke("nextInt", RandomScriptEnvironment.RNG_INFO.nextIntOriginBound).addMethodInvoke("nextLong", RandomScriptEnvironment.RNG_INFO.nextLong).addMethodInvoke("nextLong", RandomScriptEnvironment.RNG_INFO.nextLongBound).addMethodInvoke("nextLong", RandomScriptEnvironment.RNG_INFO.nextLongOriginBound).addMethodInvoke("nextFloat", RandomScriptEnvironment.RNG_INFO.nextFloat).addMethodInvoke("nextFloat", RandomScriptEnvironment.RNG_INFO.nextFloatBound).addMethodInvoke("nextFloat", RandomScriptEnvironment.RNG_INFO.nextFloatOriginBound).addMethodInvoke("nextDouble", RandomScriptEnvironment.RNG_INFO.nextDouble).addMethodInvoke("nextDouble", RandomScriptEnvironment.RNG_INFO.nextDoubleBound).addMethodInvoke("nextDouble", RandomScriptEnvironment.RNG_INFO.nextDoubleOriginBound).addMethodInvoke("nextBoolean", RandomScriptEnvironment.RNG_INFO.nextBoolean).addMethodInvokeStatic("nextBoolean", RandomScriptEnvironment.PERMUTER_INFO.rngNextChancedBooleanF).addMethodInvokeStatic("nextBoolean", RandomScriptEnvironment.PERMUTER_INFO.rngNextChancedBooleanD).addMethodInvoke("nextGaussian", RandomScriptEnvironment.RNG_INFO.nextGaussian).addMethodInvoke("nextGaussian", RandomScriptEnvironment.RNG_INFO.nextGaussianMeanDev).addMethodInvoke("nextExponential", RandomScriptEnvironment.RNG_INFO.nextExponential).addMethodInvokeStatic("roundInt", RandomScriptEnvironment.PERMUTER_INFO.rngRoundRandomlyIF).addMethodInvokeStatic("roundInt", RandomScriptEnvironment.PERMUTER_INFO.rngRoundRandomlyID).addMethodInvokeStatic("roundLong", RandomScriptEnvironment.PERMUTER_INFO.rngRoundRandomlyLF).addMethodInvokeStatic("roundLong", RandomScriptEnvironment.PERMUTER_INFO.rngRoundRandomlyLD).addMemberKeyword(InsnTrees.type(RandomGenerator.class), "if", new MutableScriptEnvironment.MemberKeywordHandler.Named("random.if (chance: body)", (parser, receiver, name, mode) -> RandomScriptEnvironment.wrapRandomIf(parser, receiver, false, mode))).addMemberKeyword(InsnTrees.type(RandomGenerator.class), "unless", new MutableScriptEnvironment.MemberKeywordHandler.Named("random.unless (chance: body)", (parser, receiver, name, mode) -> RandomScriptEnvironment.wrapRandomIf(parser, receiver, true, mode))).addMemberKeyword(InsnTrees.type(RandomGenerator.class), "switch", new MutableScriptEnvironment.MemberKeywordHandler.Named("random.switch(case1, case2, ...) or random.switch(weight1: case1, weight2: case2, ...)", RandomScriptEnvironment.randomSwitch()));

    public static Consumer<MutableScriptEnvironment> create(InsnTree loader) {
        return environment -> environment.addAll(BASE).addVariable("random", loader);
    }

    public static MutableScriptEnvironment.CastResult createSeed(ExpressionParser parser, InsnTree ... arguments) {
        InsnTree seed = arguments[0].cast(parser, TypeInfos.LONG, InsnTree.CastMode.IMPLICIT_THROW, false);
        boolean needCasting = seed != arguments[0];
        int length = arguments.length;
        for (int index = 1; index < length; ++index) {
            InsnTree next = arguments[index].cast(parser, TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, false);
            needCasting |= next != arguments[index];
            seed = InsnTrees.invokeStatic(RandomScriptEnvironment.PERMUTER_INFO.permuteI, seed, next);
        }
        return new MutableScriptEnvironment.CastResult(seed, needCasting);
    }

    public static InsnTree wrapRandomIf(ExpressionParser parser, InsnTree receiver, boolean negate, ScriptEnvironment.MemberKeywordMode mode) throws ScriptParsingException {
        return mode.apply(receiver, actualReceiver -> RandomScriptEnvironment.randomIf(parser, actualReceiver, negate));
    }

    public static InsnTree randomIf(ExpressionParser parser, InsnTree receiver, boolean negate) throws ScriptParsingException {
        InsnTree conditionInsnTree;
        InsnTree body;
        parser.beginCodeBlock();
        InsnTree firstPart = parser.nextScript();
        if (parser.input.hasOperatorAfterWhitespace(":")) {
            TypeInfo.Sort sort = firstPart.getTypeInfo().getSort();
            if (sort != TypeInfo.Sort.FLOAT && sort != TypeInfo.Sort.DOUBLE) {
                throw new ScriptParsingException("random." + (negate ? "unless" : "if") + "() chance should be float or double, but was " + String.valueOf(firstPart.getTypeInfo()), parser.input);
            }
            body = parser.nextScript();
            conditionInsnTree = InsnTrees.invokeStatic(sort == TypeInfo.Sort.FLOAT ? RandomScriptEnvironment.PERMUTER_INFO.rngNextChancedBooleanF : RandomScriptEnvironment.PERMUTER_INFO.rngNextChancedBooleanD, receiver, firstPart);
        } else {
            conditionInsnTree = InsnTrees.invokeInstance(receiver, RandomScriptEnvironment.RNG_INFO.nextBoolean, new InsnTree[0]);
            body = firstPart;
        }
        parser.endCodeBlock();
        ConditionTree conditionTree = InsnTrees.condition(parser, conditionInsnTree);
        if (negate) {
            conditionTree = InsnTrees.not(conditionTree);
        }
        if (parser.input.hasIdentifierAfterWhitespace("else")) {
            return InsnTrees.ifElse(parser, conditionTree, body, BuiltinScriptEnvironment.tryParenthesized(parser));
        }
        return InsnTrees.ifThen(conditionTree, body);
    }

    public static MutableScriptEnvironment.MemberKeywordHandler randomSwitch() {
        return (parser, receiver, name, mode) -> {
            ScriptEnvironment.MemberKeywordMode.MemberKeywordFunction selector;
            parser.beginCodeBlock();
            Int2ObjectAVLTreeMap cases = new Int2ObjectAVLTreeMap();
            InsnTree first = parser.nextScript();
            if (parser.input.hasOperatorAfterWhitespace(",")) {
                cases.defaultReturnValue((Object)InsnTrees.throw_(InsnTrees.newInstance(ASSERT_FAIL, InsnTrees.ldc("Random returned value out of range"))));
                cases.put(0, (Object)first);
                do {
                    cases.put(cases.size(), (Object)parser.nextScript());
                } while (parser.input.hasOperatorAfterWhitespace(","));
                if (parser.endCodeBlock()) {
                    throw new ScriptParsingException("Can't declare variables *directly* inside a random switch.", parser.input);
                }
                selector = arg_0 -> RandomScriptEnvironment.lambda$randomSwitch$1((Int2ObjectSortedMap)cases, parser, arg_0);
            } else if (parser.input.hasOperatorAfterWhitespace(":")) {
                ArrayList<InsnTree> weights = new ArrayList<InsnTree>();
                weights.add(first);
                cases.put(0, (Object)parser.nextScript());
                while (parser.input.hasOperatorAfterWhitespace(",")) {
                    if (parser.input.hasIdentifierAfterWhitespace("default")) {
                        if (cases.defaultReturnValue() != null) {
                            throw new ScriptParsingException("Default already provided", parser.input);
                        }
                        parser.input.expectOperatorAfterWhitespace(":");
                        cases.defaultReturnValue((Object)parser.nextScript());
                        continue;
                    }
                    weights.add(parser.nextScript());
                    parser.input.expectOperatorAfterWhitespace(":");
                    cases.put(cases.size(), (Object)parser.nextScript());
                }
                if (parser.endCodeBlock()) {
                    throw new ScriptParsingException("Can't declare variables *directly* inside a random switch.", parser.input);
                }
                TypeInfo weightType = TypeInfos.widenUntilSameInt(weights.stream().map(InsnTree::getTypeInfo));
                weights.replaceAll(tree -> tree.cast(parser, weightType, InsnTree.CastMode.IMPLICIT_THROW, false));
                if (cases.defaultReturnValue() == null && weights.stream().map(InsnTree::getConstantValue).anyMatch(value -> value.isConstant() && value.asDouble() > 0.0)) {
                    cases.defaultReturnValue((Object)InsnTrees.throw_(InsnTrees.newInstance(ASSERT_FAIL, InsnTrees.ldc("Random returned value out of range"))));
                }
                MethodInfo runtimeMethod = new MethodInfo(1, TypeInfos.OBJECT, "randomSwitch", TypeInfos.INT, (TypeInfo[])Stream.concat(Stream.of(receiver.getTypeInfo()), weights.stream().filter(tree -> !tree.getConstantValue().isConstantOrDynamic()).map(InsnTree::getTypeInfo)).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY));
                ConstantValue[] constantArgs = (ConstantValue[])Stream.concat(Stream.of(InsnTrees.constant(weightType)), weights.stream().map(tree -> tree.getConstantValue().isConstantOrDynamic() ? tree.getConstantValue() : InsnTrees.constant(0, tree.getTypeInfo()))).toArray((IntFunction<A[]>)ConstantValue.ARRAY_FACTORY);
                InsnTree[] runtimeArgs = (InsnTree[])weights.stream().filter(tree -> !tree.getConstantValue().isConstantOrDynamic()).toArray((IntFunction<A[]>)InsnTree.ARRAY_FACTORY);
                selector = arg_0 -> RandomScriptEnvironment.lambda$randomSwitch$7(parser, runtimeMethod, constantArgs, runtimeArgs, (Int2ObjectSortedMap)cases, arg_0);
            } else {
                throw new ScriptParsingException("Expected ',' or ':'", parser.input);
            }
            return (switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case ScriptEnvironment.MemberKeywordMode.NORMAL -> ScriptEnvironment.MemberKeywordMode.NORMAL;
                case ScriptEnvironment.MemberKeywordMode.NULLABLE -> ScriptEnvironment.MemberKeywordMode.NULLABLE;
                case ScriptEnvironment.MemberKeywordMode.RECEIVER -> ScriptEnvironment.MemberKeywordMode.RECEIVER;
                case ScriptEnvironment.MemberKeywordMode.NULLABLE_RECEIVER -> ScriptEnvironment.MemberKeywordMode.NULLABLE_RECEIVER;
            }).apply(receiver, selector);
        };
    }

    private static /* synthetic */ InsnTree lambda$randomSwitch$7(ExpressionParser parser, MethodInfo runtimeMethod, ConstantValue[] constantArgs, InsnTree[] runtimeArgs, Int2ObjectSortedMap cases, InsnTree actualReceiver) throws ScriptParsingException {
        return InsnTrees.switch_(parser, InsnTrees.invokeDynamic(RandomSwitch.BOOTSTRAP_METHOD, runtimeMethod, constantArgs, (InsnTree[])ObjectArrays.concat((Object)actualReceiver, (Object[])runtimeArgs)), (Int2ObjectSortedMap<InsnTree>)cases);
    }

    private static /* synthetic */ InsnTree lambda$randomSwitch$1(Int2ObjectSortedMap cases, ExpressionParser parser, InsnTree actualReceiver) throws ScriptParsingException {
        InsnTree switchValue;
        if (actualReceiver.getTypeInfo().equals(InsnTrees.type(RandomGenerator.class))) {
            switchValue = InsnTrees.invokeInstance(actualReceiver, RandomScriptEnvironment.RNG_INFO.nextIntBound, InsnTrees.ldc(cases.size()));
        } else if (actualReceiver.getTypeInfo().equals(TypeInfos.LONG)) {
            switchValue = InsnTrees.invokeStatic(RandomScriptEnvironment.PERMUTER_INFO.nextIntBound, actualReceiver, InsnTrees.ldc(cases.size()));
        } else {
            throw new InvalidOperandException("Expected receiver to be long or RandomGenerator, but it was " + String.valueOf(actualReceiver));
        }
        return InsnTrees.switch_(parser, switchValue, (Int2ObjectSortedMap<InsnTree>)cases);
    }

    public static class PermuterInfo
    extends InfoHolder {
        @InfoHolder.Disambiguate(name="new", returnType=void.class, paramTypes={long.class})
        public MethodInfo constructor;
        @InfoHolder.Disambiguate(name="permute", returnType=long.class, paramTypes={long.class, int.class})
        public MethodInfo permuteI;
        public MethodInfo nextUniformInt;
        public MethodInfo toUniformInt;
        public MethodInfo nextPositiveInt;
        public MethodInfo toPositiveInt;
        @InfoHolder.Disambiguate(name="nextBoundedInt", returnType=int.class, paramTypes={long.class, int.class})
        public MethodInfo nextIntBound;
        @InfoHolder.Disambiguate(name="nextBoundedInt", returnType=int.class, paramTypes={long.class, int.class, int.class})
        public MethodInfo nextIntOriginBound;
        public MethodInfo nextUniformLong;
        public MethodInfo toUniformLong;
        public MethodInfo nextPositiveLong;
        public MethodInfo toPositiveLong;
        @InfoHolder.Disambiguate(name="nextBoundedLong", returnType=long.class, paramTypes={long.class, long.class})
        public MethodInfo nextLongBound;
        @InfoHolder.Disambiguate(name="nextBoundedLong", returnType=long.class, paramTypes={long.class, long.class, long.class})
        public MethodInfo nextLongOriginBound;
        @InfoHolder.Disambiguate(name="nextPositiveFloat", returnType=float.class, paramTypes={long.class})
        public MethodInfo nextUniformFloat;
        public MethodInfo toUniformFloat;
        public MethodInfo nextPositiveFloat;
        public MethodInfo toPositiveFloat;
        @InfoHolder.Disambiguate(name="nextBoundedFloat", returnType=float.class, paramTypes={long.class, float.class})
        public MethodInfo nextFloatBound;
        @InfoHolder.Disambiguate(name="nextBoundedFloat", returnType=float.class, paramTypes={long.class, float.class, float.class})
        public MethodInfo nextFloatOriginBound;
        @InfoHolder.Disambiguate(name="nextUniformDouble", returnType=double.class, paramTypes={long.class})
        public MethodInfo nextUniformDouble;
        public MethodInfo toUniformDouble;
        public MethodInfo nextPositiveDouble;
        public MethodInfo toPositiveDouble;
        @InfoHolder.Disambiguate(name="nextBoundedDouble", returnType=double.class, paramTypes={long.class, double.class})
        public MethodInfo nextDoubleBound;
        @InfoHolder.Disambiguate(name="nextBoundedDouble", returnType=double.class, paramTypes={long.class, double.class, double.class})
        public MethodInfo nextDoubleOriginBound;
        public MethodInfo nextBoolean;
        public MethodInfo toBoolean;
        @InfoHolder.Disambiguate(name="nextChancedBoolean", returnType=boolean.class, paramTypes={long.class, float.class})
        public MethodInfo nextChancedBooleanF;
        @InfoHolder.Disambiguate(name="nextChancedBoolean", returnType=boolean.class, paramTypes={long.class, double.class})
        public MethodInfo nextChancedBooleanD;
        @InfoHolder.Disambiguate(name="toChancedBoolean", returnType=boolean.class, paramTypes={long.class, float.class})
        public MethodInfo toChancedBooleanF;
        @InfoHolder.Disambiguate(name="toChancedBoolean", returnType=boolean.class, paramTypes={long.class, double.class})
        public MethodInfo toChancedBooleanD;
        @InfoHolder.Disambiguate(name="nextChancedBoolean", returnType=boolean.class, paramTypes={RandomGenerator.class, float.class})
        public MethodInfo rngNextChancedBooleanF;
        @InfoHolder.Disambiguate(name="nextChancedBoolean", returnType=boolean.class, paramTypes={RandomGenerator.class, double.class})
        public MethodInfo rngNextChancedBooleanD;
        @InfoHolder.Disambiguate(name="roundRandomlyI", returnType=int.class, paramTypes={long.class, float.class})
        public MethodInfo roundRandomlyIF;
        @InfoHolder.Disambiguate(name="roundRandomlyI", returnType=int.class, paramTypes={long.class, double.class})
        public MethodInfo roundRandomlyID;
        @InfoHolder.Disambiguate(name="roundRandomlyL", returnType=long.class, paramTypes={long.class, float.class})
        public MethodInfo roundRandomlyLF;
        @InfoHolder.Disambiguate(name="roundRandomlyL", returnType=long.class, paramTypes={long.class, double.class})
        public MethodInfo roundRandomlyLD;
        @InfoHolder.Disambiguate(name="roundRandomlyI", returnType=int.class, paramTypes={RandomGenerator.class, float.class})
        public MethodInfo rngRoundRandomlyIF;
        @InfoHolder.Disambiguate(name="roundRandomlyI", returnType=int.class, paramTypes={RandomGenerator.class, double.class})
        public MethodInfo rngRoundRandomlyID;
        @InfoHolder.Disambiguate(name="roundRandomlyL", returnType=long.class, paramTypes={RandomGenerator.class, float.class})
        public MethodInfo rngRoundRandomlyLF;
        @InfoHolder.Disambiguate(name="roundRandomlyL", returnType=long.class, paramTypes={RandomGenerator.class, double.class})
        public MethodInfo rngRoundRandomlyLD;

        public PermuterInfo() {
            super(Permuter.class);
        }

        public InsnTree newInstance(InsnTree seed) {
            return InsnTrees.newInstance(this.constructor, seed);
        }

        public InsnTree permute(InsnTree seed, InsnTree intSalt) {
            return InsnTrees.invokeStatic(this.permuteI, seed, intSalt);
        }

        public InsnTree nextUniformInt(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextUniformInt, seed);
        }

        public InsnTree toUniformInt(InsnTree seed) {
            return InsnTrees.invokeStatic(this.toUniformInt, seed);
        }

        public InsnTree nextPositiveInt(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextPositiveInt, seed);
        }

        public InsnTree toPositiveInt(InsnTree seed) {
            return InsnTrees.invokeStatic(this.toPositiveInt, seed);
        }

        public InsnTree nextUniformLong(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextUniformLong, seed);
        }

        public InsnTree nextPositiveLong(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextPositiveLong, seed);
        }

        public InsnTree nextUniformFloat(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextUniformFloat, seed);
        }

        public InsnTree toUniformFloat(InsnTree seed) {
            return InsnTrees.invokeStatic(this.toUniformFloat, seed);
        }

        public InsnTree nextPositiveFloat(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextPositiveFloat, seed);
        }

        public InsnTree toPositiveFloat(InsnTree seed) {
            return InsnTrees.invokeStatic(this.toPositiveFloat, seed);
        }

        public InsnTree nextUniformDouble(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextUniformDouble, seed);
        }

        public InsnTree toUniformDouble(InsnTree seed) {
            return InsnTrees.invokeStatic(this.toUniformDouble, seed);
        }

        public InsnTree nextPositiveDouble(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextPositiveDouble, seed);
        }

        public InsnTree toPositiveDouble(InsnTree seed) {
            return InsnTrees.invokeStatic(this.toPositiveDouble, seed);
        }

        public InsnTree nextBoolean(InsnTree seed) {
            return InsnTrees.invokeStatic(this.nextBoolean, seed);
        }

        public InsnTree toBoolean(InsnTree seed) {
            return InsnTrees.invokeStatic(this.toBoolean, seed);
        }

        public InsnTree nextChancedBooleanF(InsnTree seed, InsnTree chance) {
            return InsnTrees.invokeStatic(this.nextChancedBooleanF, seed, chance);
        }

        public InsnTree nextChancedBooleanD(InsnTree seed, InsnTree chance) {
            return InsnTrees.invokeStatic(this.nextChancedBooleanD, seed, chance);
        }

        public InsnTree toChancedBooleanF(InsnTree seed, InsnTree chance) {
            return InsnTrees.invokeStatic(this.toChancedBooleanF, seed, chance);
        }

        public InsnTree toChancedBooleanD(InsnTree seed, InsnTree chance) {
            return InsnTrees.invokeStatic(this.toChancedBooleanD, seed, chance);
        }

        public InsnTree roundRandomlyIF(InsnTree seed, InsnTree value) {
            return InsnTrees.invokeStatic(this.roundRandomlyIF, seed, value);
        }

        public InsnTree roundRandomlyID(InsnTree seed, InsnTree value) {
            return InsnTrees.invokeStatic(this.roundRandomlyID, seed, value);
        }

        public InsnTree roundRandomlyLF(InsnTree seed, InsnTree value) {
            return InsnTrees.invokeStatic(this.roundRandomlyLF, seed, value);
        }

        public InsnTree roundRandomlyLD(InsnTree seed, InsnTree value) {
            return InsnTrees.invokeStatic(this.roundRandomlyLD, seed, value);
        }
    }

    public static class RandomGeneratorInfo
    extends InfoHolder {
        public MethodInfo nextBoolean;
        @InfoHolder.Disambiguate(name="nextFloat", returnType=float.class, paramTypes={})
        public MethodInfo nextFloat;
        @InfoHolder.Disambiguate(name="nextFloat", returnType=float.class, paramTypes={float.class})
        public MethodInfo nextFloatBound;
        @InfoHolder.Disambiguate(name="nextFloat", returnType=float.class, paramTypes={float.class, float.class})
        public MethodInfo nextFloatOriginBound;
        @InfoHolder.Disambiguate(name="nextDouble", returnType=double.class, paramTypes={})
        public MethodInfo nextDouble;
        @InfoHolder.Disambiguate(name="nextDouble", returnType=double.class, paramTypes={double.class})
        public MethodInfo nextDoubleBound;
        @InfoHolder.Disambiguate(name="nextDouble", returnType=double.class, paramTypes={double.class, double.class})
        public MethodInfo nextDoubleOriginBound;
        @InfoHolder.Disambiguate(name="nextInt", returnType=int.class, paramTypes={})
        public MethodInfo nextInt;
        @InfoHolder.Disambiguate(name="nextInt", returnType=int.class, paramTypes={int.class})
        public MethodInfo nextIntBound;
        @InfoHolder.Disambiguate(name="nextInt", returnType=int.class, paramTypes={int.class, int.class})
        public MethodInfo nextIntOriginBound;
        @InfoHolder.Disambiguate(name="nextLong", returnType=long.class, paramTypes={})
        public MethodInfo nextLong;
        @InfoHolder.Disambiguate(name="nextLong", returnType=long.class, paramTypes={long.class})
        public MethodInfo nextLongBound;
        @InfoHolder.Disambiguate(name="nextLong", returnType=long.class, paramTypes={long.class, long.class})
        public MethodInfo nextLongOriginBound;
        @InfoHolder.Disambiguate(name="nextGaussian", returnType=double.class, paramTypes={})
        public MethodInfo nextGaussian;
        @InfoHolder.Disambiguate(name="nextGaussian", returnType=double.class, paramTypes={double.class, double.class})
        public MethodInfo nextGaussianMeanDev;
        public MethodInfo nextExponential;

        public RandomGeneratorInfo() {
            super(RandomGenerator.class);
        }
    }
}

