/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.wrappers.tags;

import builderb0y.bigglobe.scripting.ScriptLogger;
import builderb0y.scripting.bytecode.AbstractConstantFactory;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.special.CommaSeparatedExpressions;
import builderb0y.scripting.util.TypeInfos;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class TagParser
implements Consumer<MutableScriptEnvironment> {
    public final String tagTypeName;
    public final String elementTypeName;
    public final TypeInfo tagType;
    public final TypeInfo elementType;
    public final MethodInfo bootstrapConstant;
    public final MethodInfo nonConstant;
    public final MethodInfo isIn;

    public TagParser(String tagTypeName, Class<?> tagClass, String elementTypeName, MethodInfo isIn) {
        this.tagTypeName = tagTypeName;
        this.elementTypeName = elementTypeName;
        this.tagType = isIn.getInvokeTypes()[1];
        this.elementType = isIn.getInvokeTypes()[0];
        this.bootstrapConstant = MethodInfo.findMethod(tagClass, "of", tagClass, MethodHandles.Lookup.class, String.class, Class.class, Integer.TYPE, String[].class);
        this.nonConstant = MethodInfo.findMethod(tagClass, "of", tagClass, Integer.TYPE, String[].class);
        this.isIn = isIn;
    }

    @Override
    public void accept(MutableScriptEnvironment environment) {
        environment.addCast(InsnTrees.type(String.class), this.tagType, true, this.makeCaster()).addKeyword(this.tagTypeName, this.makeKeyword()).addMethod(this.elementType, "isIn", this.makeIsIn());
    }

    public MutableScriptEnvironment.CastHandler.Named makeCaster() {
        return new MutableScriptEnvironment.CastHandler.Named("String -> " + this.tagTypeName, (parser, value, to, implicit, nullable) -> {
            if (value.getConstantValue().isConstant()) {
                return InsnTrees.ldc(this.bootstrapConstant, InsnTrees.constant(AbstractConstantFactory.flags(parser, nullable)), value.getConstantValue());
            }
            if (implicit) {
                ScriptLogger.LOGGER.warn(ScriptParsingException.appendContext("Non-constant tag; this will be worse on performance. Use an explicit cast to suppress this warning.", parser.input));
            }
            return InsnTrees.invokeStatic(this.nonConstant, InsnTrees.ldc(AbstractConstantFactory.flags(parser, nullable)), InsnTrees.newArrayWithContents(parser, InsnTrees.type(String[].class), value));
        });
    }

    public MutableScriptEnvironment.KeywordHandler.Named makeKeyword() {
        return new MutableScriptEnvironment.KeywordHandler.Named(this.tagTypeName + "(element1 [, element2, ...])", (parser, name) -> {
            boolean nullable = parser.input.hasOperatorAfterWhitespace("?");
            if (parser.input.peekAfterWhitespace() != '(') {
                if (nullable) {
                    throw new ScriptParsingException("'" + name + "?' must be followed by parentheses for nullable cast. If a nullable cast was not intended, remove the question mark.", parser.input);
                }
                return null;
            }
            CommaSeparatedExpressions expressions = CommaSeparatedExpressions.parse(parser);
            return switch (expressions.arguments().length) {
                case 0 -> throw new ScriptParsingException("At least one element is required", parser.input);
                case 1 -> expressions.maybeWrap(expressions.arguments()[0].cast(parser, this.tagType, InsnTree.CastMode.EXPLICIT_THROW, nullable));
                default -> {
                    InsnTree[] strings = (InsnTree[])Arrays.stream(expressions.arguments()).map(tree -> tree.cast(parser, TypeInfos.STRING, InsnTree.CastMode.IMPLICIT_THROW, false)).toArray(InsnTree[]::new);
                    if (Arrays.stream(strings).map(InsnTree::getConstantValue).allMatch(ConstantValue::isConstantOrDynamic)) {
                        yield InsnTrees.ldc(this.bootstrapConstant, (ConstantValue[])Stream.concat(Stream.of(InsnTrees.constant(AbstractConstantFactory.flags(parser, nullable))), Arrays.stream(strings).map(InsnTree::getConstantValue)).toArray(ConstantValue[]::new));
                    }
                    yield InsnTrees.invokeStatic(this.nonConstant, InsnTrees.ldc(AbstractConstantFactory.flags(parser, nullable)), InsnTrees.newArrayWithContents(parser, InsnTrees.type(String[].class), strings));
                }
            };
        });
    }

    public MutableScriptEnvironment.MethodHandler.Named makeIsIn() {
        return new MutableScriptEnvironment.MethodHandler.Named(this.elementTypeName + ".isIn(element1 [, element2, ...])", (parser, receiver, name, mode, arguments) -> {
            boolean needsCasting;
            InsnTree tagArgument;
            switch (arguments.length) {
                case 0: {
                    throw new ScriptParsingException("At least one argument is required", parser.input);
                }
                case 1: {
                    tagArgument = arguments[0].cast(parser, this.tagType, InsnTree.CastMode.EXPLICIT_THROW, false);
                    needsCasting = tagArgument != arguments[0];
                    break;
                }
                default: {
                    InsnTree[] strings = ScriptEnvironment.castArgumentsSameType(parser, "isIn", TypeInfos.STRING, InsnTree.CastMode.IMPLICIT_THROW, arguments);
                    if (strings == null) {
                        return null;
                    }
                    tagArgument = Arrays.stream(strings).map(InsnTree::getConstantValue).allMatch(ConstantValue::isConstantOrDynamic) ? InsnTrees.ldc(this.bootstrapConstant, (ConstantValue[])Stream.concat(Stream.of(InsnTrees.constant(AbstractConstantFactory.flags(parser, false))), Arrays.stream(strings).map(InsnTree::getConstantValue)).toArray(ConstantValue[]::new)) : InsnTrees.invokeStatic(this.nonConstant, InsnTrees.ldc(AbstractConstantFactory.flags(parser, false)), InsnTrees.newArrayWithContents(parser, InsnTrees.type(String[].class), strings));
                    needsCasting = strings != arguments;
                }
            }
            return new MutableScriptEnvironment.CastResult(this.isIn.isStatic() ? InsnTrees.invokeStatic(this.isIn, receiver, tagArgument) : InsnTrees.invokeInstance(receiver, this.isIn, tagArgument), needsCasting);
        });
    }
}

