/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.wrappers.tags;

import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.util.InfoHolder;
import java.util.Iterator;
import java.util.random.RandomGenerator;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public abstract class TagWrapper<T_Raw, T_Entry>
implements Iterable<T_Entry> {
    public static final TypeInfo TYPE = TypeInfo.of(TagWrapper.class);
    public static final Info INFO = new Info();
    public final DelayedEntryList<T_Raw> list;

    public TagWrapper(DelayedEntryList<T_Raw> list) {
        this.list = list;
    }

    public abstract T_Entry wrap(class_6880<T_Raw> var1);

    public abstract class_6880<T_Raw> unwrap(T_Entry var1);

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public T_Entry random(RandomGenerator random) {
        return this.wrap(this.list.randomEntry(random));
    }

    public T_Entry random(long seed) {
        return this.wrap(this.list.randomEntry(seed));
    }

    public boolean contains(T_Entry entry) {
        return this.list.contains(this.unwrap(entry));
    }

    @Override
    @NotNull
    public Iterator<T_Entry> iterator() {
        return this.list.entryStream().map(this::wrap).iterator();
    }

    public String toString() {
        return this.list.toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.list.equals(((TagWrapper)obj).list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public static class Info
    extends InfoHolder {
        public MethodInfo isEmpty;
        public MethodInfo size;
        public MethodInfo contains;
        @InfoHolder.Disambiguate(name="random", returnType=Object.class, paramTypes={RandomGenerator.class})
        public MethodInfo rngRandom;
        @InfoHolder.Disambiguate(name="random", returnType=Object.class, paramTypes={long.class})
        public MethodInfo seedRandom;
    }
}

