/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.settings;

import builderb0y.autocodec.annotations.VerifyIntRange;
import builderb0y.autocodec.annotations.VerifySorted;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.settings.Seed;
import builderb0y.bigglobe.util.Derivative2D;
import builderb0y.bigglobe.util.LinkedArrayList;
import java.util.Comparator;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import org.jetbrains.annotations.Nullable;

public class VoronoiDiagram2D {
    public static final int DIMENSIONS = 2;
    public static final int CACHE_SIZE = 4;
    public static final int ADJACENT_8_X = -948895744;
    public static final int ADJACENT_8_Z = -65732608;
    public static final long ADJACENT_20_X = -2238840021832344560L;
    public static final long ADJACENT_20_Z = -2630103281857648352L;
    public final Seed seed;
    public final @VerifyIntRange(min=0L, minInclusive=false) int distance;
    public final @VerifyIntRange(min=0L, minInclusive=false) @VerifySorted(lessThanOrEqual={"distance"}) int variation;
    public final transient Cell[] cellCache = new Cell[4];

    public VoronoiDiagram2D(Seed seed, int distance, int variation) {
        this.seed = seed;
        this.distance = distance;
        this.variation = variation;
    }

    public int getCenterX(int cellX, int cellZ) {
        return cellX * this.distance + Permuter.nextBoundedInt(Permuter.permute(this.seed.xor(-3803112824224285061L), cellX, cellZ), this.variation);
    }

    public int getCenterZ(int cellX, int cellZ) {
        return cellZ * this.distance + Permuter.nextBoundedInt(Permuter.permute(this.seed.xor(4527777661576455190L), cellX, cellZ), this.variation);
    }

    public SeedPoint getSeedPoint(int cellX, int cellZ) {
        int centerX = this.getCenterX(cellX, cellZ);
        int centerZ = this.getCenterZ(cellX, cellZ);
        return new SeedPoint(cellX, cellZ, centerX, centerZ, this.seed.value);
    }

    public AdjacentSeedPoint getAdjacentSeedPoint(SeedPoint center, int cellX, int cellZ) {
        int centerX = this.getCenterX(cellX, cellZ);
        int centerZ = this.getCenterZ(cellX, cellZ);
        return new AdjacentSeedPoint(cellX, cellZ, centerX, centerZ, this.seed.value, center.angleTo(centerX, centerZ));
    }

    public SeedPoint getNearestSeedPoint(int blockX, int blockZ, @Nullable SeedPoint guess) {
        long newCenterD;
        int centerCellX = Math.floorDiv(blockX, this.distance);
        int centerCellZ = Math.floorDiv(blockZ, this.distance);
        int closestCellX = centerCellX;
        int closestCellZ = centerCellZ;
        int closestCenterX = this.getCenterX(centerCellX, centerCellZ);
        int closestCenterZ = this.getCenterZ(centerCellX, centerCellZ);
        long closestCenterD = BigGlobeMath.squareL(closestCenterX - blockX, closestCenterZ - blockZ);
        if (guess != null && (newCenterD = guess.squareDistanceTo(blockX, blockZ)) < closestCenterD) {
            closestCellX = guess.cellX;
            closestCellZ = guess.cellZ;
            closestCenterX = guess.centerX;
            closestCenterZ = guess.centerZ;
            closestCenterD = newCenterD;
        }
        double radius = Math.sqrt(closestCenterD);
        int minCellX = Math.floorDiv(BigGlobeMath.floorI((double)blockX - radius), this.distance);
        int maxCellX = Math.floorDiv(BigGlobeMath.floorI((double)blockX + radius), this.distance);
        int minCellZ = Math.floorDiv(BigGlobeMath.floorI((double)blockZ - radius), this.distance);
        int maxCellZ = Math.floorDiv(BigGlobeMath.floorI((double)blockZ + radius), this.distance);
        for (int newCellX = minCellX; newCellX <= maxCellX; ++newCellX) {
            for (int newCellZ = minCellZ; newCellZ <= maxCellZ; ++newCellZ) {
                int newCenterZ;
                int newCenterX;
                long newCenterD2;
                if (newCellX == centerCellX && newCellZ == centerCellZ || guess != null && guess.cellEquals(newCellX, newCellZ) || (newCenterD2 = BigGlobeMath.squareL((newCenterX = this.getCenterX(newCellX, newCellZ)) - blockX, (newCenterZ = this.getCenterZ(newCellX, newCellZ)) - blockZ)) >= closestCenterD) continue;
                closestCellX = newCellX;
                closestCellZ = newCellZ;
                closestCenterX = newCenterX;
                closestCenterZ = newCenterZ;
                closestCenterD = newCenterD2;
            }
        }
        if (guess != null && guess.cellEquals(closestCellX, closestCellZ)) {
            return guess;
        }
        return new SeedPoint(closestCellX, closestCellZ, closestCenterX, closestCenterZ, this.seed.value);
    }

    public SeedPoint getNearestSeedPoint(int blockX, int blockZ) {
        return this.getNearestSeedPoint(blockX, blockZ, null);
    }

    public static boolean isInsideCircumCircle(SeedPoint center, SeedPoint left, SeedPoint test, SeedPoint right) {
        double a33;
        double a23;
        double a11 = center.centerX - test.centerX;
        double a21 = left.centerX - test.centerX;
        double a31 = right.centerX - test.centerX;
        double a12 = center.centerZ - test.centerZ;
        double a22 = left.centerZ - test.centerZ;
        double a32 = right.centerZ - test.centerZ;
        double a13 = BigGlobeMath.squareD(center.centerX - test.centerX, center.centerZ - test.centerZ);
        return a13 * (a21 * a32 - a22 * a31) + (a23 = BigGlobeMath.squareD(left.centerX - test.centerX, left.centerZ - test.centerZ)) * (a12 * a31 - a11 * a32) + (a33 = BigGlobeMath.squareD(right.centerX - test.centerX, right.centerZ - test.centerZ)) * (a11 * a22 - a12 * a21) > 0.0;
    }

    public Cell getCellUncached(SeedPoint center) {
        LinkedArrayList<AdjacentSeedPoint> adjacent = new LinkedArrayList<AdjacentSeedPoint>();
        if (this.variation <= this.distance >> 1) {
            for (index = 0; index < 8; ++index) {
                newX = center.cellX + (-948895744 << index + index >> 30);
                newZ = center.cellZ + (-65732608 << index + index >> 30);
                adjacent.addElementToEnd(this.getAdjacentSeedPoint(center, newX, newZ));
            }
        } else {
            for (index = 0; index < 20; ++index) {
                newX = center.cellX + (int)(-2238840021832344560L << index + index + index >> 61);
                newZ = center.cellZ + (int)(-2630103281857648352L << index + index + index >> 61);
                adjacent.addElementToEnd(this.getAdjacentSeedPoint(center, newX, newZ));
            }
        }
        adjacent.sortElements(Comparator.naturalOrder());
        int remaining = adjacent.size();
        LinkedArrayList.Node node = adjacent.getFirstNode();
        while (remaining > 0) {
            LinkedArrayList.Node prev = node.prev;
            LinkedArrayList.Node next = node.next;
            if (prev == null) {
                prev = adjacent.getLastNode();
            }
            if (next == null) {
                next = adjacent.getFirstNode();
            }
            if (VoronoiDiagram2D.isInsideCircumCircle(center, (SeedPoint)prev.element, (SeedPoint)node.element, (SeedPoint)next.element)) {
                node = next;
                --remaining;
                continue;
            }
            adjacent.removeNode(node);
            node = prev;
            remaining = Math.max(remaining, 2);
        }
        return new Cell(center, adjacent.toElementArray(new AdjacentSeedPoint[adjacent.size()]));
    }

    public Cell getCellCached(SeedPoint center) {
        Cell cell;
        Cell[] cache = this.cellCache;
        int i = 0;
        while ((cell = cache[i]) != null) {
            if (cell.center.cellEquals(center)) {
                if (i != 0) {
                    System.arraycopy(cache, 0, cache, 1, i);
                    cache[0] = cell;
                }
                return cell;
            }
            if (i >= 3) break;
            ++i;
        }
        cell = this.getCellUncached(center);
        if (i != 0) {
            System.arraycopy(cache, 0, cache, 1, i);
        }
        cache[0] = cell;
        return cell;
    }

    public Cell getCell(int cellX, int cellZ, @Nullable Cell guess) {
        return guess != null && guess.center.cellEquals(cellX, cellZ) ? guess : this.getCellCached(this.getSeedPoint(cellX, cellZ));
    }

    public Cell getCell(int cellX, int cellZ) {
        return this.getCellCached(this.getSeedPoint(cellX, cellZ));
    }

    public Cell getNearestCell(int blockX, int blockZ, @Nullable Cell guess) {
        SeedPoint guessPoint = guess != null ? guess.center : null;
        SeedPoint nearestPoint = this.getNearestSeedPoint(blockX, blockZ, guessPoint);
        return guessPoint == nearestPoint ? guess : this.getCellCached(nearestPoint);
    }

    public Cell getNearestCell(int blockX, int blockZ, @Nullable SeedPoint guess) {
        SeedPoint nearestPoint = this.getNearestSeedPoint(blockX, blockZ, guess);
        return this.getCellCached(nearestPoint);
    }

    public Cell getNearestCell(int blockX, int blockZ) {
        return this.getCellCached(this.getNearestSeedPoint(blockX, blockZ));
    }

    public static class Cell {
        public final SeedPoint center;
        public final AdjacentSeedPoint[] adjacent;

        public Cell(SeedPoint center, AdjacentSeedPoint[] adjacent) {
            this.center = center;
            this.adjacent = adjacent;
        }

        public boolean contains(int blockX, int blockZ) {
            for (AdjacentSeedPoint adjacent : this.adjacent) {
                float progress = this.center.progressToF(adjacent, blockX, blockZ);
                if (progress >= 0.0f && progress <= 1.0f) continue;
                return false;
            }
            return true;
        }

        public class_148 handleError(Throwable throwable, int blockX, int blockZ) {
            class_128 report = class_128.method_560((Throwable)throwable, (String)"Getting distance squared to edge of voronoi cell");
            class_129 category = report.method_562("Voronoi details:");
            category.method_578("Requested coordinates", (Object)(blockX + ", " + blockZ));
            category.method_578("Center cell", (Object)this.center);
            for (AdjacentSeedPoint adjacent : this.adjacent) {
                category.method_578("Adjacent cell", (Object)adjacent);
            }
            return new class_148(report);
        }

        public double progressToEdgeSquaredD(int blockX, int blockZ) {
            try {
                double distance = 1.0;
                for (AdjacentSeedPoint adjacent : this.adjacent) {
                    double progress = this.center.progressToD(adjacent, blockX, blockZ);
                    if (!(progress > 0.0)) continue;
                    if ((progress *= 2.0) > 1.0) {
                        throw new IllegalArgumentException("Position not inside cell");
                    }
                    distance *= 1.0 - progress * progress;
                }
                return 1.0 - distance;
            }
            catch (Throwable throwable) {
                throw this.handleError(throwable, blockX, blockZ);
            }
        }

        public double progressToEdgeD(int blockX, int blockZ) {
            return Math.sqrt(this.progressToEdgeSquaredD(blockX, blockZ));
        }

        public double hardProgressToEdgeD(int blockX, int blockZ) {
            try {
                double distance = 0.0;
                for (AdjacentSeedPoint adjacent : this.adjacent) {
                    double progress = this.center.progressToD(adjacent, blockX, blockZ);
                    if (progress > 0.5) {
                        throw new IllegalArgumentException("Position not inside cell");
                    }
                    distance = Math.max(distance, progress);
                }
                return distance * 2.0;
            }
            catch (Throwable throwable) {
                throw this.handleError(throwable, blockX, blockZ);
            }
        }

        public void derivativeProgressToEdgeSquaredD(Derivative2D holder, int blockX, int blockZ) {
            try {
                long blockOffsetX = blockX - this.center.centerX;
                long blockOffsetZ = blockZ - this.center.centerZ;
                holder.set(1.0);
                for (AdjacentSeedPoint adjacent : this.adjacent) {
                    long cellOffsetX = adjacent.centerX - this.center.centerX;
                    long cellOffsetZ = adjacent.centerZ - this.center.centerZ;
                    double dotProduct = blockOffsetX * cellOffsetX + blockOffsetZ * cellOffsetZ;
                    if (!(dotProduct > 0.0)) continue;
                    double factor = BigGlobeMath.squareL(cellOffsetX, cellOffsetZ);
                    double progress = dotProduct * 2.0 / factor;
                    if (progress > 1.0) {
                        throw new IllegalArgumentException("Position not inside cell");
                    }
                    double nextMultiplier = 1.0 - progress * progress;
                    double common = dotProduct * -8.0 / (factor * factor);
                    holder.mul(nextMultiplier, common * (double)cellOffsetX, common * (double)cellOffsetZ);
                }
                holder.subRev(1.0);
            }
            catch (Throwable throwable) {
                throw this.handleError(throwable, blockX, blockZ);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.adjacent.length + 1 << 6).append(this.getClass().getName()).append(":\n\tCenter: ").append(this.center);
            for (AdjacentSeedPoint adjacent : this.adjacent) {
                builder.append("\n\tAdjacent: ").append(adjacent);
            }
            return builder.toString();
        }
    }

    public static class SeedPoint {
        public final int cellX;
        public final int cellZ;
        public final int centerX;
        public final int centerZ;
        public final long seed;

        public SeedPoint(int cellX, int cellZ, int centerX, int centerZ, long seed) {
            this.cellX = cellX;
            this.cellZ = cellZ;
            this.centerX = centerX;
            this.centerZ = centerZ;
            this.seed = seed;
        }

        public long getSeed(long salt) {
            return Permuter.permute(this.seed ^ salt, this.cellX, this.cellZ);
        }

        public long squareDistanceTo(int blockX, int blockZ) {
            return BigGlobeMath.squareL(this.centerX - blockX, this.centerZ - blockZ);
        }

        public double distanceTo(int blockX, int blockZ) {
            return Math.sqrt(this.squareDistanceTo(blockX, blockZ));
        }

        public long squareDistanceTo(SeedPoint other) {
            return this.squareDistanceTo(other.centerX, other.centerZ);
        }

        public double distanceTo(SeedPoint other) {
            return this.distanceTo(other.centerX, other.centerZ);
        }

        public double angleTo(int blockX, int blockZ) {
            return Math.atan2(blockZ - this.centerZ, blockX - this.centerX);
        }

        public double angleTo(SeedPoint other) {
            return this.angleTo(other.centerX, other.centerZ);
        }

        public double progressToD(SeedPoint end, int blockX, int blockZ) {
            long blockOffsetX = blockX - this.centerX;
            long blockOffsetZ = blockZ - this.centerZ;
            long cellOffsetX = end.centerX - this.centerX;
            long cellOffsetZ = end.centerZ - this.centerZ;
            double dotProduct = blockOffsetX * cellOffsetX + blockOffsetZ * cellOffsetZ;
            double factor = BigGlobeMath.squareL(cellOffsetX, cellOffsetZ);
            return dotProduct / factor;
        }

        public float progressToF(SeedPoint end, int blockX, int blockZ) {
            long blockOffsetX = blockX - this.centerX;
            long blockOffsetZ = blockZ - this.centerZ;
            long cellOffsetX = end.centerX - this.centerX;
            long cellOffsetZ = end.centerZ - this.centerZ;
            float dotProduct = blockOffsetX * cellOffsetX + blockOffsetZ * cellOffsetZ;
            float factor = BigGlobeMath.squareL(cellOffsetX, cellOffsetZ);
            return dotProduct / factor;
        }

        public String toString() {
            return this.getClass().getName() + ": { cell: " + this.cellX + ", " + this.cellZ + ", center: " + this.centerX + ", " + this.centerZ + ", seed: " + Long.toHexString(this.seed) + " }";
        }

        public boolean cellEquals(int cellX, int cellZ) {
            return this.cellX == cellX && this.cellZ == cellZ;
        }

        public boolean cellEquals(SeedPoint that) {
            return this.cellEquals(that.cellX, that.cellZ);
        }

        public boolean centerEquals(int centerX, int centerZ) {
            return this.centerX == centerX && this.centerZ == centerZ;
        }

        public boolean centerEquals(SeedPoint that) {
            return this.centerEquals(that.centerX, that.centerZ);
        }
    }

    public static class AdjacentSeedPoint
    extends SeedPoint
    implements Comparable<AdjacentSeedPoint> {
        public final double angleFromCenter;

        public AdjacentSeedPoint(int cellX, int cellZ, int centerX, int centerZ, long seed, double angleFromCenter) {
            super(cellX, cellZ, centerX, centerZ, seed);
            this.angleFromCenter = angleFromCenter;
        }

        @Override
        public int compareTo(AdjacentSeedPoint that) {
            return Double.compare(this.angleFromCenter, that.angleFromCenter);
        }

        @Override
        public String toString() {
            return this.getClass().getName() + ": { cell: " + this.cellX + ", " + this.cellZ + ", center: " + this.centerX + ", " + this.centerZ + ", seed: " + Long.toHexString(this.seed) + ", angle from center: " + this.angleFromCenter + " }";
        }
    }
}

