/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures;

import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.noise.MojangPermuter;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.RandomList;
import builderb0y.bigglobe.randomSources.RandomRangeVerifier;
import builderb0y.bigglobe.randomSources.RandomSource;
import builderb0y.bigglobe.structures.BigGlobeStructure;
import builderb0y.bigglobe.structures.BigGlobeStructures;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.util.WorldUtil;
import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import builderb0y.bigglobe.versions.BlockEntityVersions;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.DirectionVersions;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import builderb0y.bigglobe.versions.ItemStackVersions;
import builderb0y.bigglobe.versions.WallBlockVersions;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2423;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2510;
import net.minecraft.class_2512;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2544;
import net.minecraft.class_2546;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2738;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2794;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3708;
import net.minecraft.class_3730;
import net.minecraft.class_3773;
import net.minecraft.class_39;
import net.minecraft.class_4778;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_7151;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public class PortalTempleStructure
extends BigGlobeStructure {
    public static final MapCodec<PortalTempleStructure> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(PortalTempleStructure.class);
    public final @RandomRangeVerifier.VerifyRandomRange(min=0.0, max=1.0) RandomSource cracked_chance;

    public PortalTempleStructure(class_3195.class_7302 config, @VerifyNullable ColumnScript.ColumnToIntScript.Holder min_y, @VerifyNullable ColumnScript.ColumnToIntScript.Holder surface_y, RandomSource cracked_chance) {
        super(config, min_y, surface_y);
        this.cracked_chance = cracked_chance;
    }

    @Override
    public int bigglobe_getMaxRadiusInChunks() {
        return 4;
    }

    @Override
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (this.cracked_chance.requiresColumn() && !(context.comp_562() instanceof BigGlobeScriptedChunkGenerator)) {
            return Optional.empty();
        }
        Permuter permuter = Permuter.from((class_5819)context.comp_566());
        int x = context.comp_568().method_8326() | permuter.nextInt() & 0xF;
        int z = context.comp_568().method_8328() | permuter.nextInt() & 0xF;
        class_4966 sample = context.comp_562().method_26261(x, z, context.comp_569(), context.comp_564());
        int minY = HeightLimitViewVersions.getMinY(context.comp_569());
        int maxY = HeightLimitViewVersions.getMaxY(context.comp_569());
        for (int startAttempt = 0; startAttempt < 16; ++startAttempt) {
            int y = permuter.nextInt(minY, maxY);
            if (!sample.method_32892(y).method_26215()) continue;
            while (--y >= minY && sample.method_32892(y).method_26215()) {
            }
            if (!BlockStateVersions.isOpaqueFullCube(sample.method_32892(y), (class_1922)class_2682.field_12294, class_2338.field_10980)) continue;
            int y_ = y;
            ScriptedColumn column = this.cracked_chance.requiresColumn() ? ((BigGlobeScriptedChunkGenerator)context.comp_562()).newColumn(context.comp_569(), x, z, ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints()) : null;
            double crackedChance = this.cracked_chance.get(column, y_, permuter);
            return Optional.of(new class_3195.class_7150(new class_2338(x, y, z), collector -> {
                ArrayList<class_3443> pieces = new ArrayList<class_3443>(8);
                pieces.add(new MainBuildingPiece(BigGlobeStructures.PORTAL_TEMPLE_MAIN_BUILDING, x, y_, z, crackedChance, permuter));
                pieces.add(new PortalPiece(BigGlobeStructures.PORTAL_TEMPLE_PORTAL, x, y_ + 10, z, permuter));
                int failure = 0;
                while (failure < 4) {
                    DecorationPiece decorationPiece;
                    if (PortalTempleStructure.addDecoration(pieces, decorationPiece = (switch (permuter.nextInt() & 3) {
                        case 0 -> new WellPiece(BigGlobeStructures.PORTAL_TEMPLE_WELL, x, y_, z, permuter);
                        case 1 -> new FarmPiece(BigGlobeStructures.PORTAL_TEMPLE_FARM, x, y_, z, permuter);
                        case 2 -> new TablePiece(BigGlobeStructures.PORTAL_TEMPLE_TABLE, x, y_, z, permuter);
                        case 3 -> new FurnacePiece(BigGlobeStructures.PORTAL_TEMPLE_FURNACE, x, y_, z, permuter);
                        default -> throw new AssertionError();
                    }))) continue;
                    ++failure;
                }
                PortalTempleStructure.addDecoration(pieces, new SpawnerPiece(BigGlobeStructures.PORTAL_TEMPLE_SPAWNER, x, y_, z, permuter));
                for (class_3443 class_34432 : pieces) {
                    collector.method_35462(class_34432);
                }
            }));
        }
        return Optional.empty();
    }

    public static boolean addDecoration(List<class_3443> pieces, DecorationPiece piece) {
        class_3341 box = piece.method_14935().method_35410(1);
        int size = pieces.size();
        for (int index = 2; index < size; ++index) {
            if (!box.method_14657(pieces.get(index).method_14935())) continue;
            return false;
        }
        pieces.add(piece);
        return true;
    }

    public class_7151<?> method_41618() {
        return BigGlobeStructures.PORTAL_TEMPLE;
    }

    public static CoordinateFunctions.CoordinateSupplier<class_2680> netherBricks(double crackedChance) {
        return pos -> Permuter.toChancedBoolean(Permuter.permute(-6971889105138243877L, (class_2382)pos), crackedChance) ? BlockStates.CRACKED_NETHER_BRICKS : BlockStates.NETHER_BRICKS;
    }

    public static CoordinateFunctions.CoordinateSupplier<class_2680> randomState(class_2248 block) {
        ImmutableList states = block.method_9595().method_11662();
        return pos -> (class_2680)states.get(Permuter.nextBoundedInt(Permuter.permute(1320862917961265084L, (class_2382)pos), states.size()));
    }

    public static CoordinateFunctions.CoordinateSupplier<class_2680> netherWart() {
        return PortalTempleStructure.randomState(class_2246.field_9974);
    }

    public static CoordinateFunctions.CoordinateSupplier<class_2680> maybeCryingObsidian(int chance) {
        return pos -> Permuter.nextBoundedInt(Permuter.permute(-5988501239794986528L, (class_2382)pos), chance) == 0 ? BlockStates.CRYING_OBSIDIAN : BlockStates.OBSIDIAN;
    }

    public static class_2680 STAIRS(class_2248 block, char type) {
        class_2680 state = block.method_9564();
        switch (type) {
            case 'N': {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
            }
            case 'n': {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11043);
                break;
            }
            case 'S': {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
            }
            case 's': {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11035);
                break;
            }
            case 'E': {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
            }
            case 'e': {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11034);
                break;
            }
            case 'W': {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
            }
            case 'w': {
                state = (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11039);
                break;
            }
            default: {
                throw new IllegalArgumentException("not nsew: " + type);
            }
        }
        return state;
    }

    public static class_2680 NETHER_BRICK_STAIRS(char type) {
        return PortalTempleStructure.STAIRS(class_2246.field_10159, type);
    }

    public static class_2680 RED_NETHER_BRICK_STAIRS(char type) {
        return PortalTempleStructure.STAIRS(class_2246.field_10497, type);
    }

    public static class_2680 POLISHED_BLACKSTONE_STAIRS(char type) {
        return PortalTempleStructure.STAIRS(class_2246.field_23861, type);
    }

    public static class_2680 FENCE(class_2248 block, String connections) {
        class_2680 state = block.method_9564();
        int length = connections.length();
        for (int index = 0; index < length; ++index) {
            state = switch (connections.charAt(index)) {
                case 'n' -> (class_2680)state.method_11657((class_2769)class_2310.field_10905, (Comparable)Boolean.TRUE);
                case 'e' -> (class_2680)state.method_11657((class_2769)class_2310.field_10907, (Comparable)Boolean.TRUE);
                case 's' -> (class_2680)state.method_11657((class_2769)class_2310.field_10904, (Comparable)Boolean.TRUE);
                case 'w' -> (class_2680)state.method_11657((class_2769)class_2310.field_10903, (Comparable)Boolean.TRUE);
                default -> throw new IllegalArgumentException(String.valueOf(connections.charAt(index)));
            };
        }
        return state;
    }

    public static class_2680 NETHER_BRICK_FENCE(String connections) {
        return PortalTempleStructure.FENCE(class_2246.field_10364, connections);
    }

    public static class_2680 WALL(class_2248 block, String connections) {
        class_2680 state = block.method_9564();
        int length = connections.length();
        for (int index = 0; index < length; ++index) {
            state = switch (connections.charAt(index)) {
                case 'n' -> (class_2680)state.method_11657(WallBlockVersions.NORTH_SHAPE, (Comparable)class_4778.field_22179);
                case 'e' -> (class_2680)state.method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22179);
                case 's' -> (class_2680)state.method_11657(WallBlockVersions.SOUTH_SHAPE, (Comparable)class_4778.field_22179);
                case 'w' -> (class_2680)state.method_11657(WallBlockVersions.WEST_SHAPE, (Comparable)class_4778.field_22179);
                case 'N' -> (class_2680)state.method_11657(WallBlockVersions.NORTH_SHAPE, (Comparable)class_4778.field_22180);
                case 'E' -> (class_2680)state.method_11657(WallBlockVersions.EAST_SHAPE, (Comparable)class_4778.field_22180);
                case 'S' -> (class_2680)state.method_11657(WallBlockVersions.SOUTH_SHAPE, (Comparable)class_4778.field_22180);
                case 'W' -> (class_2680)state.method_11657(WallBlockVersions.WEST_SHAPE, (Comparable)class_4778.field_22180);
                case 'U', 'u' -> (class_2680)state.method_11657((class_2769)class_2544.field_11717, (Comparable)Boolean.TRUE);
                default -> throw new IllegalArgumentException(String.valueOf(connections.charAt(index)));
            };
        }
        return state;
    }

    public static class_2680 NETHER_BRICK_WALL(String connections) {
        return PortalTempleStructure.WALL(class_2246.field_10127, connections);
    }

    public static class_2499 makeEntityPos(double x, double y, double z) {
        class_2499 pos = new class_2499();
        pos.add((Object)class_2489.method_23241((double)x));
        pos.add((Object)class_2489.method_23241((double)y));
        pos.add((Object)class_2489.method_23241((double)z));
        return pos;
    }

    public static <T> List<T> readListFromNBT(class_2499 listNBT, Function<? super class_2487, ? extends T> reader) {
        int size = listNBT.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(size);
        for (class_2520 element : listNBT) {
            if (element instanceof class_2487) {
                class_2487 compound = (class_2487)element;
                T toAdd = reader.apply((class_2487)compound);
                if (toAdd == null) continue;
                list.add(toAdd);
                continue;
            }
            BigGlobeMod.LOGGER.warn("Portal temple failed to decode non-compound " + String.valueOf(element) + " from list " + String.valueOf(listNBT));
        }
        return list;
    }

    public static <T> List<T> readListFromNBTCompound(class_2487 compound, String key, Function<? super class_2487, ? extends T> reader) {
        class_2499 list;
        class_2520 nbt = compound.method_10580(key);
        if (nbt instanceof class_2499 && !(list = (class_2499)nbt).isEmpty()) {
            return PortalTempleStructure.readListFromNBT(list, reader);
        }
        return Collections.emptyList();
    }

    public static <T> class_2499 writeListToNBT(List<T> list, Function<? super T, ? extends class_2487> writer) {
        class_2499 listNBT = new class_2499();
        int size = list.size();
        for (int index = 0; index < size; ++index) {
            listNBT.add((Object)((class_2520)writer.apply(list.get(index))));
        }
        return listNBT;
    }

    public static <T> void writeListToNBTAndStoreInCompound(class_2487 compound, String key, List<T> list, Function<? super T, ? extends class_2487> writer) {
        if (!list.isEmpty()) {
            compound.method_10566(key, (class_2520)PortalTempleStructure.writeListToNBT(list, writer));
        }
    }

    public static <T> void doForSomeElements(RandomGenerator random, T[] elements, int desiredElements, Consumer<T> action) {
        if (desiredElements > elements.length) {
            throw new IllegalArgumentException("desiredElements (" + desiredElements + ") > elements.length (" + elements.length + ")");
        }
        if (desiredElements <= 0) {
            return;
        }
        if (desiredElements == 1) {
            action.accept(elements[random.nextInt(elements.length)]);
            return;
        }
        elements = (Object[])elements.clone();
        int length = elements.length;
        for (int attempt = 0; attempt < desiredElements; ++attempt) {
            int index = random.nextInt(length);
            T element = elements[index];
            elements[index] = elements[--length];
            action.accept(element);
        }
    }

    public static abstract class DecorationPiece
    extends Piece {
        public DecorationPiece(class_3773 type, int x, int y, int z, RandomGenerator random, int variantCount) {
            super(type, x, y, z, null, random, variantCount);
            this.initBoundingBox(x, y, z, random);
        }

        public DecorationPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
            this.centerPos = new class_2338(this.field_15315.method_35415() + this.field_15315.method_35418() + 1 >> 1, this.isCeiling() ? this.field_15315.method_35419() : this.field_15315.method_35416(), this.field_15315.method_35417() + this.field_15315.method_35420() + 1 >> 1);
        }

        public void initBoundingBox(int x, int y, int z, RandomGenerator random) {
            int maxY;
            int minY;
            int radius = this.getRadius();
            if (this.isCeiling()) {
                x += DecorationPiece.nextUniformIntInclusive(random, 4 - radius);
                z += DecorationPiece.nextUniformIntInclusive(random, 4 - radius);
                minY = (y += 8) - this.getHeight() + 1;
                maxY = y;
            } else {
                int magnitude = DecorationPiece.nextUniformIntInclusive(random, 7 - radius);
                int side = DecorationPiece.nextUniformIntInclusive(random, 2 - radius);
                if (random.nextBoolean()) {
                    x += magnitude;
                    z += side;
                } else {
                    z += magnitude;
                    x += side;
                }
                minY = ++y;
                maxY = y + this.getHeight() - 1;
            }
            int minX = x - radius;
            int minZ = z - radius;
            int maxX = x + radius;
            int maxZ = z + radius;
            this.field_15315 = new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
            this.centerPos = new class_2338(x, y, z);
        }

        public static int nextUniformIntInclusive(RandomGenerator random, int range) {
            return random.nextInt(range << 1 | 1) - range;
        }

        public abstract int getRadius();

        public abstract int getHeight();

        public boolean isCeiling() {
            return false;
        }
    }

    public static class MainBuildingPiece
    extends Piece {
        public static final PositionDirections[] CHEST_POSITIONS = new PositionDirections[]{new PositionDirections(-2, 1, -10, class_2350.field_11035), new PositionDirections(-5, 1, -10, class_2350.field_11035, class_2350.field_11034), new PositionDirections(-5, 1, -6, class_2350.field_11034), new PositionDirections(-6, 1, -5, class_2350.field_11035), new PositionDirections(-10, 1, -5, class_2350.field_11035, class_2350.field_11034), new PositionDirections(-10, 1, -2, class_2350.field_11034), new PositionDirections(-2, 1, 10, class_2350.field_11043), new PositionDirections(-5, 1, 10, class_2350.field_11043, class_2350.field_11034), new PositionDirections(-5, 1, 6, class_2350.field_11034), new PositionDirections(-6, 1, 5, class_2350.field_11043), new PositionDirections(-10, 1, 5, class_2350.field_11043, class_2350.field_11034), new PositionDirections(-10, 1, 2, class_2350.field_11034), new PositionDirections(2, 1, -10, class_2350.field_11035), new PositionDirections(5, 1, -10, class_2350.field_11035, class_2350.field_11039), new PositionDirections(5, 1, -6, class_2350.field_11039), new PositionDirections(6, 1, -5, class_2350.field_11035), new PositionDirections(10, 1, -5, class_2350.field_11035, class_2350.field_11039), new PositionDirections(10, 1, -2, class_2350.field_11039), new PositionDirections(2, 1, 10, class_2350.field_11043), new PositionDirections(5, 1, 10, class_2350.field_11043, class_2350.field_11039), new PositionDirections(5, 1, 6, class_2350.field_11039), new PositionDirections(6, 1, 5, class_2350.field_11043), new PositionDirections(10, 1, 5, class_2350.field_11043, class_2350.field_11039), new PositionDirections(10, 1, 2, class_2350.field_11039)};
        public static final PositionDirections[] ARCH_POSITIONS = new PositionDirections[]{new PositionDirections(-6, 1, -8, class_2350.field_11034), new PositionDirections(-8, 1, -6, class_2350.field_11035), new PositionDirections(-6, 1, 8, class_2350.field_11034), new PositionDirections(-8, 1, 6, class_2350.field_11043), new PositionDirections(6, 1, -8, class_2350.field_11039), new PositionDirections(8, 1, -6, class_2350.field_11035), new PositionDirections(6, 1, 8, class_2350.field_11039), new PositionDirections(8, 1, 6, class_2350.field_11043)};
        public static final class_2382[] SPAWN_POSITIONS = new class_2382[]{new class_2382(0, 1, -13), new class_2382(0, 1, -8), new class_2382(-4, 1, -8), new class_2382(-4, 1, -4), new class_2382(-8, 1, -4), new class_2382(-8, 1, 0), new class_2382(-13, 1, 0), new class_2382(0, 6, -13), new class_2382(0, 10, -5), new class_2382(-5, 10, -5), new class_2382(-5, 10, 0), new class_2382(-13, 6, 0), new class_2382(0, 1, 13), new class_2382(0, 1, 8), new class_2382(-4, 1, 8), new class_2382(-4, 1, 4), new class_2382(-8, 1, 4), new class_2382(0, 6, 13), new class_2382(0, 10, 5), new class_2382(-5, 10, 5), new class_2382(4, 1, -8), new class_2382(4, 1, -4), new class_2382(8, 1, -4), new class_2382(8, 1, 0), new class_2382(13, 1, 0), new class_2382(5, 10, -5), new class_2382(5, 10, 0), new class_2382(13, 6, 0), new class_2382(4, 1, 8), new class_2382(4, 1, 4), new class_2382(8, 1, 4), new class_2382(5, 10, 5)};
        public static final RandomList<String> CHEST_LOOT_TABLES = new RandomList<String>(2).addSelf(class_39.field_615.method_29177().toString().intern(), 100.0).addSelf(class_39.field_24050.method_29177().toString().intern(), 50.0);
        public final double crackedChance;
        public final List<PositionState> decorations;
        public final List<class_2487> entities;

        public MainBuildingPiece(class_3773 type, int x, int y, int z, double crackedChance, final RandomGenerator random) {
            super(type, x, y, z, new class_3341(x - 16, y, z - 16, x + 16, y + 12, z + 16), random, 2);
            this.crackedChance = crackedChance;
            int chestCount = Integer.bitCount(random.nextInt(16));
            int bannerCount = Integer.bitCount(random.nextInt(64));
            final int armorStandCount = Integer.bitCount(random.nextInt(4));
            int entityCount = Integer.bitCount(random.nextInt());
            this.decorations = new ArrayList<PositionState>(chestCount + bannerCount);
            this.entities = new ArrayList<class_2487>(armorStandCount + entityCount);
            PortalTempleStructure.doForSomeElements(random, CHEST_POSITIONS, chestCount, chestPos -> {
                class_2487 chestNBT = new class_2487();
                chestNBT.method_10582("LootTable", (String)CHEST_LOOT_TABLES.getRandomElement(random));
                chestNBT.method_10544("LootTableSeed", random.nextLong());
                this.decorations.add(new PositionState((class_2382)chestPos, random.nextBoolean() ? (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)chestPos.getRandomDirection(random)) : (class_2680)class_2246.field_16328.method_9564().method_11657((class_2769)class_3708.field_16320, (Comparable)chestPos.getRandomDirection(random)), chestNBT));
            });
            PortalTempleStructure.doForSomeElements(random, ARCH_POSITIONS, bannerCount + armorStandCount, new Consumer<PositionDirections>(){
                public int index;
                final /* synthetic */ MainBuildingPiece this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void accept(PositionDirections archPosition) {
                    if (this.index++ < armorStandCount) {
                        class_2487 entityNBT = new class_2487();
                        entityNBT.method_10582("id", "armor_stand");
                        entityNBT.method_10566("Pos", (class_2520)PortalTempleStructure.makeEntityPos((double)archPosition.method_10263() + 0.5, archPosition.method_10264(), (double)archPosition.method_10260() + 0.5));
                        class_2499 rotation = new class_2499();
                        rotation.add((Object)class_2494.method_23244((float)DirectionVersions.horizontalAngle(archPosition.getRandomDirection(random))));
                        rotation.add((Object)class_2494.field_21034);
                        entityNBT.method_10566("Rotation", (class_2520)rotation);
                        class_2499 armorItemsNBT = new class_2499();
                        int numberOfArmorItems = random.nextInt(5);
                        for (int armorIndex = 0; armorIndex < 4; ++armorIndex) {
                            class_2487 itemNBT = new class_2487();
                            if (armorIndex >= numberOfArmorItems) {
                                class_1799 stack = new class_1799((class_1935)(switch (armorIndex) {
                                    case 0 -> class_1802.field_8753;
                                    case 1 -> class_1802.field_8416;
                                    case 2 -> class_1802.field_8678;
                                    case 3 -> class_1802.field_8862;
                                    default -> throw new AssertionError(armorIndex);
                                }), 1);
                                stack.method_7974(random.nextInt(stack.method_7936()));
                                ItemStackVersions.toNbt(stack, itemNBT);
                            }
                            armorItemsNBT.add((Object)itemNBT);
                        }
                        entityNBT.method_10566("ArmorItems", (class_2520)armorItemsNBT);
                        this.this$0.entities.add(entityNBT);
                    } else {
                        boolean invertColors = random.nextBoolean();
                        class_2487 bannerNBT = new class_2487();
                        class_2499 patterns = new class_2499();
                        patterns.add((Object)this.pattern("minecraft:curly_border", true, invertColors));
                        patterns.add((Object)this.pattern("minecraft:triangle_bottom", true, invertColors));
                        patterns.add((Object)this.pattern("minecraft:triangle_top", true, invertColors));
                        patterns.add((Object)this.pattern("minecraft:triangles_bottom", false, invertColors));
                        patterns.add((Object)this.pattern("minecraft:triangles_top", false, invertColors));
                        patterns.add((Object)this.pattern("minecraft:rhombus", false, invertColors));
                        patterns.add((Object)this.pattern("minecraft:circle", true, invertColors));
                        patterns.add((Object)this.pattern("minecraft:border", 15));
                        bannerNBT.method_10566("patterns", (class_2520)patterns);
                        this.this$0.decorations.add(new PositionState((class_2382)archPosition.method_10086(2), (class_2680)(invertColors ? class_2246.field_10274 : class_2246.field_10054).method_9564().method_11657((class_2769)class_2546.field_11722, (Comparable)archPosition.getRandomDirection(random)), bannerNBT));
                    }
                }

                public class_2487 pattern(String patternName, boolean magenta, boolean invert) {
                    return this.pattern(patternName, magenta == invert ? 10 : 2);
                }

                public class_2487 pattern(String patternName, int color) {
                    class_2487 nbt = new class_2487();
                    nbt.method_10582("pattern", patternName);
                    nbt.method_10582("color", class_1767.method_7791((int)color).method_15434());
                    return nbt;
                }
            });
        }

        public MainBuildingPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
            double d;
            this.centerPos = new class_2338(this.field_15315.method_35415() + this.field_15315.method_35418() + 1 >> 1, this.field_15315.method_35416(), this.field_15315.method_35417() + this.field_15315.method_35420() + 1 >> 1);
            class_2520 class_25202 = nbt.method_10580("cracked_chance");
            if (class_25202 instanceof class_2514) {
                class_2514 number = (class_2514)class_25202;
                d = number.method_10697();
            } else {
                d = 0.0;
            }
            this.crackedChance = d;
            this.decorations = PortalTempleStructure.readListFromNBTCompound(nbt, "decorations", PositionState::decode);
            this.entities = PortalTempleStructure.readListFromNBTCompound(nbt, "entities", Function.identity());
        }

        @Override
        public void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_10549("cracked_chance", this.crackedChance);
            PortalTempleStructure.writeListToNBTAndStoreInCompound(nbt, "decorations", this.decorations, PositionState::writeToNBT);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            Coordinator rotate4 = root.rotate4x90();
            Coordinator rotate8 = root.flip2X().rotate4x90();
            Coordinator floorFlip = root.flip2Z();
            CoordinateFunctions.CoordinateSupplier<class_2680> netherBricks = PortalTempleStructure.netherBricks(this.crackedChance);
            root.setBlockStateCuboid(-10, 1, -10, 10, 1, 10, BlockStates.AIR);
            root.setBlockStateCuboid(-11, 2, -11, 11, 11, 11, BlockStates.AIR);
            rotate4.setBlockStateLine(-11, 1, -1, 0, 0, 1, 3, BlockStates.AIR);
            rotate4.setBlockStateCuboid(-15, 1, -6, -12, 11, 6, BlockStates.AIR);
            root.setBlockStateCuboid(-15, 0, -6, 15, 0, 6, netherBricks);
            floorFlip.setBlockStateCuboid(-6, 0, -15, 6, 0, -7, netherBricks);
            rotate4.setBlockStateCuboid(-10, 0, -10, -7, 6, -7, BlockStates.RED_NETHER_BRICKS);
            rotate4.setBlockStateCuboid(-9, 7, -9, -7, 7, -7, BlockStates.RED_NETHER_BRICKS);
            rotate4.setBlockStateCuboid(-8, 8, -8, -7, 8, -7, BlockStates.RED_NETHER_BRICKS);
            rotate8.setBlockStateCuboid(-6, 1, -15, -2, 1, -11, netherBricks);
            rotate8.setBlockStateCuboid(-6, 2, -11, -2, 5, -11, netherBricks);
            rotate8.setBlockStateCuboid(-2, 2, -15, -2, 4, -11, netherBricks);
            rotate8.setBlockStateLine(-3, 6, -11, -1, 0, 0, 9, netherBricks);
            rotate8.setBlockState(-2, 6, -11, BlockStates.CHISELED_NETHER_BRICKS);
            rotate8.setBlockStateLine(-2, 7, -10, -1, 0, 0, 8, netherBricks);
            rotate8.setBlockStateLine(-2, 8, -9, -1, 0, 0, 7, netherBricks);
            rotate8.setBlockStateLine(-2, 9, -8, -1, 0, 0, 6, netherBricks);
            rotate8.setBlockStateLine(-3, 10, -7, -1, 0, 0, 5, netherBricks);
            rotate8.setBlockState(-2, 10, -7, BlockStates.CHISELED_NETHER_BRICKS);
            rotate8.setBlockStateLine(-2, 7, -11, 0, 1, 1, 4, PortalTempleStructure.NETHER_BRICK_STAIRS('s'));
            rotate4.setBlockStateLine(-11, 6, -11, 1, 1, 1, 5, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockStateLine(-11, 7, -11, 1, 1, 1, 4, class_2246.field_10364.method_9564());
            rotate4.setBlockState(-7, 11, -7, PortalTempleStructure.NETHER_BRICK_FENCE("es"));
            rotate8.setBlockStateLine(-6, 11, -7, 1, 0, 0, 4, PortalTempleStructure.NETHER_BRICK_FENCE("ew"));
            rotate8.setBlockState(-2, 11, -7, PortalTempleStructure.NETHER_BRICK_FENCE("w"));
            root.setBlockStateCuboid(-7, 9, -7, 7, 9, 7, BlockStates.RED_NETHER_BRICKS);
            rotate4.setBlockStateCuboid(-2, 5, -14, 2, 5, -12, BlockStates.RED_NETHER_BRICKS);
            rotate8.stack(0, 0, 1, 3).setBlockStateLine(-6, 2, -14, 1, 1, 0, 4, PortalTempleStructure.RED_NETHER_BRICK_STAIRS('e'));
            rotate4.stack(1, 0, 0, 3).setBlockStateLine(-1, 6, -11, 0, 1, 1, 4, PortalTempleStructure.RED_NETHER_BRICK_STAIRS('s'));
            rotate8.setBlockState(-6, 2, -15, BlockStates.CHISELED_NETHER_BRICKS);
            rotate8.genericLine(-6, 2, -15, 1, 0, 0, 5, (coordinator, x, y, z, index) -> {
                if (index != 0 && index != 2) {
                    coordinator.setBlockStateLine(x, y, z, 0, 1, 0, index + 1, netherBricks);
                }
            });
            rotate4.setBlockStateLine(-1, 6, -15, 1, 0, 0, 3, netherBricks);
            rotate4.setBlockStateLine(-1, 1, -15, 1, 0, 0, 3, PortalTempleStructure.NETHER_BRICK_STAIRS('n'));
            rotate4.setBlockStateLine(-1, 5, -15, 1, 0, 0, 3, PortalTempleStructure.NETHER_BRICK_STAIRS('S'));
            rotate8.setBlockStateLine(-6, 3, -15, 1, 1, 0, 4, PortalTempleStructure.NETHER_BRICK_STAIRS('e'));
            rotate8.setBlockState(-2, 7, -15, PortalTempleStructure.NETHER_BRICK_FENCE("e"));
            rotate4.setBlockStateLine(-1, 7, -15, 1, 0, 0, 3, PortalTempleStructure.NETHER_BRICK_FENCE("ew"));
            rotate8.setBlockStateLine(-4, 2, -15, 0, 1, 0, PortalTempleStructure.NETHER_BRICK_FENCE("ew"), PortalTempleStructure.NETHER_BRICK_FENCE("ew"), PortalTempleStructure.NETHER_BRICK_STAIRS('S'));
            rotate8.setBlockStateLine(-2, 1, -13, 0, 1, 0, PortalTempleStructure.NETHER_BRICK_STAIRS('w'), PortalTempleStructure.NETHER_BRICK_FENCE("ns"), PortalTempleStructure.NETHER_BRICK_FENCE("ns"), PortalTempleStructure.NETHER_BRICK_STAIRS('W'));
            rotate8.setBlockStateLine(-4, 1, -11, 0, 1, 0, PortalTempleStructure.NETHER_BRICK_STAIRS('n'), PortalTempleStructure.NETHER_BRICK_FENCE("ew"), PortalTempleStructure.NETHER_BRICK_FENCE("ew"), PortalTempleStructure.NETHER_BRICK_STAIRS('N'));
            rotate8.stack(0, 0, 1, 3).genericLine(-5, 2, -14, 1, 0, 0, 3, (coordinator, x, y, z, index) -> coordinator.setBlockStateLine(x, y, z, 0, 1, 0, index + 1, BlockStates.LAVA));
            rotate8.stack(1, 0, 0, 3).setBlockStateLine(-5, 6, -10, 0, 1, 1, 3, PortalTempleStructure.RED_NETHER_BRICK_STAIRS('N'));
            rotate8.setBlockStateLine(-2, 6, -10, 0, 1, 1, 3, netherBricks);
            rotate8.setBlockStateLine(-2, 5, -10, 0, 1, 1, 4, PortalTempleStructure.NETHER_BRICK_STAIRS('N'));
            rotate4.stack(1, 0, 0, 3).setBlockStateLine(-1, 5, -11, 0, 1, 1, 4, PortalTempleStructure.RED_NETHER_BRICK_STAIRS('N'));
            rotate8.setBlockState(-5, 8, -6, PortalTempleStructure.NETHER_BRICK_STAIRS('W'));
            rotate4.setBlockStateLine(-4, 8, -6, 1, 0, 0, 9, (class_2680)class_2246.field_10390.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679));
            rotate8.setBlockState(-6, 1, -10, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockState(-6, 1, -6, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockStateLine(-6, 2, -6, 0, 1, 0, 7, netherBricks);
            if ((this.variant & 1) != 0) {
                rotate8.setBlockStateLine(-6, 2, -10, 0, 1, 0, 4, netherBricks);
                rotate8.stack(0, 0, 1, 2).setBlockStateLine(-6, 6, -10, 0, 1, 1, 3, netherBricks);
                rotate8.setBlockStateLine(-6, 5, -9, 0, 1, 1, 3, PortalTempleStructure.NETHER_BRICK_STAIRS('N'));
            } else {
                rotate8.setBlockStateLine(-6, 2, -10, 0, 1, 0, 5, netherBricks);
                rotate8.setBlockStateLine(-6, 5, -9, 0, 1, 0, 3, netherBricks);
                rotate8.setBlockStateLine(-6, 5, -8, 0, 1, 0, 4, netherBricks);
                rotate8.setBlockStateLine(-6, 5, -7, 0, 1, 0, 4, netherBricks);
                rotate8.setBlockState(-6, 4, -9, PortalTempleStructure.NETHER_BRICK_STAIRS('N'));
                rotate8.setBlockState(-6, 4, -7, PortalTempleStructure.NETHER_BRICK_STAIRS('S'));
            }
            rotate8.setBlockState(-7, 2, -11, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockState(-11, 2, -11, BlockStates.CHISELED_NETHER_BRICKS);
            rotate8.setBlockStateLine(-7, 3, -11, 0, 1, 0, 3, netherBricks);
            rotate4.setBlockStateLine(-11, 3, -11, 0, 1, 0, 3, netherBricks);
            rotate8.setBlockState(-8, 5, -11, PortalTempleStructure.NETHER_BRICK_STAIRS('E'));
            rotate8.setBlockState(-10, 5, -11, PortalTempleStructure.NETHER_BRICK_STAIRS('W'));
            if (!this.decorations.isEmpty()) {
                this.decorations.removeIf(positionState -> positionState.place(world, this.centerPos, chunkBox));
            }
            Iterator<class_2487> iterator = this.entities.iterator();
            while (iterator.hasNext()) {
                class_2514 y2;
                class_2514 x2;
                class_2520 class_25202;
                class_2487 nbt;
                block8: {
                    block7: {
                        class_2499 posNBT;
                        nbt = iterator.next();
                        class_25202 = nbt.method_10580("Pos");
                        if (!(class_25202 instanceof class_2499) || (posNBT = (class_2499)class_25202).size() != 3 || !((class_25202 = posNBT.method_10534(0)) instanceof class_2514)) break block7;
                        x2 = (class_2514)class_25202;
                        class_25202 = posNBT.method_10534(1);
                        if (!(class_25202 instanceof class_2514)) break block7;
                        y2 = (class_2514)class_25202;
                        class_25202 = posNBT.method_10534(2);
                        if (class_25202 instanceof class_2514) break block8;
                    }
                    BigGlobeMod.LOGGER.warn("Portal temple main building entity lacks position: " + String.valueOf(nbt));
                    iterator.remove();
                    continue;
                }
                class_2514 z2 = (class_2514)class_25202;
                class_2338 pos = class_2338.method_49637((double)x2.method_10697(), (double)y2.method_10697(), (double)z2.method_10697());
                if (!chunkBox.method_14662((class_2382)pos)) continue;
                nbt.method_10566("Pos", (class_2520)PortalTempleStructure.makeEntityPos(x2.method_10697(), y2.method_10697(), z2.method_10697()));
                class_1299.method_5892((class_2487)nbt, (class_1937)world.method_8410()).ifPresent(entity -> {
                    if (entity instanceof class_1308) {
                        class_1308 mob = (class_1308)entity;
                        mob.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16474, null);
                    }
                    world.method_30771(entity);
                });
                iterator.remove();
            }
        }
    }

    public static class PortalPiece
    extends Piece {
        public static final class_2680 NETHER_PORTAL_X = (class_2680)class_2246.field_10316.method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)class_2350.class_2351.field_11048);
        public static final class_2680 NETHER_PORTAL_Z = (class_2680)class_2246.field_10316.method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)class_2350.class_2351.field_11051);

        public PortalPiece(class_3773 type, int x, int y, int z, RandomGenerator random) {
            super(type, x, y, z, new class_3341(x - 4, y, z - 4, x + 4, y + 17, z + 4), random, 16);
        }

        public PortalPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
            this.centerPos = new class_2338(this.field_15315.method_35415() + this.field_15315.method_35418() + 1 >> 1, this.field_15315.method_35416(), this.field_15315.method_35417() + this.field_15315.method_35420() + 1 >> 1);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            Coordinator rotate4 = root.rotate4x90();
            Coordinator rotate8 = root.flip2X().rotate4x90();
            Coordinator obsidianStack = rotate4.stack(0, 11, 0, 2);
            obsidianStack.setBlockStateLine(-2, 0, -2, 1, 0, 0, 4, BlockStates.OBSIDIAN);
            obsidianStack.setBlockState(-1, 0, -1, PortalTempleStructure.maybeCryingObsidian(4));
            obsidianStack.setBlockState(0, 0, -1, PortalTempleStructure.maybeCryingObsidian(2));
            root.setBlockStateLine(0, 0, 0, 0, 11, 0, 2, BlockStates.CRYING_OBSIDIAN);
            rotate4.setBlockStateLine(-2, 1, -2, 0, 1, 0, 10, BlockStates.OBSIDIAN);
            if ((this.variant & 1) != 0) {
                root.setBlockStateCuboid(-1, 1, -2, 1, 10, -2, NETHER_PORTAL_X);
            }
            if ((this.variant & 2) != 0) {
                root.setBlockStateCuboid(2, 1, -1, 2, 10, 1, NETHER_PORTAL_Z);
            }
            if ((this.variant & 4) != 0) {
                root.setBlockStateCuboid(-1, 1, 2, 1, 10, 2, NETHER_PORTAL_X);
            }
            if ((this.variant & 8) != 0) {
                root.setBlockStateCuboid(-2, 1, -1, -2, 10, 1, NETHER_PORTAL_Z);
            }
            rotate4.setBlockStateLine(-1, 0, -3, 1, 0, 0, 3, PortalTempleStructure.NETHER_BRICK_STAIRS('s'));
            rotate8.setBlockStateLine(-2, 0, -3, 0, 1, 0, BlockStates.CHISELED_NETHER_BRICKS, PortalTempleStructure.NETHER_BRICK_STAIRS('s'), PortalTempleStructure.NETHER_BRICK_WALL("SU"), PortalTempleStructure.NETHER_BRICK_FENCE("s"), PortalTempleStructure.NETHER_BRICK_WALL("su"), PortalTempleStructure.NETHER_BRICK_STAIRS('S'), BlockStates.NETHER_BRICKS, PortalTempleStructure.NETHER_BRICK_FENCE("sw"), PortalTempleStructure.NETHER_BRICK_FENCE("sw"), PortalTempleStructure.NETHER_BRICK_STAIRS('W'), BlockStates.NETHER_BRICKS, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockState(-3, 0, -3, PortalTempleStructure.NETHER_BRICK_FENCE("es"));
            rotate4.setBlockStateLine(-3, 6, -3, 0, 1, 0, 4, BlockStates.NETHER_BRICKS);
            rotate4.setBlockStateLine(-3, 10, -3, 0, 1, 0, PortalTempleStructure.NETHER_BRICK_WALL("ESU"), PortalTempleStructure.NETHER_BRICK_FENCE("es"));
            rotate8.setBlockStateLine(-1, 6, -3, 0, 1, 0, PortalTempleStructure.NETHER_BRICK_STAIRS('W'), PortalTempleStructure.NETHER_BRICK_STAIRS('e'), null, null, PortalTempleStructure.NETHER_BRICK_STAIRS('W'));
            rotate4.setBlockStateLine(0, 7, -3, 0, 1, 0, BlockStates.CHISELED_NETHER_BRICKS, BlockStates.NETHER_BRICKS, PortalTempleStructure.NETHER_BRICK_WALL(""), BlockStates.NETHER_BRICKS);
            rotate4.setBlockStateLine(-1, 11, -3, 1, 0, 0, 3, PortalTempleStructure.NETHER_BRICK_STAIRS('s'));
            rotate4.setBlockStateLine(-2, 12, -2, 0, 1, 0, 3, BlockStates.NETHER_BRICKS);
            rotate4.translate(-2, 12, -2).rotate4x90().setBlockStateLine(0, 0, -1, 0, 1, 0, PortalTempleStructure.NETHER_BRICK_WALL("SU"), PortalTempleStructure.NETHER_BRICK_FENCE("s"));
            rotate4.setBlockStateLine(-2, 15, -2, 0, 1, 0, PortalTempleStructure.NETHER_BRICK_WALL(""), PortalTempleStructure.NETHER_BRICK_FENCE(""));
        }
    }

    public static class WellPiece
    extends DecorationPiece {
        public WellPiece(class_3773 type, int x, int y, int z, RandomGenerator random) {
            super(type, x, y, z, random, 2);
        }

        public WellPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public int getRadius() {
            return 1;
        }

        @Override
        public int getHeight() {
            return 1;
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            Coordinator rotate4 = root.rotate4x90();
            rotate4.setBlockState(-1, 0, -1, (this.variant & 1) != 0 ? BlockStates.CHISELED_NETHER_BRICKS : BlockStates.NETHER_BRICKS);
            rotate4.setBlockState(0, 0, -1, BlockStates.NETHER_BRICKS);
            root.setBlockState(0, 0, 0, BlockStates.LAVA);
        }
    }

    public static class FarmPiece
    extends DecorationPiece {
        public FarmPiece(class_3773 type, int x, int y, int z, RandomGenerator random) {
            super(type, x, y, z, random, 2);
        }

        public FarmPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public int getRadius() {
            return 2;
        }

        @Override
        public int getHeight() {
            return 5;
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            Coordinator rotate4 = root.rotate4x90();
            rotate4.setBlockState(-2, 0, -2, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockStateLine(-1, 0, -2, 1, 0, 0, 3, PortalTempleStructure.NETHER_BRICK_STAIRS('s'));
            rotate4.setBlockStateLine(-2, 1, -2, 0, 1, 0, 2, PortalTempleStructure.NETHER_BRICK_FENCE(""));
            rotate4.setBlockState(-2, 3, -2, (class_2680)PortalTempleStructure.NETHER_BRICK_STAIRS('s').method_11657((class_2769)class_2510.field_11565, (Comparable)class_2778.field_12708));
            rotate4.setBlockStateLine(-1, 3, -2, 1, 0, 0, 3, PortalTempleStructure.NETHER_BRICK_STAIRS('s'));
            root.setBlockStateCuboid(-1, 4, -1, 1, 4, 1, (class_2680)class_2246.field_10390.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681));
            root.setBlockStateCuboid(-1, 0, -1, 1, 0, 1, BlockStates.SOUL_SAND);
            root.setBlockStateCuboid(-1, 1, -1, 1, 1, 1, PortalTempleStructure.netherWart());
            root.setBlockStateCuboid(-1, 3, -1, 1, 3, 1, ((this.variant & 1) != 0 ? class_2246.field_22122 : class_2246.field_10171).method_9564());
        }
    }

    public static class TablePiece
    extends DecorationPiece {
        public static final PositionDirections[] SMALL_POSITIONS = new PositionDirections[]{new PositionDirections(-1, 1, -1, class_2350.field_11039, class_2350.field_11043), new PositionDirections(-1, 1, 0, class_2350.field_11039), new PositionDirections(-1, 1, 1, class_2350.field_11039, class_2350.field_11035), new PositionDirections(0, 1, -1, class_2350.field_11043), new PositionDirections(0, 1, 1, class_2350.field_11035), new PositionDirections(1, 1, -1, class_2350.field_11034, class_2350.field_11043), new PositionDirections(1, 1, 0, class_2350.field_11034), new PositionDirections(1, 1, 1, class_2350.field_11034, class_2350.field_11035)};
        public static final PositionDirections[] BIG_POSITIONS = new PositionDirections[]{new PositionDirections(-2, 1, -2, class_2350.field_11039, class_2350.field_11043), new PositionDirections(-2, 1, -1, class_2350.field_11039), new PositionDirections(-2, 1, 0, class_2350.field_11039), new PositionDirections(-2, 1, 1, class_2350.field_11039), new PositionDirections(-2, 1, 2, class_2350.field_11039, class_2350.field_11035), new PositionDirections(-1, 1, -2, class_2350.field_11043), new PositionDirections(-1, 1, 2, class_2350.field_11035), new PositionDirections(0, 1, -2, class_2350.field_11043), new PositionDirections(0, 1, 2, class_2350.field_11035), new PositionDirections(1, 1, -2, class_2350.field_11043), new PositionDirections(1, 1, 2, class_2350.field_11035), new PositionDirections(2, 1, -2, class_2350.field_11034, class_2350.field_11043), new PositionDirections(2, 1, -1, class_2350.field_11034), new PositionDirections(2, 1, 0, class_2350.field_11034), new PositionDirections(2, 1, 1, class_2350.field_11034), new PositionDirections(2, 1, 2, class_2350.field_11034, class_2350.field_11035)};
        public final List<PositionState> decorationBlocks;

        public TablePiece(class_3773 type, int x, int y, int z, RandomGenerator random) {
            super(type, x, y, z, random, 4);
            PositionDirections[] availablePositions;
            int count;
            if ((this.variant & 1) != 0) {
                count = 1 + random.nextInt(2) + random.nextInt(2);
                availablePositions = BIG_POSITIONS;
            } else {
                count = random.nextInt(2);
                availablePositions = SMALL_POSITIONS;
            }
            this.decorationBlocks = new ArrayList<PositionState>(count);
            PortalTempleStructure.doForSomeElements(random, availablePositions, count, chosenPosition -> {
                class_2680 state;
                switch (random.nextInt(10)) {
                    case 0: {
                        if (random.nextBoolean()) {
                            class_2248 block = switch (random.nextInt(3)) {
                                case 0 -> class_2246.field_10535;
                                case 1 -> class_2246.field_10105;
                                case 2 -> class_2246.field_10414;
                                default -> throw new AssertionError();
                            };
                            state = block.method_9564();
                        } else {
                            state = (class_2680)class_2246.field_16337.method_9564().method_11657((class_2769)class_2341.field_11007, (Comparable)class_2738.field_12475);
                        }
                        state = (class_2680)state.method_11657((class_2769)class_2383.field_11177, (Comparable)Permuter.choose(random, Directions.HORIZONTAL));
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (random.nextBoolean()) {
                            state = (class_2680)class_2246.field_16335.method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)Permuter.choose(random, Directions.HORIZONTAL));
                            break;
                        }
                        state = class_2246.field_16329.method_9564();
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        class_2248 block = switch (random.nextInt(4)) {
                            case 0, 1 -> class_2246.field_10181;
                            case 2 -> class_2246.field_16334;
                            case 3 -> class_2246.field_16333;
                            default -> throw new AssertionError();
                        };
                        state = (class_2680)block.method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)chosenPosition.getRandomDirection(random));
                        break;
                    }
                    default: {
                        state = class_2246.field_9980.method_9564();
                    }
                }
                this.decorationBlocks.add(new PositionState((class_2382)chosenPosition, state));
            });
        }

        public TablePiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
            this.decorationBlocks = PortalTempleStructure.readListFromNBTCompound(nbt, "decorations", PositionState::decode);
        }

        @Override
        public void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            PortalTempleStructure.writeListToNBTAndStoreInCompound(nbt, "decorations", this.decorationBlocks, PositionState::writeToNBT);
        }

        @Override
        public int getRadius() {
            return (this.variant & 1) + 1;
        }

        @Override
        public int getHeight() {
            return 2;
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            Coordinator rotate4 = root.rotate4x90();
            if ((this.variant & 1) != 0) {
                rotate4.setBlockState(-2, 0, -2, (class_2680)PortalTempleStructure.POLISHED_BLACKSTONE_STAIRS('S').method_11657((class_2769)class_2510.field_11565, (Comparable)class_2778.field_12708));
                rotate4.setBlockStateLine(-1, 0, -2, 1, 0, 0, 3, PortalTempleStructure.POLISHED_BLACKSTONE_STAIRS('S'));
                rotate4.setBlockStateLine(-1, 0, -1, 1, 0, 0, 2, class_2246.field_23873.method_9564());
            } else {
                rotate4.setBlockState(-1, 0, -1, (class_2680)PortalTempleStructure.POLISHED_BLACKSTONE_STAIRS('S').method_11657((class_2769)class_2510.field_11565, (Comparable)class_2778.field_12708));
                rotate4.setBlockState(0, 0, -1, PortalTempleStructure.POLISHED_BLACKSTONE_STAIRS('S'));
            }
            root.setBlockState(0, 0, 0, ((this.variant & 2) != 0 ? class_2246.field_23876 : class_2246.field_23873).method_9564());
            if (!this.decorationBlocks.isEmpty()) {
                this.decorationBlocks.removeIf(state -> state.place(world, this.centerPos, chunkBox));
            }
        }
    }

    public static class FurnacePiece
    extends DecorationPiece {
        public FurnacePiece(class_3773 type, int x, int y, int z, RandomGenerator random) {
            super(type, x, y, z, random, 4);
        }

        public FurnacePiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void initBoundingBox(int x, int y, int z, RandomGenerator random) {
            int magnitude = FurnacePiece.nextUniformIntInclusive(random, (this.variant & 2) != 0 ? 3 : 6);
            int side = FurnacePiece.nextUniformIntInclusive(random, 1);
            if (random.nextBoolean()) {
                x += magnitude;
                z += side;
            } else {
                z += magnitude;
                x += side;
            }
            this.field_15315 = new class_3341(x - 1, ++y, z - 1, x + 1, y + 7, z + 1);
            this.centerPos = new class_2338(x, y, z);
        }

        @Override
        public int getRadius() {
            return 1;
        }

        @Override
        public int getHeight() {
            return (this.variant & 2) != 0 ? 8 : 4;
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            Coordinator rotate4 = root.rotate4x90();
            rotate4.setBlockState(-1, 0, -1, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockState(0, 0, -1, PortalTempleStructure.NETHER_BRICK_STAIRS('s'));
            if ((this.variant & 1) != 0) {
                root.setBlockState(0, 0, 0, BlockStates.SOUL_SAND);
                root.setBlockState(0, 1, 0, class_2246.field_22089.method_9564());
            } else {
                root.setBlockState(0, 0, 0, BlockStates.NETHERRACK);
                root.setBlockState(0, 1, 0, class_2246.field_10036.method_9564());
            }
            rotate4.setBlockState(-1, 1, -1, BlockStates.NETHER_BRICKS);
            rotate4.setBlockState(0, 2, -1, BlockStates.NETHER_BRICKS);
            rotate4.setBlockState(-1, 2, -1, (class_2680)PortalTempleStructure.NETHER_BRICK_STAIRS('s').method_11657((class_2769)class_2510.field_11565, (Comparable)class_2778.field_12712));
            if ((this.variant & 2) != 0) {
                rotate4.setBlockStateLine(0, 3, -1, 0, 1, 0, 5, BlockStates.NETHER_BRICKS);
            } else {
                rotate4.setBlockState(0, 3, -1, PortalTempleStructure.NETHER_BRICK_STAIRS('s'));
            }
        }
    }

    public static class SpawnerPiece
    extends DecorationPiece {
        public SpawnerPiece(class_3773 type, int x, int y, int z, RandomGenerator random) {
            super(type, x, y, z, random, 1);
        }

        public SpawnerPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public int getRadius() {
            return 1;
        }

        @Override
        public int getHeight() {
            return 5;
        }

        @Override
        public boolean isCeiling() {
            return true;
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox).translate(0, -3, 0);
            Coordinator rotate4 = root.rotate4x90();
            rotate4.setBlockStateLine(-1, 2, -1, 0, 1, 0, 2, PortalTempleStructure.NETHER_BRICK_FENCE(""));
            rotate4.setBlockState(-1, 1, -1, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockState(0, 1, -1, PortalTempleStructure.NETHER_BRICK_STAIRS('S'));
            root.setBlockState(0, 1, 0, BlockStates.NETHER_BRICKS);
            rotate4.setBlockState(-1, 0, -1, PortalTempleStructure.NETHER_BRICK_WALL(""));
            rotate4.setBlockState(-1, -1, -1, BlockStates.CHISELED_NETHER_BRICKS);
            rotate4.setBlockState(0, -1, -1, PortalTempleStructure.NETHER_BRICK_STAIRS('s'));
            root.setBlockState(0, -1, 0, BlockStates.NETHER_BRICKS);
            root.setBlockState(0, 0, 0, class_2246.field_10260.method_9564());
            root.getBlockEntity(0, 0, 0, class_2591.field_11889, (pos, spawner) -> spawner.method_46408(class_1299.field_6099, (class_5819)new MojangPermuter(Permuter.permute(1016481365811449692L, (class_2382)pos))));
        }
    }

    public static abstract class Piece
    extends class_3443 {
        public class_2338 centerPos;
        public byte variant;

        public Piece(class_3773 type, int x, int y, int z, class_3341 boundingBox, RandomGenerator random, int variantCount) {
            super(type, 0, boundingBox);
            this.centerPos = new class_2338(x, y, z);
            if (variantCount > 0) {
                this.variant = (byte)random.nextInt(variantCount);
            }
        }

        public Piece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, nbt);
            byte by;
            class_2520 class_25202 = nbt.method_10580("var");
            if (class_25202 instanceof class_2514) {
                class_2514 number = (class_2514)class_25202;
                by = number.method_10698();
            } else {
                by = 0;
            }
            this.variant = by;
        }

        public void method_14943(class_6625 context, class_2487 nbt) {
            nbt.method_10567("var", this.variant);
        }

        public Coordinator coordinator(class_5281 world, class_3341 box) {
            return Coordinator.forWorld(world, 3).inBox(box, false).translate((class_2382)this.centerPos, false);
        }

        public void method_14922(int x, int y, int z) {
            super.method_14922(x, y, z);
            this.centerPos = this.centerPos.method_10069(x, y, z);
        }
    }

    public static class PositionState
    extends class_2338 {
        public final class_2680 state;
        public final class_2487 blockEntityData;

        public PositionState(class_2382 vector, class_2680 state, class_2487 blockEntityData) {
            super(vector);
            this.state = state;
            this.blockEntityData = blockEntityData;
        }

        public PositionState(class_2382 vector, class_2680 state) {
            this(vector, state, null);
        }

        public PositionState(int x, int y, int z, class_2680 state, class_2487 blockEntityData) {
            super(x, y, z);
            this.state = state;
            this.blockEntityData = blockEntityData;
        }

        public static PositionState decode(class_2487 nbt) {
            class_2520 class_25202 = nbt.method_10580("x");
            if (class_25202 instanceof class_2514) {
                class_2514 x = (class_2514)class_25202;
                class_25202 = nbt.method_10580("y");
                if (class_25202 instanceof class_2514) {
                    class_2514 y = (class_2514)class_25202;
                    class_25202 = nbt.method_10580("z");
                    if (class_25202 instanceof class_2514) {
                        class_2487 compound;
                        class_2514 z = (class_2514)class_25202;
                        class_2680 state = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)nbt);
                        class_2520 class_25203 = nbt.method_10580("BlockEntityTag");
                        class_2487 blockEntityData = class_25203 instanceof class_2487 ? (compound = (class_2487)class_25203) : null;
                        return new PositionState(x.method_10701(), y.method_10701(), z.method_10701(), state, blockEntityData);
                    }
                }
            }
            return null;
        }

        public class_2487 writeToNBT() {
            class_2487 nbt = new class_2487();
            this.writeToNBT(nbt);
            return nbt;
        }

        public void writeToNBT(class_2487 nbt) {
            nbt.method_10569("x", this.method_10263());
            nbt.method_10569("y", this.method_10264());
            nbt.method_10569("z", this.method_10260());
            nbt.method_10543(class_2512.method_10686((class_2680)this.state));
            if (this.blockEntityData != null) {
                nbt.method_10566("BlockEntityTag", (class_2520)this.blockEntityData);
            }
        }

        public boolean place(class_5281 world, class_2338 origin, class_3341 box) {
            class_2586 blockEntity;
            class_2338 pos = this.method_10081((class_2382)origin);
            if (!box.method_14662((class_2382)pos)) {
                return false;
            }
            if (!world.method_8652(pos, this.state, 3)) {
                return false;
            }
            if (this.blockEntityData != null && (blockEntity = WorldUtil.getBlockEntity((class_1922)world, pos, class_2586.class)) != null) {
                class_2487 oldNBT = BlockEntityVersions.writeToNbt(blockEntity);
                class_2487 newNBT = oldNBT.method_10553().method_10543(this.blockEntityData);
                newNBT.method_10569("x", pos.method_10263());
                newNBT.method_10569("y", pos.method_10264());
                newNBT.method_10569("z", pos.method_10260());
                if (!oldNBT.equals((Object)newNBT)) {
                    BlockEntityVersions.readFromNbt(blockEntity, newNBT);
                    blockEntity.method_5431();
                }
            }
            return true;
        }
    }

    public static class PositionDirections
    extends class_2338 {
        public final class_2350[] directions;

        public PositionDirections(int x, int y, int z, class_2350 ... directions) {
            super(x, y, z);
            this.directions = directions;
        }

        public class_2350 getRandomDirection(RandomGenerator random) {
            class_2350[] directions;
            return directions[(directions = this.directions).length == 1 ? 0 : random.nextInt(directions.length)];
        }

        public class_2350 getRandomDirection() {
            class_2350[] directions;
            return directions[(directions = this.directions).length == 1 ? 0 : Permuter.nextBoundedInt(Permuter.permute(4972215473139722902L, (class_2382)this), directions.length)];
        }
    }
}

