/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures.dungeons;

import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.mixins.MobSpawnerLogic_GettersAndSettersForEverything;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.structures.BigGlobeStructures;
import builderb0y.bigglobe.structures.LabyrinthLayout;
import builderb0y.bigglobe.structures.RawGenerationStructure;
import builderb0y.bigglobe.structures.dungeons.AbstractDungeonStructure;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import builderb0y.bigglobe.versions.BlockStateVersions;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.random.RandomGenerator;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2595;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import org.jetbrains.annotations.Nullable;

public class MediumDungeonStructure
extends AbstractDungeonStructure {
    public static final MapCodec<MediumDungeonStructure> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(MediumDungeonStructure.class);

    public MediumDungeonStructure(class_3195.class_7302 config, @VerifyNullable ColumnScript.ColumnToIntScript.Holder min_y, @VerifyNullable ColumnScript.ColumnToIntScript.Holder surface_y, @VerifyNullable DelayedEntryList<class_2975<?, ?>> room_decorators, IRandomList<class_6880<class_1299<?>>> spawner_entries, List<AbstractDungeonStructure.Palette> palettes) {
        super(config, min_y, surface_y, room_decorators, spawner_entries, palettes);
    }

    @Override
    public AbstractDungeonStructure.DungeonLayout layout(ScriptedColumn column, int y, RandomGenerator random) {
        return new Layout(column, y, random, this.room_decorators, this.spawner_entries, MediumDungeonStructure.getActualEntry(this));
    }

    public class_7151<?> method_41618() {
        return BigGlobeStructures.MEDIUM_DUNGEON_TYPE;
    }

    public static class Layout
    extends AbstractDungeonStructure.DungeonLayout {
        public Layout(ScriptedColumn column, int y, RandomGenerator random, @Nullable DelayedEntryList<class_2975<?, ?>> roomDecorators, IRandomList<class_6880<class_1299<?>>> spawnerEntries, class_6880<class_3195> owningStructure) {
            super(column, y, random, (random.nextInt() & 0xFF) + 128, roomDecorators, spawnerEntries, owningStructure);
        }

        @Override
        public AbstractDungeonStructure.RoomDungeonPiece newRoom() {
            return new Room((class_3773)BigGlobeStructures.MEDIUM_DUNGEON_ROOM_TYPE, (class_6880<class_3195>)this.owningStructure, this.paletteIndex, this.random, this.roomDecorators);
        }

        @Override
        public AbstractDungeonStructure.HallDungeonPiece newHall(LabyrinthLayout.RoomPiece room1, LabyrinthLayout.RoomPiece room2, class_2350 direction) {
            return Hall.create((Room)room1, (Room)room2, direction, this.random);
        }

        @Override
        public int distanceBetweenRooms() {
            return 8;
        }

        @Override
        public boolean isValidPosition(LabyrinthLayout.RoomPiece next) {
            return BigGlobeMath.squareI(next.x() - this.centerX, next.z() - this.centerZ) < (this.random.nextInt() & 0x7FF);
        }

        @Override
        public int maxHeightDifference() {
            return 2;
        }
    }

    public static class Hall2
    extends Hall {
        public Hall2(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, x, y, z, owningStructure, paletteIndex, direction, random);
        }

        public Hall2(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            Coordinator root = this.coordinator(context);
            AbstractDungeonStructure.Palette palette = this.palette();
            int left = this.getLeft();
            int right = this.getRight();
            root.setBlockStateLine(0, 0, left - 1, 0, 1, 0, 6, palette.mainSupplier());
            root.setBlockStateLine(0, 0, right + 1, 0, 1, 0, 6, palette.mainSupplier());
            root.stack(0, 5, 0, 2).setBlockStateLine(0, 0, left, 0, 0, 1, right - left + 1, palette.mainSupplier());
            root.setBlockStateCuboid(0, 1, left, 0, 4, right, this.hasBars() ? palette.barsSupplier(true, false, true, false) : palette.air());
            root.setBlockStateCuboid(-1, 1, left, -1, 3, right, BlockStates.AIR);
            root.setBlockStateCuboid(-2, 0, left, -2, 3, right, BlockStates.AIR);
            root.setBlockStateCuboid(1, 2, left, 1, 4, right, BlockStates.AIR);
            root.setBlockStateCuboid(2, 2, left, 2, 5, right, BlockStates.AIR);
            root.stack(2, 1, 0, 2).setBlockStateLine(-1, 0, left, 0, 0, 1, right - left + 1, palette.slabSupplier(class_2771.field_12681));
            root.stack(2, 1, 0, 2).setBlockStateLine(-1, 4, left, 0, 0, 1, right - left + 1, palette.slabSupplier(class_2771.field_12679));
        }
    }

    public static class Hall1
    extends Hall {
        public Hall1(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, x, y, z, owningStructure, paletteIndex, direction, random);
        }

        public Hall1(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            Coordinator root = this.coordinator(context);
            AbstractDungeonStructure.Palette palette = this.palette();
            int left = this.getLeft();
            int right = this.getRight();
            root.setBlockStateLine(0, 0, left - 1, 0, 1, 0, 5, palette.mainSupplier());
            root.setBlockStateLine(0, 0, right + 1, 0, 1, 0, 5, palette.mainSupplier());
            root.setBlockStateLine(0, 0, left, 0, 0, 1, right - left + 1, palette.slabSupplier(class_2771.field_12681));
            root.setBlockStateLine(0, 4, left, 0, 0, 1, right - left + 1, palette.slabSupplier(class_2771.field_12679));
            root.setBlockStateCuboid(0, 1, left, 0, 3, right, BlockStates.AIR);
            root.stack(3, 1, 0, 2).setBlockStateCuboid(-2, 0, left, -1, 3, right, BlockStates.AIR);
        }
    }

    public static class Hall0
    extends Hall {
        public Hall0(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, x, y, z, owningStructure, paletteIndex, direction, random);
        }

        public Hall0(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            Coordinator root = this.coordinator(context);
            AbstractDungeonStructure.Palette palette = this.palette();
            int left = this.getLeft();
            int right = this.getRight();
            root.setBlockStateLine(0, 0, left - 1, 0, 1, 0, 6, palette.mainSupplier());
            root.setBlockStateLine(0, 0, right + 1, 0, 1, 0, 6, palette.mainSupplier());
            root.stack(0, 5, 0, 2).setBlockStateLine(0, 0, left, 0, 0, 1, right - left + 1, palette.mainSupplier());
            root.setBlockStateCuboid(0, 1, left, 0, 4, right, this.hasBars() ? palette.barsSupplier(true, false, true, false) : palette.air());
            root.flip2X().setBlockStateCuboid(1, 1, left, 2, 4, right, BlockStates.AIR);
        }
    }

    public static abstract class Hall
    extends AbstractDungeonStructure.HallDungeonPiece {
        public Hall(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, RandomGenerator random) {
            super(type, 0, new class_3341(x - 3, y, z - 3, x + 3, y + 5, z + 3), owningStructure, paletteIndex);
            this.method_14926(direction);
            this.setBars((random.nextInt() & 7) == 0);
            int width = random.nextInt(5) + 1;
            int position = random.nextInt(6 - width) - 2;
            this.setLeft(position);
            this.setRight(position + width - 1);
        }

        public Hall(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public static Hall create(Room from, Room to, class_2350 direction, RandomGenerator random) {
            return Hall.create(from.x() + to.x() >> 1, Math.min(from.y(), to.y()), from.z() + to.z() >> 1, (class_6880<class_3195>)from.owningStructure, from.paletteIndex, direction, to.y() - from.y(), random);
        }

        public static Hall create(int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 direction, int step, RandomGenerator random) {
            if (step != 0) {
                ++y;
            }
            return switch (step) {
                case -2 -> new Hall2(BigGlobeStructures.MEDIUM_DUNGEON_HALL2_TYPE, x, y, z, owningStructure, paletteIndex, direction.method_10153(), random);
                case -1 -> new Hall1(BigGlobeStructures.MEDIUM_DUNGEON_HALL1_TYPE, x, y, z, owningStructure, paletteIndex, direction.method_10153(), random);
                case 0 -> new Hall0(BigGlobeStructures.MEDIUM_DUNGEON_HALL0_TYPE, x, y, z, owningStructure, paletteIndex, direction, random);
                case 1 -> new Hall1(BigGlobeStructures.MEDIUM_DUNGEON_HALL1_TYPE, x, y, z, owningStructure, paletteIndex, direction, random);
                case 2 -> new Hall2(BigGlobeStructures.MEDIUM_DUNGEON_HALL2_TYPE, x, y, z, owningStructure, paletteIndex, direction, random);
                default -> throw new IllegalArgumentException(Integer.toString(step));
            };
        }
    }

    public static class SpawnerPiece
    extends AbstractDungeonStructure.SpawnerDungeonPiece {
        public SpawnerPiece(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_6880<class_1299<?>> spawnerType) {
            super(type, 0, new class_3341(x - 1, y, z - 1, x + 1, y + 1, z + 1), owningStructure, paletteIndex, spawnerType);
        }

        public SpawnerPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            AbstractDungeonStructure.Palette palette = this.palette();
            root.setBlockState(0, 0, 0, palette.mainSupplier());
            root.setBlockStateAndBlockEntity(0, 1, 0, class_2246.field_10260.method_9564(), class_2636.class, this::initSpawner);
            root.rotate4x90().setBlockState(1, 0, 0, palette.stairsSupplier(class_2760.field_12617, class_2350.field_11039, class_2778.field_12710));
        }

        @Override
        public void initSpawner(class_2338 pos, class_2636 spawner) {
            super.initSpawner(pos, spawner);
            MobSpawnerLogic_GettersAndSettersForEverything logic = (MobSpawnerLogic_GettersAndSettersForEverything)spawner.method_11390();
            logic.bigglobe_setRequiredPlayerRange(24);
            logic.bigglobe_setMaxNearbyEntities(4);
            logic.bigglobe_setSpawnCount(3);
        }
    }

    public static class ChestPiece
    extends AbstractDungeonStructure.ChestDungeonPiece {
        public ChestPiece(class_3773 type, int x, int y, int z, class_6880<class_3195> owningStructure, int paletteIndex, class_2350 facing, long seed) {
            super(type, 0, new class_3341(x - 1, y, z - 1, x + 1, y + 1, z + 1), owningStructure, paletteIndex, facing, seed);
        }

        public ChestPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            Coordinator root = this.coordinator(world, chunkBox);
            AbstractDungeonStructure.Palette palette = this.palette();
            root.setBlockStateLine(-1, 0, 0, 1, 0, 0, 3, palette.mainSupplier());
            root.setBlockStateAndBlockEntity(0, 1, 0, class_2246.field_10034.method_9564(), class_2595.class, this::initChest);
            root.flip4XZ().setBlockState(1, 0, 1, palette.stairsSupplier(class_2760.field_12617, class_2350.field_11043, class_2778.field_12710));
            root.flip2X().setBlockState(1, 1, 0, palette.stairsSupplier(class_2760.field_12617, class_2350.field_11039, class_2778.field_12710));
        }
    }

    public static class Room
    extends AbstractDungeonStructure.RoomDungeonPiece {
        public Room(class_3773 type, class_6880<class_3195> owningStructure, int paletteIndex, RandomGenerator random, @Nullable DelayedEntryList<class_2975<?, ?>> decorators) {
            super(type, 0, null, owningStructure, paletteIndex, decorators);
            this.setPit((random.nextInt() & 0xF) == 0);
            this.setPos(0, 0, 0);
        }

        public Room(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public void setPos(int x, int y, int z) {
            this.field_15315 = new class_3341(x - 3, this.hasPit() ? y - 2 : y, z - 3, x + 3, y + 5, z + 3);
        }

        @Override
        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            super.method_14931(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
            if (!this.hasPit() && this.support) {
                class_2338.class_2339 pos = new class_2338.class_2339();
                int x = this.x();
                int y = this.y() - 1;
                int z = this.z();
                Coordinator rotator = this.coordinator(world, chunkBox).rotate4x90();
                rotator.setBlockStateLine(-1, -1, -3, 0, 0, 3, 3, this.palette().stairsSupplier(class_2760.field_12619, class_2350.field_11034, class_2778.field_12710));
                rotator.setBlockState(-2, -1, 0, this.palette().stairsSupplier(class_2760.field_12619, class_2350.field_11039, class_2778.field_12710));
                this.generateDown(world, pos.method_10103(x, y, z), chunkBox);
                this.generateDown(world, pos.method_10103(x - 3, y, z), chunkBox);
                this.generateDown(world, pos.method_10103(x + 3, y, z), chunkBox);
                this.generateDown(world, pos.method_10103(x, y, z - 3), chunkBox);
                this.generateDown(world, pos.method_10103(x, y, z + 3), chunkBox);
            }
        }

        public void generateDown(class_5281 world, class_2338.class_2339 pos, class_3341 chunkBox) {
            if (chunkBox.method_14662((class_2382)pos)) {
                CoordinateFunctions.CoordinateSupplier<class_2680> mainSupplier = this.palette().mainSupplier();
                while (BlockStateVersions.isReplaceable(world.method_8320((class_2338)pos))) {
                    world.method_8652((class_2338)pos, mainSupplier.get(pos), 3);
                    if (!world.method_31606((class_2338)pos.method_33098(pos.method_10264() - 1))) continue;
                    break;
                }
            }
        }

        @Override
        public void addDecorations(LabyrinthLayout layout) {
            super.addDecorations(layout);
            if (this.hasPit()) {
                layout.decorations.add((Object)new AbstractDungeonStructure.PitDungeonPiece(BigGlobeStructures.DUNGEON_PIT_TYPE, this.x(), this.y(), this.z(), (class_6880<class_3195>)this.owningStructure, this.paletteIndex, layout.random.nextInt(3), layout.random));
                this.decorators = null;
            } else {
                class_2350 deadEndDirection = this.getDeadEndDirection();
                if (deadEndDirection != null) {
                    if (layout.random.nextBoolean()) {
                        layout.decorations.add((Object)new ChestPiece(BigGlobeStructures.MEDIUM_DUNGEON_CHEST_TYPE, this.x(), this.y() + 1, this.z(), (class_6880<class_3195>)this.owningStructure, this.paletteIndex, deadEndDirection, layout.random.nextLong()));
                        this.decorators = null;
                    }
                } else if ((layout.random.nextInt() & 0xF) == 0) {
                    layout.decorations.add((Object)new SpawnerPiece(BigGlobeStructures.MEDIUM_DUNGEON_SPAWNER_TYPE, this.x(), this.y() + 1, this.z(), (class_6880<class_3195>)this.owningStructure, this.paletteIndex, (class_6880)((Layout)layout).spawnerEntries.getRandomElement(layout.random)));
                    this.decorators = null;
                }
            }
        }
    }
}

