/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures.megaTree;

import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.FastMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.structures.megaTree.Ball;
import builderb0y.bigglobe.structures.megaTree.MegaTreeStructure;
import builderb0y.bigglobe.util.Vectors;
import java.util.random.RandomGenerator;
import net.minecraft.class_2902;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class MegaTreeBranch {
    public MegaTreeStructure.MegaTreeContext context;
    public int totalSteps;
    public int currentStep;
    public int stepsUntilNextSplit;
    public double startRadius;
    public Vector3d velocity;
    public Vector3d acceleration;
    public Ball lastBall;

    public MegaTreeBranch(MegaTreeStructure.MegaTreeContext context, double x, double y, double z, double startRadius, int totalSteps, int stepsUntilNextSplit, Vector3d velocity, Vector3d acceleration) {
        this.context = context;
        this.totalSteps = totalSteps;
        this.currentStep = 0;
        this.stepsUntilNextSplit = stepsUntilNextSplit;
        this.startRadius = startRadius;
        this.velocity = velocity;
        this.acceleration = acceleration;
        this.lastBall = new Ball(x, y, z, startRadius);
    }

    public void generate() {
        MegaTreeStructure.MegaTreeContext context = this.context;
        context.addBall(this.lastBall);
        double size = context.size;
        Vector3d scratchPos = new Vector3d();
        Vector3d shyness = new Vector3d();
        ScriptedColumn column = context.column;
        ColumnScript.ColumnToIntScript.Holder surfaceYGetter = context.structure.surface_y;
        while (this.currentStep < this.totalSteps) {
            ++this.currentStep;
            --this.stepsUntilNextSplit;
            double progress = (double)this.currentStep / (double)this.totalSteps;
            double currentRadius = Interpolator.mixLinear(this.startRadius, 0.5, progress);
            Vector3d position = this.lastBall.position();
            Ball closestBall = context.octree.findClosestBall(this.lastBall);
            if (closestBall != null) {
                shyness.set((Vector3dc)this.lastBall.position()).sub((Vector3dc)closestBall.position()).mul(4.0 / BigGlobeMath.squareD(Math.max(1.0, shyness.length() - this.lastBall.radius() - closestBall.radius())));
            } else {
                shyness.set(0.0);
            }
            column.setParams(column.params.at(BigGlobeMath.floorI(position.x), BigGlobeMath.floorI(position.z)));
            int surfaceY = surfaceYGetter != null ? surfaceYGetter.get(column) : context.structureContext.comp_562().method_20402(BigGlobeMath.floorI(position.x), BigGlobeMath.floorI(position.z), class_2902.class_2903.field_13195, context.structureContext.comp_569(), context.structureContext.comp_564());
            Vectors.setInSphere(scratchPos, (RandomGenerator)context.permuter, 0.25);
            scratchPos.y += FastMath.Exp.fastExp2(((double)surfaceY - position.y) * 0.125 + size * 0.015625);
            scratchPos.add((Vector3dc)shyness).add((Vector3dc)this.acceleration).mul(0.125 / this.startRadius);
            Vector3d prevVelocity = this.velocity;
            Vector3d nextVelocity = new Vector3d((Vector3dc)prevVelocity).add((Vector3dc)scratchPos).normalize();
            this.acceleration = new Vector3d((Vector3dc)nextVelocity).sub((Vector3dc)prevVelocity).normalize();
            this.velocity = nextVelocity;
            position.add((Vector3dc)nextVelocity);
            this.lastBall = new Ball(position.x, position.y, position.z, currentRadius);
            context.addBall(this.lastBall);
            if (this.stepsUntilNextSplit > 0 || this.totalSteps - this.currentStep < 4) continue;
            double sizeFactor = context.permuter.nextDouble() * 0.5 + 0.5;
            Vectors.setInSphere(scratchPos, (RandomGenerator)context.permuter, 1.0);
            Vector3d cross = new Vector3d((Vector3dc)this.velocity).cross((Vector3dc)scratchPos).normalize();
            Vector3d splitPosition = new Vector3d((Vector3dc)position).add((Vector3dc)cross);
            MegaTreeBranch split = new MegaTreeBranch(context, splitPosition.x, splitPosition.y, splitPosition.z, currentRadius * sizeFactor, Permuter.roundRandomlyI(context.permuter.nextLong(), (double)(this.totalSteps - this.currentStep) * sizeFactor), Permuter.roundRandomlyI(context.permuter.nextLong(), currentRadius * 4.0), nextVelocity, cross);
            context.addBranch(split);
            this.stepsUntilNextSplit = Permuter.roundRandomlyI(context.permuter.nextLong(), currentRadius * context.permuter.nextDouble(2.0, 3.0) + context.branchSparsity);
        }
    }

    public String toString() {
        return "MegaTreeBranch@" + Integer.toHexString(System.identityHashCode(this)) + ": { step: " + this.currentStep + " / " + this.totalSteps + ", velocity: " + String.valueOf(this.velocity) + ", acceleration: " + String.valueOf(this.acceleration) + ", at: " + String.valueOf(this.lastBall) + " }";
    }
}

