/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.trees;

import builderb0y.bigglobe.blocks.BigGlobeBlockTags;
import builderb0y.bigglobe.columns.scripted.ScriptedColumnLookup;
import builderb0y.bigglobe.dynamicRegistries.WoodPalette;
import builderb0y.bigglobe.features.BlockQueue;
import builderb0y.bigglobe.features.BlockQueueStructureWorldAccess;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomSources.RandomSource;
import builderb0y.bigglobe.trees.branches.BranchConfig;
import builderb0y.bigglobe.trees.branches.BranchesConfig;
import builderb0y.bigglobe.trees.branches.ThickBranchConfig;
import builderb0y.bigglobe.trees.decoration.BlockDecorator;
import builderb0y.bigglobe.trees.decoration.BranchDecorator;
import builderb0y.bigglobe.trees.decoration.DecoratorConfig;
import builderb0y.bigglobe.trees.decoration.TrunkDecorator;
import builderb0y.bigglobe.trees.decoration.TrunkLayerDecorator;
import builderb0y.bigglobe.trees.trunks.TrunkConfig;
import builderb0y.bigglobe.util.BlockState2ObjectMap;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import org.jetbrains.annotations.Nullable;

public class TreeGenerator {
    public final ScriptedColumnLookup columns;
    public final BlockQueueStructureWorldAccess worldQueue;
    public final Permuter random;
    public final WoodPalette palette;
    public final BlockState2ObjectMap<class_2680> groundReplacements;
    public final TrunkConfig trunk;
    @Nullable
    public final BranchesConfig branches;
    public final DecoratorConfig decorators;
    @Nullable
    public final RandomSource stumpThreshold;

    public TreeGenerator(ScriptedColumnLookup columns, class_5281 world, BlockQueue queue, Permuter random, WoodPalette palette, BlockState2ObjectMap<class_2680> groundReplacements, TrunkConfig trunk, @Nullable BranchesConfig branches, DecoratorConfig decorators, @Nullable RandomSource stumpThreshold) {
        this.columns = columns;
        this.worldQueue = queue.createWorld(world);
        this.random = random;
        this.palette = palette;
        this.groundReplacements = groundReplacements;
        this.trunk = trunk;
        this.branches = branches;
        this.decorators = decorators;
        this.stumpThreshold = stumpThreshold;
    }

    public boolean generate() {
        try {
            this.generateQueue();
        }
        catch (NotEnoughSpaceException fail) {
            return false;
        }
        this.worldQueue.commit();
        return true;
    }

    public void queueAndDecorateLeaf(class_2338 pos, class_2680 state) {
        this.worldQueue.setBlockState(pos, state);
        for (BlockDecorator decorator : this.decorators.leafBlock) {
            decorator.decorate(this, pos, state);
        }
    }

    public void generateQueue() throws NotEnoughSpaceException {
        this.generateTrunk();
        if (this.branches != null) {
            this.generateBranches();
        }
    }

    public void generateTrunk() throws NotEnoughSpaceException {
        int startY = this.trunk.startY;
        int height = this.trunk.height;
        if (startY + height >= HeightLimitViewVersions.getMaxY((class_5539)this.worldQueue)) {
            throw NotEnoughSpaceException.INSTANCE;
        }
        int offsetY = height;
        while (true) {
            if (offsetY < -4) {
                throw NotEnoughSpaceException.INSTANCE;
            }
            this.trunk.setOffset(offsetY);
            if (!this.generateTrunkLayer(startY + offsetY)) {
                if (offsetY <= 0) break;
                throw NotEnoughSpaceException.INSTANCE;
            }
            --offsetY;
        }
        for (TrunkDecorator decorator : this.decorators.trunk) {
            decorator.decorate(this, this.trunk);
        }
    }

    public boolean generateTrunkLayer(int y) throws NotEnoughSpaceException {
        BlockState2ObjectMap<class_2680> groundReplacements = this.groundReplacements;
        double radius = this.trunk.currentRadius;
        double radius2 = BigGlobeMath.squareD(radius);
        double centerX = this.trunk.currentX;
        double centerZ = this.trunk.currentZ;
        int minX = BigGlobeMath.ceilI(centerX - radius);
        int minZ = BigGlobeMath.ceilI(centerZ - radius);
        int maxX = BigGlobeMath.floorI(centerX + radius);
        int maxZ = BigGlobeMath.floorI(centerZ + radius);
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        mutablePos.method_33098(y);
        boolean placedAny = false;
        for (int blockX = minX; blockX <= maxX; ++blockX) {
            mutablePos.method_33097(blockX);
            double offsetX2 = BigGlobeMath.squareD((double)blockX - centerX);
            for (int blockZ = minZ; blockZ <= maxZ; ++blockZ) {
                if (!(offsetX2 + BigGlobeMath.squareD((double)blockZ - centerZ) < radius2)) continue;
                if (this.stumpThreshold != null && this.trunk.currentFracY >= this.stumpThreshold.get(this.columns.lookupColumn(blockX, blockZ), y, Permuter.permute(this.worldQueue.method_8412() ^ 0x224675B0BEF71707L, blockX, blockZ))) {
                    placedAny = true;
                    continue;
                }
                mutablePos.method_33099(blockZ);
                class_2680 existingState = this.worldQueue.getWorldState((class_2338)mutablePos);
                boolean workaroundForBushes = false;
                if (this.canTrunkReplace(existingState) || (workaroundForBushes = this.canTrunkReplaceBush(mutablePos, existingState))) {
                    class_2680 logState = this.palette.logState(this.random, class_2350.class_2351.field_11052);
                    if (workaroundForBushes) {
                        this.worldQueue.queue.queueReplacement((class_2338)mutablePos, existingState, logState);
                    } else {
                        this.worldQueue.setBlockState((class_2338)mutablePos, logState);
                    }
                    for (BlockDecorator decorator : this.decorators.trunkBlock) {
                        decorator.decorate(this, (class_2338)mutablePos, this.palette.logState(this.random, class_2350.class_2351.field_11052));
                    }
                    placedAny = true;
                    continue;
                }
                mutablePos.method_33098(y + 1);
                boolean logAboveToo = this.worldQueue.method_8320((class_2338)mutablePos) == this.palette.logState(this.random, class_2350.class_2351.field_11052);
                mutablePos.method_33098(y);
                if (!logAboveToo) continue;
                class_2680 replacement = (class_2680)groundReplacements.runtimeStates.get(existingState);
                if (replacement != null) {
                    if (replacement == existingState) continue;
                    this.worldQueue.queue.queueReplacement((class_2338)mutablePos, existingState, replacement);
                    continue;
                }
                if (!this.trunk.requireValidGround) continue;
                throw NotEnoughSpaceException.INSTANCE;
            }
        }
        if (placedAny) {
            for (TrunkLayerDecorator decorator : this.decorators.trunkLayer) {
                decorator.decorate(this, this.trunk, y);
            }
        }
        return placedAny;
    }

    public void generateBranches() throws NotEnoughSpaceException {
        int count = this.branches.branchCount;
        for (int branchIndex = 0; branchIndex < count; ++branchIndex) {
            double branchFracY = (double)branchIndex / (double)count;
            double trunkFracY = Interpolator.mixLinear(this.branches.startFracY, 1.0, branchFracY);
            this.trunk.setFrac(trunkFracY);
            this.branches.updateBranch(this, branchIndex);
            this.generateBranch();
        }
    }

    public void generateBranch() throws NotEnoughSpaceException {
        if (this.branches.thickBranches) {
            this.generateThickBranch();
        } else {
            this.generateThinBranch();
        }
    }

    public void generateThinBranch() throws NotEnoughSpaceException {
        BranchConfig branch = this.branches.currentBranch;
        if (!(branch.length > 0.0)) {
            return;
        }
        double absDX = Math.abs(branch.nx);
        double absDZ = Math.abs(branch.nz);
        class_2680 logState = this.palette.woodState(this.random, absDZ > absDX ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048);
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (double offset = this.random.nextDouble(); offset <= branch.length; offset += 1.0) {
            branch.setLength(this, offset);
            this.generateBranchBlock((class_2338)mutablePos.method_10102(branch.currentX, branch.currentY, branch.currentZ), logState);
        }
        for (BranchDecorator decorator : this.decorators.branch) {
            decorator.decorate(this, branch);
        }
    }

    public void generateThickBranch() throws NotEnoughSpaceException {
        ThickBranchConfig branch = (ThickBranchConfig)this.branches.currentBranch;
        if (!(branch.length > 0.0)) {
            return;
        }
        double absDX = Math.abs(branch.nx);
        double absDZ = Math.abs(branch.nz);
        branch.setFracLength(this, 0.0);
        double x1 = branch.currentX;
        double z1 = branch.currentZ;
        double r1 = branch.currentRadius;
        branch.setFracLength(this, 1.0);
        double x2 = branch.currentX;
        double z2 = branch.currentZ;
        double r2 = branch.currentRadius;
        int minX = BigGlobeMath.floorI(Math.min(x1 - r1, x2 - r2)) + 1;
        int minZ = BigGlobeMath.floorI(Math.min(z1 - r1, z2 - r2)) + 1;
        int maxX = BigGlobeMath.ceilI(Math.max(x1 + r1, x2 + r2)) - 1;
        int maxZ = BigGlobeMath.ceilI(Math.max(z1 + r1, z2 + r2)) - 1;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int x = minX; x <= maxX; ++x) {
            mutablePos.method_33097(x);
            for (int z = minZ; z <= maxZ; ++z) {
                int startY;
                mutablePos.method_33099(z);
                branch.project(this, x, z);
                double xzLengthSquared = BigGlobeMath.squareD((double)x - branch.currentX, (double)z - branch.currentZ);
                double radiusSquared = BigGlobeMath.squareD(branch.currentRadius);
                int y = startY = BigGlobeMath.floorI(branch.currentY);
                while (xzLengthSquared + BigGlobeMath.squareD((double)y - branch.currentY) < radiusSquared) {
                    mutablePos.method_33098(y);
                    this.generateBranchBlock((class_2338)mutablePos, this.palette.woodState(this.random, absDZ > absDX ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
                    --y;
                }
                y = startY + 1;
                while (xzLengthSquared + BigGlobeMath.squareD((double)y - branch.currentY) < radiusSquared) {
                    mutablePos.method_33098(y);
                    this.generateBranchBlock((class_2338)mutablePos, this.palette.woodState(this.random, absDZ > absDX ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
                    ++y;
                }
            }
        }
        for (BranchDecorator decorator : this.decorators.branch) {
            decorator.decorate(this, branch);
        }
    }

    public void generateBranchBlock(class_2338 pos, class_2680 branchState) throws NotEnoughSpaceException {
        if (this.canBranchReplace(this.worldQueue.getWorldState(pos))) {
            if (this.canBranchReplace(this.worldQueue.queue.getBlockState(pos))) {
                this.worldQueue.setBlockState(pos, branchState);
                for (BlockDecorator decorator : this.decorators.branchBlock) {
                    decorator.decorate(this, pos, branchState);
                }
            }
        } else {
            throw NotEnoughSpaceException.INSTANCE;
        }
    }

    public boolean canTrunkReplace(class_2680 existingState) {
        if (existingState.method_26227().method_15771()) {
            return this.trunk.canGenerateInLiquid;
        }
        return BlockStateVersions.isReplaceable(existingState) || existingState.method_26164(BigGlobeBlockTags.TREE_TRUNK_REPLACEABLES);
    }

    public boolean canTrunkReplaceBush(class_2338.class_2339 mutablePos, class_2680 existingState) {
        if (this.palette.woodBlocks().contains(existingState.method_41520())) {
            int oldY = mutablePos.method_10264();
            mutablePos.method_33098(oldY - 1);
            existingState = this.worldQueue.getWorldState((class_2338)mutablePos);
            mutablePos.method_33098(oldY);
            return this.groundReplacements.runtimeStates.containsKey(existingState);
        }
        return false;
    }

    public boolean canBranchReplace(class_2680 existingState) {
        return BlockStateVersions.isReplaceable(existingState) || existingState.method_26164(BigGlobeBlockTags.TREE_BRANCH_REPLACEABLES);
    }

    public boolean canLeavesReplace(class_2680 existingState) {
        if (existingState.method_26227().method_15771()) {
            return false;
        }
        return BlockStateVersions.isReplaceable(existingState) || existingState.method_26164(BigGlobeBlockTags.TREE_LEAF_REPLACEABLES);
    }

    public boolean canShelfReplace(class_2680 existingState) {
        if (existingState.method_26227().method_15771()) {
            return false;
        }
        return BlockStateVersions.isReplaceable(existingState) || existingState.method_26164(BigGlobeBlockTags.TREE_SHELF_REPLACEABLES);
    }

    public static class NotEnoughSpaceException
    extends Exception {
        public static final NotEnoughSpaceException INSTANCE = new NotEnoughSpaceException();

        public NotEnoughSpaceException() {
            super(null, null, false, false);
        }
    }
}

