/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.trees.branches;

import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.trees.TreeGenerator;
import net.minecraft.class_3532;

public class BranchConfig {
    public final double angle;
    public final double length;
    public final double nx;
    public final double nz;
    public final Permuter permuter;
    public final long seed;
    public double currentLength;
    public double currentFracLength;
    public double currentX;
    public double currentY;
    public double currentZ;

    public BranchConfig(double angle, double length, long seed) {
        this.angle = angle;
        this.length = length;
        this.nx = Math.cos(angle);
        this.nz = Math.sin(angle);
        this.permuter = new Permuter(0L);
        this.seed = seed;
    }

    public void setBothLengths(TreeGenerator generator, double length, double fracLength) {
        this.currentLength = length;
        this.currentFracLength = fracLength;
        this.permuter.setSeed(this.seed);
        this.currentX = generator.trunk.currentX + this.nx * length;
        this.currentY = generator.trunk.currentY + generator.branches.heightGetter.evaluate(fracLength, this.permuter) * length;
        this.currentZ = generator.trunk.currentZ + this.nz * length;
    }

    public void setFracLength(TreeGenerator generator, double fracLength) {
        fracLength = class_3532.method_15350((double)fracLength, (double)0.0, (double)1.0);
        this.setBothLengths(generator, fracLength * this.length, fracLength);
    }

    public void setLength(TreeGenerator generator, double length) {
        length = class_3532.method_15350((double)length, (double)0.0, (double)this.length);
        this.setBothLengths(generator, length, length / this.length);
    }
}

