/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.random.RandomGenerator;
import java.util.stream.Collector;

public class RandomSelector<T> {
    public final RandomGenerator random;
    public T value;
    public double currentChance;

    public RandomSelector(RandomGenerator random) {
        this.random = random;
    }

    public void accept(T newValue, double newChance) {
        if (newChance > 0.0) {
            double d;
            this.currentChance += newChance;
            if (this.random.nextDouble(d) < newChance) {
                this.value = newValue;
            }
        }
    }

    public void accept(RandomSelector<? extends T> that) {
        this.accept(that.value, that.currentChance);
    }

    public static <T_Merged, T_Element> Collector<T_Merged, RandomSelector<T_Element>, T_Element> collector(RandomGenerator random, Function<? super T_Merged, ? extends T_Element> elementGetter, ToDoubleFunction<? super T_Merged> weightGetter) {
        return Collector.of(() -> new RandomSelector(random), (selector, merged) -> selector.accept(elementGetter.apply((Object)merged), weightGetter.applyAsDouble((Object)merged)), (selector1, selector2) -> {
            selector1.accept((RandomSelector)selector2);
            return selector1;
        }, selector -> selector.value, Collector.Characteristics.UNORDERED);
    }

    public static <T_Element> Collector<T_Element, RandomSelector<T_Element>, T_Element> uniformWeightCollector(RandomGenerator random) {
        return RandomSelector.collector(random, Function.identity(), element -> 1.0);
    }
}

