/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.compat.DistantHorizonsCompat;
import builderb0y.bigglobe.mixinInterfaces.MutableBlockEntityType;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2495;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WorldUtil {
    public static void setBlockState(class_1936 world, class_2338 pos, class_2680 state, int flags) {
        boolean special;
        boolean bl = special = world instanceof class_3233 && state.method_31709();
        if (special) {
            pos = pos.method_10062();
        }
        world.method_8652(pos, state, flags);
        if (special) {
            class_2586 blockEntity = WorldUtil.getBlockEntity((class_1922)world, pos, class_2586.class);
            class_2791 chunk = world.method_22350(pos);
            chunk.method_12041(pos);
            if (blockEntity != null) {
                chunk.method_12007(blockEntity);
            }
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable class_2338.class_2339 findNonReplaceableGround(class_1922 world, class_2338 start) {
        return WorldUtil.findNonReplaceableGroundMutable(world, start.method_25503());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable class_2338.class_2339 findNonReplaceableGroundMutable(class_1922 world, class_2338.class_2339 mutablePos) {
        if (world instanceof class_4538) {
            class_4538 worldView = (class_4538)world;
            world = worldView.method_22350((class_2338)mutablePos);
        }
        while (!world.method_31606((class_2338)mutablePos)) {
            if (!BlockStateVersions.isReplaceable(world.method_8320((class_2338)mutablePos))) {
                return mutablePos;
            }
            mutablePos.method_33098(mutablePos.method_10264() - 1);
        }
        return null;
    }

    @Nullable
    public static <B> B getBlockEntity(class_1922 world, class_2338 pos, Class<B> clazz) {
        if (DistantHorizonsCompat.isOnDistantHorizonThread()) {
            return null;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (clazz.isInstance(blockEntity)) {
            return (B)blockEntity;
        }
        BigGlobeMod.LOGGER.warn("Expected " + String.valueOf(clazz) + " at " + String.valueOf(pos) + " in " + String.valueOf(world) + ", but got " + String.valueOf(blockEntity) + " instead.");
        return null;
    }

    @Nullable
    public static <B extends class_2586> B getBlockEntity(class_1922 world, class_2338 pos, class_2591<B> type) {
        if (DistantHorizonsCompat.isOnDistantHorizonThread()) {
            return null;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null && blockEntity.method_11017() == type) {
            return (B)blockEntity;
        }
        class_5321 id = class_7923.field_41181.method_29113(type).orElse(null);
        String name = id != null ? id.toString() : "(unregistered: " + String.valueOf(type) + " for block(s): " + String.valueOf(((MutableBlockEntityType)type).bigglobe_getBlocks()) + ")";
        BigGlobeMod.LOGGER.warn("Expected " + name + " at " + String.valueOf(pos) + " in " + String.valueOf(world) + ", but got " + String.valueOf(blockEntity) + " instead.");
        return null;
    }

    public static class_3341 chunkBox(class_1923 pos, class_5539 height) {
        return new class_3341(pos.method_8326(), HeightLimitViewVersions.getMinY(height), pos.method_8328(), pos.method_8327(), HeightLimitViewVersions.getMaxY(height) - 1, pos.method_8329());
    }

    public static class_3341 chunkBox(class_2791 chunk) {
        return WorldUtil.chunkBox(chunk.method_12004(), (class_5539)chunk);
    }

    public static class_3341 surroundingChunkBox(class_1923 pos, class_5539 height) {
        return new class_3341(pos.field_9181 - 1 << 4, HeightLimitViewVersions.getMinY(height), pos.field_9180 - 1 << 4, pos.field_9181 + 1 << 4 | 0xF, HeightLimitViewVersions.getMaxY(height) - 1, pos.field_9180 + 1 << 4 | 0xF);
    }

    public static class_3341 surroundingChunkBox(class_2791 chunk) {
        return WorldUtil.surroundingChunkBox(chunk.method_12004(), (class_5539)chunk);
    }

    public static class_3341 createBlockBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int tmp;
        if (maxX < minX) {
            tmp = maxX;
            maxX = minX;
            minX = tmp;
        }
        if (maxY < minY) {
            tmp = maxY;
            maxY = minY;
            minY = tmp;
        }
        if (maxZ < minZ) {
            tmp = maxZ;
            maxZ = minZ;
            minZ = tmp;
        }
        return new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static class_3341 union(class_3341 box1, class_3341 box2) {
        return new class_3341(Math.min(box1.method_35415(), box2.method_35415()), Math.min(box1.method_35416(), box2.method_35416()), Math.min(box1.method_35417(), box2.method_35417()), Math.max(box1.method_35418(), box2.method_35418()), Math.max(box1.method_35419(), box2.method_35419()), Math.max(box1.method_35420(), box2.method_35420()));
    }

    @Nullable
    public static class_3341 intersection(class_3341 box1, class_3341 box2) {
        int minX = Math.max(box1.method_35415(), box2.method_35415());
        int minY = Math.max(box1.method_35416(), box2.method_35416());
        int minZ = Math.max(box1.method_35417(), box2.method_35417());
        int maxX = Math.min(box1.method_35418(), box2.method_35418());
        int maxY = Math.min(box1.method_35419(), box2.method_35419());
        int maxZ = Math.min(box1.method_35420(), box2.method_35420());
        return maxX >= minX && maxY >= minY && maxZ >= minZ ? new class_3341(minX, minY, minZ, maxX, maxY, maxZ) : null;
    }

    public static class_2495 blockBoxToNbt(class_3341 box) {
        return new class_2495(new int[]{box.method_35415(), box.method_35416(), box.method_35417(), box.method_35418(), box.method_35419(), box.method_35420()});
    }

    public static class_3341 blockBoxFromIntArray(int[] array) {
        if (array.length == 6) {
            return new class_3341(array[0], array[1], array[2], array[3], array[4], array[5]);
        }
        throw new IllegalArgumentException("Serialized BlockBox is of wrong length: Expected 6, got " + array.length);
    }

    public static boolean isReplaceableNonFluid(class_2680 state) {
        return BlockStateVersions.isReplaceable(state) && state.method_26227().method_15769();
    }

    public static boolean isReplaceableNonFluid(class_1922 world, class_2338 pos) {
        return WorldUtil.isReplaceableNonFluid(world.method_8320(pos));
    }
}

