/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util.coordinators;

import builderb0y.bigglobe.util.Symmetry;
import builderb0y.bigglobe.util.coordinators.AbstractLimitAreaCoordinator;
import builderb0y.bigglobe.util.coordinators.AbstractTranslateCoordinator;
import builderb0y.bigglobe.util.coordinators.ChunkCoordinator;
import builderb0y.bigglobe.util.coordinators.CombinedCoordinator;
import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.DropCoordinator;
import builderb0y.bigglobe.util.coordinators.StackCoordinator;
import builderb0y.bigglobe.util.coordinators.SymmetricCoordinator;
import builderb0y.bigglobe.util.coordinators.WorldCoordinator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3610;
import net.minecraft.class_5281;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface Coordinator {
    public static final Logger LOGGER = LogManager.getLogger((String)"Big Globe/Coordinator");

    public static Coordinator forWorld(class_5281 world, int setBlockFlags) {
        return new WorldCoordinator(world, setBlockFlags);
    }

    public static Coordinator forChunk(class_2791 chunk) {
        return new ChunkCoordinator(chunk);
    }

    public static Coordinator combine(Coordinator ... coordinators) {
        for (Coordinator coordinator : coordinators) {
            if (!(coordinator instanceof CombinedCoordinator) && !(coordinator instanceof DropCoordinator)) continue;
            coordinators = (Coordinator[])Arrays.stream(coordinators).flatMap(nested -> nested instanceof CombinedCoordinator ? Arrays.stream(((CombinedCoordinator)nested).delegates) : Stream.of(nested)).filter(nested -> !(nested instanceof DropCoordinator)).distinct().toArray(Coordinator[]::new);
            break;
        }
        return switch (coordinators.length) {
            case 0 -> Coordinator.warnDrop("coordinators array was empty, or contained only drops");
            case 1 -> coordinators[0];
            default -> new CombinedCoordinator(coordinators);
        };
    }

    public static Coordinator warnDrop(String reason) {
        LOGGER.warn("A Coordinator operation resulted in dropping all coordinates: ", (Throwable)new IllegalArgumentException(reason));
        return DropCoordinator.INSTANCE;
    }

    public void genericPos(int var1, int var2, int var3, CoordinateFunctions.CoordinatorRunnable var4);

    public <A> void genericPos(int var1, int var2, int var3, A var4, CoordinateFunctions.CoordinatorConsumer<A> var5);

    public <A, B> void genericPos(int var1, int var2, int var3, A var4, B var5, CoordinateFunctions.CoordinatorBiConsumer<A, B> var6);

    public <A, B, C> void genericPos(int var1, int var2, int var3, A var4, B var5, C var6, CoordinateFunctions.CoordinatorTriConsumer<A, B, C> var7);

    default public void genericCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinatorRunnable callback) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    callback.run(this, x, y, z);
                }
            }
        }
    }

    default public <A> void genericCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, A arg, CoordinateFunctions.CoordinatorConsumer<A> callback) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    callback.run(this, x, y, z, arg);
                }
            }
        }
    }

    default public <A, B> void genericCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, A arg1, B arg2, CoordinateFunctions.CoordinatorBiConsumer<A, B> callback) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    callback.run(this, x, y, z, arg1, arg2);
                }
            }
        }
    }

    default public <A, B, C> void genericCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, A arg1, B arg2, C arg3, CoordinateFunctions.CoordinatorTriConsumer<A, B, C> callback) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    callback.run(this, x, y, z, arg1, arg2, arg3);
                }
            }
        }
    }

    default public void genericLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.LineRunnable action) {
        if (length <= 0) {
            return;
        }
        action.run(this, x, y, z, 0);
        for (int index = 1; index < length; ++index) {
            action.run(this, x += dx, y += dy, z += dz, index);
        }
    }

    default public <T> void genericLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.LineConsumer<T> action, T ... args) {
        if (args == null) {
            return;
        }
        int length = args.length;
        if (length == 0) {
            return;
        }
        if (args[0] != null) {
            action.run(this, x, y, z, 0, args[0]);
        }
        for (int index = 1; index < length; ++index) {
            x += dx;
            y += dy;
            z += dz;
            if (args[index] == null) continue;
            action.run(this, x, y, z, index, args[index]);
        }
    }

    default public <A> void genericLine(int x, int y, int z, int dx, int dy, int dz, int length, A arg, CoordinateFunctions.LineConsumer<A> callback) {
        if (length <= 0) {
            return;
        }
        callback.run(this, x, y, z, 0, arg);
        for (int index = 1; index < length; ++index) {
            callback.run(this, x += dx, y += dy, z += dz, index, arg);
        }
    }

    default public <A, B> void genericLine(int x, int y, int z, int dx, int dy, int dz, int length, A arg1, B arg2, CoordinateFunctions.LineBiConsumer<A, B> callback) {
        if (length <= 0) {
            return;
        }
        callback.run(this, x, y, z, 0, arg1, arg2);
        for (int index = 1; index < length; ++index) {
            callback.run(this, x += dx, y += dy, z += dz, index, arg1, arg2);
        }
    }

    default public <A, B, C> void genericLine(int x, int y, int z, int dx, int dy, int dz, int length, A arg1, B arg2, C arg3, CoordinateFunctions.LineTriConsumer<A, B, C> callback) {
        if (length <= 0) {
            return;
        }
        callback.run(this, x, y, z, 0, arg1, arg2, arg3);
        for (int index = 1; index < length; ++index) {
            callback.run(this, x += dx, y += dy, z += dz, index, arg1, arg2, arg3);
        }
    }

    default public void getCoordinates(int x, int y, int z, CoordinateFunctions.CoordinateRunnable action) {
        this.genericPos(x, y, z, action, CoordinateFunctions.CoordinatorConsumer.getCoordinates());
    }

    default public void getCoordinatesCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinateRunnable action) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, action, CoordinateFunctions.CoordinatorConsumer.getCoordinates());
    }

    default public void getCoordinatesLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.CoordinateRunnable action) {
        this.genericLine(x, y, z, dx, dy, dz, length, action, CoordinateFunctions.LineConsumer.getCoordinates());
    }

    default public void getCoordinatesLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.CoordinateRunnable ... actions) {
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.getCoordinates(), actions);
    }

    default public Stream<class_2338> streamCoordinates(int x, int y, int z) {
        Stream.Builder builder = Stream.builder();
        this.getCoordinates(x, y, z, pos -> builder.accept(pos.method_10062()));
        return builder.build();
    }

    default public Stream<class_2338> streamCoordinatesCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Stream.Builder builder = Stream.builder();
        this.getCoordinatesCuboid(minX, minY, minZ, maxX, maxY, maxZ, pos -> builder.accept(pos.method_10062()));
        return builder.build();
    }

    default public Stream<class_2338> streamCoordinatesLine(int x, int y, int z, int dx, int dy, int dz, int length) {
        Stream.Builder builder = Stream.builder();
        this.getCoordinatesLine(x, y, z, dx, dy, dz, length, (class_2338.class_2339 pos) -> builder.accept(pos.method_10062()));
        return builder.build();
    }

    default public void getBlockState(int x, int y, int z, CoordinateFunctions.CoordinateConsumer<class_2680> action) {
        this.genericPos(x, y, z, action, CoordinateFunctions.CoordinatorConsumer.getBlockState());
    }

    default public void getBlockStateCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinateConsumer<class_2680> action) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, action, CoordinateFunctions.CoordinatorConsumer.getBlockState());
    }

    default public void getBlockStateLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.CoordinateConsumer<class_2680> action) {
        this.genericLine(x, y, z, dx, dy, dz, length, action, CoordinateFunctions.LineConsumer.getBlockState());
    }

    default public void getBlockStateLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.CoordinateConsumer<class_2680> ... actions) {
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.getBlockState(), actions);
    }

    default public void getFluidState(int x, int y, int z, CoordinateFunctions.CoordinateConsumer<class_3610> action) {
        this.genericPos(x, y, z, action, CoordinateFunctions.CoordinatorConsumer.getFluidState());
    }

    default public void getFluidStateCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinateConsumer<class_3610> action) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, action, CoordinateFunctions.CoordinatorConsumer.getFluidState());
    }

    default public void getFluidStateLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.CoordinateConsumer<class_3610> action) {
        this.genericLine(x, y, z, dx, dy, dz, length, action, CoordinateFunctions.LineConsumer.getFluidState());
    }

    default public void getFluidStateLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.CoordinateConsumer<class_3610> ... actions) {
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.getFluidState(), actions);
    }

    default public void getBlockEntity(int x, int y, int z, CoordinateFunctions.CoordinateConsumer<class_2586> action) {
        this.genericPos(x, y, z, action, CoordinateFunctions.CoordinatorConsumer.getBlockEntity());
    }

    default public void getBlockEntityCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinateConsumer<class_2586> action) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, action, CoordinateFunctions.CoordinatorConsumer.getBlockEntity());
    }

    default public void getBlockEntityLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.CoordinateConsumer<class_2586> action) {
        this.genericLine(x, y, z, dx, dy, dz, length, action, CoordinateFunctions.LineConsumer.getBlockEntity());
    }

    default public void getBlockEntityLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.CoordinateConsumer<class_2586> ... actions) {
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.getBlockEntity(), actions);
    }

    default public <B> void getBlockEntity(int x, int y, int z, Class<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        this.genericPos(x, y, z, blockEntityType, action, CoordinateFunctions.CoordinatorBiConsumer.getBlockEntityByClass());
    }

    default public <B> void getBlockEntityCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Class<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, blockEntityType, action, CoordinateFunctions.CoordinatorBiConsumer.getBlockEntityByClass());
    }

    default public <B> void getBlockEntityLine(int x, int y, int z, int dx, int dy, int dz, int length, Class<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        this.genericLine(x, y, z, dx, dy, dz, length, blockEntityType, action, CoordinateFunctions.LineBiConsumer.getBlockEntitiesByClass());
    }

    default public <B extends class_2586> void getBlockEntity(int x, int y, int z, class_2591<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        this.genericPos(x, y, z, blockEntityType, action, CoordinateFunctions.CoordinatorBiConsumer.getBlockEntityByType());
    }

    default public <B extends class_2586> void getBlockEntityCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2591<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, blockEntityType, action, CoordinateFunctions.CoordinatorBiConsumer.getBlockEntityByType());
    }

    default public <B extends class_2586> void getBlockEntityLine(int x, int y, int z, int dx, int dy, int dz, int length, class_2591<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        this.genericLine(x, y, z, dx, dy, dz, length, blockEntityType, action, CoordinateFunctions.LineBiConsumer.getBlockEntitiesByType());
    }

    default public void getChunk(int x, int y, int z, CoordinateFunctions.CoordinateConsumer<class_2791> action) {
        this.genericPos(x, y, z, action, CoordinateFunctions.CoordinatorConsumer.getChunk());
    }

    default public void getChunkCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinateConsumer<class_2791> action) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, action, CoordinateFunctions.CoordinatorConsumer.getChunk());
    }

    default public void getChunkLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.CoordinateConsumer<class_2791> action) {
        this.genericLine(x, y, z, dx, dy, dz, length, action, CoordinateFunctions.LineConsumer.getChunk());
    }

    default public void getChunkLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.CoordinateConsumer<class_2791> ... actions) {
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.getChunk(), actions);
    }

    default public void setBlockState(int x, int y, int z, class_2680 state) {
        if (state == null) {
            return;
        }
        this.genericPos(x, y, z, state, CoordinateFunctions.CoordinatorConsumer.setBlockState());
    }

    default public void setBlockStateCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 state) {
        if (state == null) {
            return;
        }
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, state, CoordinateFunctions.CoordinatorConsumer.setBlockState());
    }

    default public void setBlockStateLine(int x, int y, int z, int dx, int dy, int dz, int length, class_2680 state) {
        if (state == null) {
            return;
        }
        this.genericLine(x, y, z, dx, dy, dz, length, state, CoordinateFunctions.LineConsumer.setBlockState());
    }

    default public void setBlockStateLine(int x, int y, int z, int dx, int dy, int dz, class_2680 ... states) {
        if (states == null || states.length == 0) {
            return;
        }
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.setBlockState(), states);
    }

    default public <B> void setBlockStateAndBlockEntity(int x, int y, int z, class_2680 state, Class<B> blockEntityClass, CoordinateFunctions.CoordinateConsumer<B> action) {
        if (state == null) {
            return;
        }
        this.genericPos(x, y, z, state, blockEntityClass, action, CoordinateFunctions.CoordinatorTriConsumer.setBlockStateAndBlockEntityByClass());
    }

    default public <B> void setBlockStateAndBlockEntityCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 state, Class<B> blockEntityClass, CoordinateFunctions.CoordinateConsumer<B> action) {
        if (state == null) {
            return;
        }
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, state, blockEntityClass, action, CoordinateFunctions.CoordinatorTriConsumer.setBlockStateAndBlockEntityByClass());
    }

    default public <B> void setBlockStateAndBlockEntityLine(int x, int y, int z, int dx, int dy, int dz, int length, class_2680 state, Class<B> blockEntityClass, CoordinateFunctions.CoordinateConsumer<B> action) {
        if (state == null) {
            return;
        }
        this.genericLine(x, y, z, dx, dy, dz, length, state, blockEntityClass, action, CoordinateFunctions.LineTriConsumer.setBlockStateAndBlockEntityByClass());
    }

    default public <B extends class_2586> void setBlockStateAndBlockEntity(int x, int y, int z, class_2680 state, class_2591<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        this.genericPos(x, y, z, state, blockEntityType, action, CoordinateFunctions.CoordinatorTriConsumer.setBlockStateAndBlockEntityByType());
    }

    default public <B extends class_2586> void setBlockStateAndBlockEntityCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 state, class_2591<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        if (state == null) {
            return;
        }
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, state, blockEntityType, action, CoordinateFunctions.CoordinatorTriConsumer.setBlockStateAndBlockEntityByType());
    }

    default public <B extends class_2586> void setBlockStateAndBlockEntityLine(int x, int y, int z, int dx, int dy, int dz, int length, class_2680 state, class_2591<B> blockEntityType, CoordinateFunctions.CoordinateConsumer<B> action) {
        if (state == null) {
            return;
        }
        this.genericLine(x, y, z, dx, dy, dz, length, state, blockEntityType, action, CoordinateFunctions.LineTriConsumer.setBlockStateAndBlockEntityByType());
    }

    default public void setBlockState(int x, int y, int z, CoordinateFunctions.CoordinateSupplier<class_2680> supplier) {
        this.genericPos(x, y, z, supplier, CoordinateFunctions.CoordinatorConsumer.setBlockState_supplier());
    }

    default public void setBlockStateCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinateSupplier<class_2680> supplier) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, supplier, CoordinateFunctions.CoordinatorConsumer.setBlockState_supplier());
    }

    default public void setBlockStateLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.CoordinateSupplier<class_2680> supplier) {
        this.genericLine(x, y, z, dx, dy, dz, length, supplier, CoordinateFunctions.LineConsumer.setBlockState_supplier());
    }

    default public void setBlockStateLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.CoordinateSupplier<class_2680> ... suppliers) {
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.setBlockState_supplier(), suppliers);
    }

    default public void modifyBlockState(int x, int y, int z, CoordinateFunctions.CoordinateUnaryOperator<class_2680> mapper) {
        this.genericPos(x, y, z, mapper, CoordinateFunctions.CoordinatorConsumer.modifyBlockState());
    }

    default public void modifyBlockStateCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinateUnaryOperator<class_2680> mapper) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, mapper, CoordinateFunctions.CoordinatorConsumer.modifyBlockState());
    }

    default public void modifyBlockStateLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.CoordinateUnaryOperator<class_2680> mapper) {
        this.genericLine(x, y, z, dx, dy, dz, length, mapper, CoordinateFunctions.LineConsumer.modifyBlockState());
    }

    default public void modifyBlockStateLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.CoordinateUnaryOperator<class_2680> ... mappers) {
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.modifyBlockState(), mappers);
    }

    default public <E extends class_1297> void getEntities(int x, int y, int z, Class<E> entityType, CoordinateFunctions.CoordinateSupplier<class_238> boxSupplier, CoordinateFunctions.CoordinateConsumer<List<E>> entityAction) {
        this.genericPos(x, y, z, entityType, boxSupplier, entityAction, CoordinateFunctions.CoordinatorTriConsumer.getEntities());
    }

    default public <E extends class_1297> void getEntitiesCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Class<E> entityType, CoordinateFunctions.CoordinateSupplier<class_238> boxSupplier, CoordinateFunctions.CoordinateConsumer<List<E>> entityAction) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, entityType, boxSupplier, entityAction, CoordinateFunctions.CoordinatorTriConsumer.getEntities());
    }

    default public <E extends class_1297> void getEntitiesLine(int x, int y, int z, int dx, int dy, int dz, int length, Class<E> entityType, CoordinateFunctions.CoordinateSupplier<class_238> boxSupplier, CoordinateFunctions.CoordinateConsumer<List<E>> entityAction) {
        this.genericLine(x, y, z, dx, dy, dz, length, entityType, boxSupplier, entityAction, CoordinateFunctions.LineTriConsumer.getEntities());
    }

    default public void addEntity(int x, int y, int z, CoordinateFunctions.CoordinateFunction<class_3218, class_1297> supplier) {
        this.genericPos(x, y, z, supplier, CoordinateFunctions.CoordinatorConsumer.addEntity());
    }

    default public void addEntityCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, CoordinateFunctions.CoordinateFunction<class_3218, class_1297> supplier) {
        this.genericCuboid(minX, minY, minZ, maxX, maxY, maxZ, supplier, CoordinateFunctions.CoordinatorConsumer.addEntity());
    }

    default public void addEntityLine(int x, int y, int z, int dx, int dy, int dz, int length, CoordinateFunctions.CoordinateFunction<class_3218, class_1297> supplier) {
        this.genericLine(x, y, z, dx, dy, dz, length, supplier, CoordinateFunctions.LineConsumer.addEntity());
    }

    default public void addEntityLine(int x, int y, int z, int dx, int dy, int dz, CoordinateFunctions.CoordinateFunction<class_3218, class_1297> ... suppliers) {
        this.genericLine(x, y, z, dx, dy, dz, CoordinateFunctions.LineConsumer.addEntity(), suppliers);
    }

    default public Coordinator translate(int offsetX, int offsetY, int offsetZ) {
        if (offsetX == 0 && offsetY == 0 && offsetZ == 0) {
            return this;
        }
        return new AbstractTranslateCoordinator.TranslateCoordinator(this, offsetX, offsetY, offsetZ);
    }

    default public Coordinator translate(class_2382 offset, boolean lazy) {
        if (lazy) {
            return new AbstractTranslateCoordinator.LazyTranslateCoordinator(this, offset);
        }
        return this.translate(offset.method_10263(), offset.method_10264(), offset.method_10260());
    }

    default public Coordinator multiTranslate(int ... offsets) {
        if (offsets.length == 0) {
            return Coordinator.warnDrop("no offsets provided");
        }
        if (offsets.length == 3) {
            return this.translate(offsets[0], offsets[1], offsets[2]);
        }
        int count = offsets.length / 3;
        if (offsets.length != (count << 1) + count) {
            throw new IllegalArgumentException("offsets length must be multiple of 3");
        }
        return Coordinator.combine((Coordinator[])IntStream.range(0, count).map(index -> index + (index << 1)).mapToObj(base -> this.translate(offsets[base], offsets[base + 1], offsets[base + 2])).distinct().toArray(Coordinator[]::new));
    }

    default public Coordinator multiTranslate(class_2382 ... offsets) {
        if (offsets.length == 0) {
            return Coordinator.warnDrop("no offsets provided");
        }
        if (offsets.length == 1) {
            return this.translate(offsets[0], false);
        }
        return Coordinator.combine((Coordinator[])Arrays.stream(offsets).map(offset -> this.translate((class_2382)offset, false)).distinct().toArray(Coordinator[]::new));
    }

    default public Coordinator symmetric(Symmetry s1) {
        return SymmetricCoordinator.create(this, s1.flag());
    }

    default public Coordinator symmetric(Symmetry s1, Symmetry s2) {
        return SymmetricCoordinator.create(this, s1.flag() | s2.flag());
    }

    default public Coordinator symmetric(Symmetry s1, Symmetry s2, Symmetry s3, Symmetry s4) {
        return SymmetricCoordinator.create(this, s1.flag() | s2.flag() | s3.flag() | s4.flag());
    }

    default public Coordinator symmetric(Symmetry ... symmetries) {
        int flags = 0;
        for (Symmetry symmetry : symmetries) {
            flags |= symmetry.flag();
        }
        return SymmetricCoordinator.create(this, flags);
    }

    default public Coordinator rotate1x(class_2470 rotation) {
        return this.symmetric(Symmetry.of(rotation));
    }

    default public Coordinator rotate4x90() {
        return this.symmetric(Symmetry.IDENTITY, Symmetry.ROTATE_90, Symmetry.ROTATE_180, Symmetry.ROTATE_270);
    }

    default public Coordinator rotate2x180() {
        return this.symmetric(Symmetry.IDENTITY, Symmetry.ROTATE_180);
    }

    default public Coordinator flip1X() {
        return this.symmetric(Symmetry.FLIP_0);
    }

    default public Coordinator flip1Z() {
        return this.symmetric(Symmetry.FLIP_90);
    }

    default public Coordinator flip2X() {
        return this.symmetric(Symmetry.IDENTITY, Symmetry.FLIP_0);
    }

    default public Coordinator flip2Z() {
        return this.symmetric(Symmetry.IDENTITY, Symmetry.FLIP_90);
    }

    default public Coordinator flip4XZ() {
        return this.symmetric(Symmetry.IDENTITY, Symmetry.FLIP_90, Symmetry.FLIP_0, Symmetry.ROTATE_180);
    }

    default public Coordinator stack(int dx, int dy, int dz, int count) {
        if (count <= 0) {
            return Coordinator.warnDrop("Count was less than or equal to 0");
        }
        if (count == 1 || dx == 0 && dy == 0 && dz == 0) {
            return this;
        }
        return new StackCoordinator(this, dx, dy, dz, count);
    }

    default public Coordinator limitArea(CoordinateFunctions.CoordinateBooleanSupplier predicate) {
        return new AbstractLimitAreaCoordinator.LimitArea(this, predicate);
    }

    default public Coordinator inBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (maxX >= minX && maxZ >= minZ && maxY >= minY) {
            return new AbstractLimitAreaCoordinator.InBox(this, minX, minY, minZ, maxX, maxY, maxZ);
        }
        return Coordinator.warnDrop("Box was invalid; at least one min value was greater than the corresponding max value");
    }

    default public Coordinator inBox(class_3341 box, boolean lazy) {
        if (lazy) {
            return new AbstractLimitAreaCoordinator.LazyInBox(this, box);
        }
        return this.inBox(box.method_35415(), box.method_35416(), box.method_35417(), box.method_35418(), box.method_35419(), box.method_35420());
    }
}

