/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.scripting.bytecode.ClassCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.objectweb.asm.tree.MethodNode;

public class MethodCompileContext {
    public ClassCompileContext clazz;
    public MethodNode node;
    public MethodInfo info;
    public ScopeContext scopes;
    public int mangledVariableCounter;

    public MethodCompileContext(ClassCompileContext clazz, MethodNode node, MethodInfo info, String ... parameterNames) {
        if (info.paramTypes.length != parameterNames.length) {
            throw new IllegalArgumentException("Parameter mismatch: expected " + Arrays.toString(info.paramTypes) + ", got " + Arrays.toString(parameterNames));
        }
        this.clazz = clazz;
        this.node = node;
        this.info = info;
        this.scopes = new ScopeContext(this);
        this.node.parameters = new ArrayList(parameterNames.length);
        if (!info.isAbstract()) {
            this.scopes.pushScope();
        }
        if (!info.isStatic() && !info.isAbstract()) {
            this.scopes.addVariable("this", clazz.info);
        }
        int length = parameterNames.length;
        for (int index = 0; index < length; ++index) {
            this.node.visitParameter(parameterNames[index], 0);
            if (info.isAbstract()) continue;
            this.scopes.addVariable(parameterNames[index], info.paramTypes[index]);
        }
    }

    public void appendCode(int flags, String code, Consumer<MutableScriptEnvironment> environment) {
        try {
            new ExpressionParser(code, this.clazz, this, flags).configureEnvironment(environment).parseRemainingInput(false, false).emitBytecode(this);
        }
        catch (ScriptParsingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setCode(int flags, String code, Consumer<MutableScriptEnvironment> environment) {
        try {
            new ExpressionParser(code, this.clazz, this, flags).configureEnvironment(environment).parseEntireInput().emitBytecode(this);
        }
        catch (ScriptParsingException exception) {
            throw new RuntimeException(exception);
        }
        this.endCode();
    }

    public void endCode() {
        this.scopes.popScope();
    }

    public String mangleName(String name) {
        return "$" + name + this.mangledVariableCounter++;
    }
}

