/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.scripting.bytecode.BytecodeEmitter;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.util.ReflectionData;
import builderb0y.scripting.util.TypeInfos;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import org.objectweb.asm.Handle;

public class MethodInfo
implements BytecodeEmitter {
    public static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    public static final int PURE = Integer.MIN_VALUE;
    @Deprecated
    public final int access;
    public final TypeInfo owner;
    public final String name;
    public final TypeInfo returnType;
    public final TypeInfo[] paramTypes;
    public TypeInfo[] invokeTypes;

    public MethodInfo(int access, TypeInfo owner, String name, TypeInfo returnType, TypeInfo ... paramTypes) {
        this.access = access;
        this.owner = owner;
        this.name = name;
        this.returnType = returnType;
        this.paramTypes = paramTypes;
        for (TypeInfo paramType : paramTypes) {
            if (!paramType.isVoid()) continue;
            throw new IllegalArgumentException("Void-type parameter: " + String.valueOf(this));
        }
    }

    public TypeInfo[] getInvokeTypes() {
        if (this.isStatic()) {
            return this.paramTypes;
        }
        if (this.invokeTypes == null) {
            this.invokeTypes = (TypeInfo[])ObjectArrays.concat((Object)this.owner, (Object[])this.paramTypes);
        }
        return this.invokeTypes;
    }

    public MethodInfo pure() {
        return this.isPure() ? this : new MethodInfo(this.access | Integer.MIN_VALUE, this.owner, this.name, this.returnType, this.paramTypes);
    }

    public MethodInfo notPure() {
        return !this.isPure() ? this : new MethodInfo(this.access & Integer.MAX_VALUE, this.owner, this.name, this.returnType, this.paramTypes);
    }

    public MethodInfo deprecated() {
        return this.isDeprecated() ? this : new MethodInfo(this.access() | 0x20000, this.owner, this.name, this.returnType, this.paramTypes);
    }

    public MethodInfo notDeprecated() {
        return !this.isDeprecated() ? this : new MethodInfo(this.access() & 0xFFFDFFFF, this.owner, this.name, this.returnType, this.paramTypes);
    }

    public String getDescriptor() {
        StringBuilder builder = new StringBuilder(128).append('(');
        for (TypeInfo paramType : this.paramTypes) {
            builder.append(paramType.getDescriptor());
        }
        return builder.append(')').append(this.returnType.getDescriptor()).toString();
    }

    public Handle toHandle(int handleType) {
        return new Handle(handleType, this.owner.getInternalName(), this.name, this.getDescriptor(), this.isInterface());
    }

    public void emit(MethodCompileContext method, int opcode) {
        method.node.visitMethodInsn(opcode, this.owner.getInternalName(), this.name, this.getDescriptor(), this.isInterface());
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.emit(method, this.getInvokeOpcode());
    }

    public int access() {
        return this.access & 0x7FFDFFFF;
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public boolean isInterface() {
        return this.owner.type.isInterface;
    }

    public int getInvokeOpcode() {
        if (this.isStatic()) {
            return 184;
        }
        if (this.isPrivate() || this.name.equals("<init>")) {
            return 183;
        }
        if (this.isInterface()) {
            return 185;
        }
        return 182;
    }

    public boolean isPrivate() {
        return (this.access() & 2) != 0;
    }

    public boolean isPure() {
        return (this.access & Integer.MIN_VALUE) != 0;
    }

    public boolean isDeprecated() {
        return (this.access & 0x20000) != 0;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public static MethodInfo inCaller(String name) {
        return MethodInfo.getMethod(STACK_WALKER.getCallerClass(), name);
    }

    public static MethodInfo getMethod(Class<?> in, String name) {
        return MethodInfo.forMethod(ReflectionData.forClass(in).getDeclaredMethod(name));
    }

    public static MethodInfo getMethod(Class<?> in, String name, Predicate<Method> predicate) {
        return MethodInfo.forMethod(ReflectionData.forClass(in).findDeclaredMethod(name, predicate));
    }

    public static MethodInfo findMethod(Class<?> in, String name, Class<?> returnType, Class<?> ... paramTypes) {
        return MethodInfo.forMethod(ReflectionData.forClass(in).findDeclaredMethod(name, returnType, paramTypes));
    }

    public static MethodInfo forMethod(Method method) {
        return new MethodInfo(method.isAnnotationPresent(Deprecated.class) ? method.getModifiers() | 0x20000 : method.getModifiers() & 0xFFFDFFFF, TypeInfo.of(method.getDeclaringClass()), method.getName(), TypeInfo.of(method.getGenericReturnType()), TypeInfo.allOf(method.getGenericParameterTypes()));
    }

    public static MethodInfo getConstructor(Class<?> in) {
        return MethodInfo.forConstructor(ReflectionData.forClass(in).getConstructor());
    }

    public static MethodInfo getConstructor(Class<?> in, Predicate<Constructor<?>> predicate) {
        return MethodInfo.forConstructor(ReflectionData.forClass(in).findConstructor(predicate));
    }

    public static MethodInfo findConstructor(Class<?> in, Class<?> ... paramTypes) {
        return MethodInfo.forConstructor(ReflectionData.forClass(in).findConstructor(paramTypes));
    }

    public static MethodInfo forConstructor(Constructor<?> constructor) {
        return new MethodInfo(constructor.isAnnotationPresent(Deprecated.class) ? constructor.getModifiers() | 0x20000 : constructor.getModifiers() & 0xFFFDFFFF, TypeInfo.of(constructor.getDeclaringClass()), "<init>", TypeInfos.VOID, TypeInfo.allOf(constructor.getGenericParameterTypes()));
    }

    public String toString() {
        return Modifier.toString(this.access()) + (this.isPure() ? " pure" : "") + " " + this.owner.getInternalName() + "." + this.name + this.getDescriptor() + (this.isInterface() ? " (interface)" : "");
    }
}

