/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.util.StackMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class ScopeContext {
    public MethodCompileContext method;
    public List<Scope> stack;
    public StackMap<LazyVarInfo, Integer> localVariables;
    public int currentLocalVariableIndex;

    public ScopeContext(MethodCompileContext method) {
        this.method = method;
        this.stack = new ArrayList<Scope>(8);
        this.localVariables = new StackMap(16);
    }

    public void addVariable(LazyVarInfo variable) {
        if (this.localVariables.putIfAbsent(variable, this.currentLocalVariableIndex) != null) {
            throw new IllegalArgumentException("Variable " + String.valueOf(variable) + " already declared in this scope.");
        }
        Scope scope = this.peekScope();
        this.method.node.visitLocalVariable(variable.name, variable.type().getDescriptor(), null, scope.start.getLabel(), scope.end.getLabel(), this.currentLocalVariableIndex);
        this.currentLocalVariableIndex += variable.type.getSize();
    }

    public LazyVarInfo addVariable(String name, TypeInfo type) {
        LazyVarInfo variable = new LazyVarInfo(name, type);
        this.addVariable(variable);
        return variable;
    }

    public int getVariableIndex(LazyVarInfo variable) {
        Integer index = (Integer)this.localVariables.get(variable);
        if (index != null) {
            return index;
        }
        throw new IllegalArgumentException("Variable " + String.valueOf(variable) + " not declared in this scope.");
    }

    public Scope pushScope() {
        this.localVariables.push();
        Scope scope = Scope.normal();
        this.stack.add(scope);
        this.method.node.instructions.add((AbstractInsnNode)scope.start);
        return scope;
    }

    public Scope pushManualScope() {
        this.localVariables.push();
        Scope scope = Scope.manual();
        this.stack.add(scope);
        return scope;
    }

    public Scope pushLoop(@NotNull LoopName loopName) {
        this.localVariables.push();
        Scope scope = Scope.loop(loopName);
        this.stack.add(scope);
        this.method.node.instructions.add((AbstractInsnNode)scope.start);
        return scope;
    }

    public Scope pushLoop(@NotNull LoopName name, LabelNode continuePoint) {
        Scope scope = this.pushLoop(name);
        scope.continuePoint = continuePoint;
        return scope;
    }

    public void popScope() {
        this.localVariables.pop();
        Scope scope = this.stack.remove(this.stack.size() - 1);
        this.method.node.instructions.add((AbstractInsnNode)scope.end);
    }

    public void popLoop() {
        this.popScope();
    }

    public void popManualScope() {
        this.localVariables.pop();
        this.stack.remove(this.stack.size() - 1);
    }

    public void cycleScope() {
        this.localVariables.pop();
        this.localVariables.push();
    }

    public Scope peekScope() {
        return this.stack.get(this.stack.size() - 1);
    }

    public Scope globalScope() {
        return this.stack.get(0);
    }

    public Scope findLoopForContinue(String loopName) {
        List<Scope> stack = this.stack;
        int index = stack.size();
        while (--index >= 0) {
            Scope scope = stack.get(index);
            if (scope.type != Scope.Type.LOOP || loopName != null && !loopName.equals(scope.loopName.name)) continue;
            return scope;
        }
        throw new IllegalStateException((String)(loopName == null ? "No enclosing loop" : "No enclosing loop named " + loopName));
    }

    public Scope findLoopForBreak(String loopName) {
        List<Scope> stack = this.stack;
        int index = stack.size();
        while (--index >= 0) {
            Scope scope = stack.get(index);
            if (scope.type != Scope.Type.LOOP || loopName != null && !loopName.equals(scope.loopName.name)) continue;
            while (--index >= 0) {
                Scope next = stack.get(index);
                if (next.loopName != scope.loopName) break;
                scope = next;
            }
            return scope;
        }
        throw new IllegalStateException((String)(loopName == null ? "No enclosing loop" : "No enclosing loop named " + loopName));
    }

    public static class Scope {
        public LabelNode start;
        public LabelNode end;
        public LabelNode continuePoint;
        public Type type;
        @NotNull
        public LoopName loopName;

        public Scope(LabelNode start, LabelNode end, LabelNode continuePoint, Type type, @NotNull LoopName loopName) {
            this.start = start;
            this.end = end;
            this.continuePoint = continuePoint;
            this.type = type;
            this.loopName = loopName;
        }

        public static Scope normal() {
            return new Scope(InsnTrees.labelNode(), InsnTrees.labelNode(), null, Type.NORMAL, LoopName.NOT_A_LOOP);
        }

        public static Scope manual() {
            return new Scope(null, null, null, Type.MANUAL, LoopName.NOT_A_LOOP);
        }

        public static Scope loop(@NotNull LoopName loopName) {
            return new Scope(InsnTrees.labelNode(), InsnTrees.labelNode(), null, Type.LOOP, loopName);
        }

        public void cycle() {
            this.start = this.end;
            this.end = InsnTrees.labelNode();
            this.continuePoint = null;
        }

        public LabelNode getContinuePoint() {
            return this.continuePoint != null ? this.continuePoint : this.start;
        }

        public static enum Type {
            NORMAL,
            MANUAL,
            LOOP;

        }
    }

    public record LoopName(@Nullable String name) {
        public static final LoopName NOT_A_LOOP = new LoopName(null);

        public static LoopName of(String name) {
            return new LoopName(name);
        }
    }
}

