/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.IntCompareZeroConditionTree;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;

public class IntCompareConditionTree
implements ConditionTree {
    public final InsnTree left;
    public final InsnTree right;
    public final int opcode;

    public IntCompareConditionTree(InsnTree left, InsnTree right, int opcode) {
        this.left = left;
        this.right = right;
        this.opcode = opcode;
    }

    public static ConditionTree createInt(InsnTree left, InsnTree right, int normalOpcode, int zeroOpcode, IntBiPredicate ifConstant) {
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant()) {
            if (rightConstant.isConstant()) {
                return ConstantConditionTree.of(ifConstant.test(leftConstant.asInt(), rightConstant.asInt()));
            }
            if (leftConstant.asInt() == 0) {
                return new IntCompareZeroConditionTree(right, ConditionTree.flipOpcode(zeroOpcode));
            }
        } else if (rightConstant.isConstant() && rightConstant.asInt() == 0) {
            return new IntCompareZeroConditionTree(left, zeroOpcode);
        }
        return new IntCompareConditionTree(left, right, normalOpcode);
    }

    public static ConditionTree equal(InsnTree left, InsnTree right) {
        return IntCompareConditionTree.createInt(left, right, 159, 153, (l, r) -> l == r);
    }

    public static ConditionTree notEqual(InsnTree left, InsnTree right) {
        return IntCompareConditionTree.createInt(left, right, 160, 154, (l, r) -> l != r);
    }

    public static ConditionTree lessThan(InsnTree left, InsnTree right) {
        return IntCompareConditionTree.createInt(left, right, 161, 155, (l, r) -> l < r);
    }

    public static ConditionTree greaterThan(InsnTree left, InsnTree right) {
        return IntCompareConditionTree.createInt(left, right, 163, 157, (l, r) -> l > r);
    }

    public static ConditionTree lessThanOrEqual(InsnTree left, InsnTree right) {
        return IntCompareConditionTree.createInt(left, right, 164, 158, (l, r) -> l <= r);
    }

    public static ConditionTree greaterThanOrEqual(InsnTree left, InsnTree right) {
        return IntCompareConditionTree.createInt(left, right, 162, 156, (l, r) -> l >= r);
    }

    public void toInt(MethodCompileContext method) {
    }

    @Override
    public void emitBytecode(MethodCompileContext method, @Nullable Label ifTrue, @Nullable Label ifFalse) {
        ConditionTree.checkLabels(ifTrue, ifFalse);
        this.left.emitBytecode(method);
        this.right.emitBytecode(method);
        this.toInt(method);
        if (ifTrue != null) {
            method.node.visitJumpInsn(this.opcode, ifTrue);
            if (ifFalse != null) {
                method.node.visitJumpInsn(167, ifFalse);
            }
        } else {
            method.node.visitJumpInsn(ConditionTree.negateOpcode(this.opcode), ifFalse);
        }
    }

    @FunctionalInterface
    public static interface IntBiPredicate {
        public boolean test(int var1, int var2);
    }
}

