/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.flow.loop;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.VariableDeclarationInsnTree;
import builderb0y.scripting.util.TypeInfos;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractForIteratorInsnTree
implements InsnTree {
    public static final MethodInfo LIST_ITERATOR = MethodInfo.findMethod(List.class, "listIterator", ListIterator.class, new Class[0]);
    public static final MethodInfo ITERATOR = MethodInfo.getMethod(Iterable.class, "iterator");
    public static final MethodInfo HAS_NEXT = MethodInfo.getMethod(Iterator.class, "hasNext");
    public static final MethodInfo NEXT = MethodInfo.getMethod(Iterator.class, "next");
    public static final MethodInfo BYTE_VALUE = MethodInfo.getMethod(Byte.class, "byteValue");
    public static final MethodInfo SHORT_VALUE = MethodInfo.getMethod(Short.class, "shortValue");
    public static final MethodInfo INT_VALUE = MethodInfo.getMethod(Integer.class, "intValue");
    public static final MethodInfo LONG_VALUE = MethodInfo.getMethod(Long.class, "longValue");
    public static final MethodInfo FLOAT_VALUE = MethodInfo.getMethod(Float.class, "floatValue");
    public static final MethodInfo DOUBLE_VALUE = MethodInfo.getMethod(Double.class, "doubleValue");
    public static final MethodInfo CHAR_VALUE = MethodInfo.getMethod(Character.class, "charValue");
    public static final MethodInfo BOOLEAN_VALUE = MethodInfo.getMethod(Boolean.class, "booleanValue");
    public ScopeContext.LoopName loopName;

    public AbstractForIteratorInsnTree(ScopeContext.LoopName loopName) {
        this.loopName = loopName;
    }

    public static void castAndStore(VariableDeclarationInsnTree variable, MethodCompileContext method) {
        if (!variable.variable.type.equals(TypeInfos.OBJECT)) {
            method.node.visitTypeInsn(192, variable.variable.type.box().getInternalName());
            switch (variable.variable.type.getSort()) {
                case BYTE: {
                    BYTE_VALUE.emitBytecode(method);
                    break;
                }
                case SHORT: {
                    SHORT_VALUE.emitBytecode(method);
                    break;
                }
                case INT: {
                    INT_VALUE.emitBytecode(method);
                    break;
                }
                case LONG: {
                    LONG_VALUE.emitBytecode(method);
                    break;
                }
                case FLOAT: {
                    FLOAT_VALUE.emitBytecode(method);
                    break;
                }
                case DOUBLE: {
                    DOUBLE_VALUE.emitBytecode(method);
                    break;
                }
                case CHAR: {
                    CHAR_VALUE.emitBytecode(method);
                    break;
                }
                case BOOLEAN: {
                    BOOLEAN_VALUE.emitBytecode(method);
                    break;
                }
            }
        }
        variable.variable.emitStore(method);
    }

    @Override
    public boolean canBeStatement() {
        return true;
    }

    @Override
    public TypeInfo getTypeInfo() {
        return TypeInfos.VOID;
    }
}

