/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.update.ArrayUpdaterInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;

public class ArrayLoadInsnTree
implements InsnTree {
    public InsnTree array;
    public InsnTree index;
    public TypeInfo type;

    public ArrayLoadInsnTree(InsnTree array, InsnTree index) {
        this.array = array;
        this.index = index;
        this.type = array.getTypeInfo().componentType;
        if (this.type == null) {
            throw new IllegalArgumentException("Not an array: " + String.valueOf(array.getTypeInfo()));
        }
    }

    public static ArrayLoadInsnTree create(InsnTree array, InsnTree index) {
        if (!array.getTypeInfo().isArray()) {
            throw new InvalidOperandException("Array must be array-typed.");
        }
        if (!index.getTypeInfo().isSingleWidthInt()) {
            throw new InvalidOperandException("Index must be single-width int.");
        }
        return new ArrayLoadInsnTree(array, index);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.array.emitBytecode(method);
        this.index.emitBytecode(method);
        method.node.visitInsn(this.type.getOpcode(46));
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.type;
    }

    @Override
    public InsnTree update(ExpressionParser parser, InsnTree.UpdateOp op, InsnTree.UpdateOrder order, InsnTree rightValue) throws ScriptParsingException {
        if (op == InsnTree.UpdateOp.ASSIGN) {
            InsnTree cast = rightValue.cast(parser, this.type, InsnTree.CastMode.IMPLICIT_THROW, false);
            return new ArrayUpdaterInsnTree(order, true, this.array, this.index, cast);
        }
        InsnTree updater = op.createUpdater(parser, this.type, rightValue);
        return new ArrayUpdaterInsnTree(order, false, this.array, this.index, updater);
    }
}

