/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;

public class LineNumberInsnTree
implements InsnTree {
    public final InsnTree content;
    public final int lineNumber;

    public LineNumberInsnTree(InsnTree content, int lineNumber) {
        this.content = content;
        this.lineNumber = lineNumber;
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        AbstractInsnNode last = method.node.instructions.getLast();
        if (last instanceof LineNumberNode) {
            LineNumberNode lineNumberNode = (LineNumberNode)last;
            lineNumberNode.line = this.lineNumber;
        } else {
            Label label;
            if (last instanceof LabelNode) {
                LabelNode labelNode = (LabelNode)last;
                label = labelNode.getLabel();
                label.info = labelNode;
            } else {
                label = InsnTrees.label();
                method.node.visitLabel(label);
            }
            method.node.visitLineNumber(this.lineNumber, label);
        }
        this.content.emitBytecode(method);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.content.getTypeInfo();
    }

    @Override
    public ConstantValue getConstantValue() {
        return this.content.getConstantValue();
    }

    @Override
    public InsnTree doCast(ExpressionParser parser, TypeInfo type, InsnTree.CastMode mode, boolean nullable) {
        InsnTree cast = this.content.doCast(parser, type, mode, nullable);
        if (cast == null) {
            return null;
        }
        return new LineNumberInsnTree(cast, this.lineNumber);
    }

    @Override
    public InsnTree update(ExpressionParser parser, InsnTree.UpdateOp op, InsnTree.UpdateOrder order, InsnTree rightValue) throws ScriptParsingException {
        return new LineNumberInsnTree(this.content.update(parser, op, order, rightValue), this.lineNumber);
    }

    @Override
    public boolean jumpsUnconditionally() {
        return this.content.jumpsUnconditionally();
    }

    @Override
    public boolean canBeStatement() {
        return this.content.canBeStatement();
    }

    @Override
    public InsnTree asStatement() {
        return new LineNumberInsnTree(this.content.asStatement(), this.lineNumber);
    }

    @Override
    public InsnTree elvis(ExpressionParser parser, InsnTree alternative) {
        return new LineNumberInsnTree(this.content.elvis(parser, alternative), this.lineNumber);
    }
}

