/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;

public class ScopedInsnTree
implements InsnTree {
    public InsnTree body;

    public ScopedInsnTree(InsnTree body) {
        this.body = body;
    }

    public static InsnTree create(InsnTree body) {
        return new ScopedInsnTree(body);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        method.scopes.pushScope();
        this.body.emitBytecode(method.scopes.method);
        method.scopes.popScope();
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.body.getTypeInfo();
    }

    @Override
    public ConstantValue getConstantValue() {
        return this.body.getConstantValue();
    }

    @Override
    public boolean jumpsUnconditionally() {
        return this.body.jumpsUnconditionally();
    }

    @Override
    public boolean canBeStatement() {
        return this.body.canBeStatement();
    }

    @Override
    public InsnTree doCast(ExpressionParser parser, TypeInfo type, InsnTree.CastMode mode, boolean nullable) {
        InsnTree cast = this.body.cast(parser, type, mode, nullable);
        if (cast == null) {
            return null;
        }
        return new ScopedInsnTree(cast);
    }

    @Override
    public InsnTree update(ExpressionParser parser, InsnTree.UpdateOp op, InsnTree.UpdateOrder order, InsnTree rightValue) throws ScriptParsingException {
        return new ScopedInsnTree(this.body.update(parser, op, order, rightValue));
    }

    @Override
    public InsnTree asStatement() {
        return new ScopedInsnTree(this.body.asStatement());
    }

    @Override
    public InsnTree elvis(ExpressionParser parser, InsnTree alternative) {
        return new ScopedInsnTree(this.body.elvis(parser, alternative));
    }
}

