/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.between;

import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.between.DoubleBetweenInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.between.FloatBetweenInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.between.IntBetweenInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.between.LongBetweenInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;

public abstract class BetweenInsnTree
implements InsnTree {
    public InsnTree value;
    public InsnTree min;
    public InsnTree max;
    public boolean minInclusive;
    public boolean maxInclusive;

    public BetweenInsnTree(InsnTree value, InsnTree min, boolean minInclusive, InsnTree max, boolean maxInclusive) {
        this.value = value;
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    public static InsnTree create(ExpressionParser parser, InsnTree value, InsnTree min, boolean minInclusive, InsnTree max, boolean maxInclusive) {
        return switch (TypeInfos.widenToInt(value.getTypeInfo()).getSort()) {
            case TypeInfo.Sort.INT -> IntBetweenInsnTree.create(parser, value, min, minInclusive, max, maxInclusive);
            case TypeInfo.Sort.LONG -> LongBetweenInsnTree.create(parser, value, min, minInclusive, max, maxInclusive);
            case TypeInfo.Sort.FLOAT -> FloatBetweenInsnTree.create(parser, value, min, minInclusive, max, maxInclusive);
            case TypeInfo.Sort.DOUBLE -> DoubleBetweenInsnTree.create(parser, value, min, minInclusive, max, maxInclusive);
            default -> throw new IllegalArgumentException("Can only call isBetween" + (minInclusive ? (char)'[' : '(') + (maxInclusive ? (char)']' : ')') + " on numbers.");
        };
    }

    @Override
    public TypeInfo getTypeInfo() {
        return TypeInfos.BOOLEAN;
    }
}

