/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.binary;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.binary.BinaryInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;

public class DivideInsnTree
extends BinaryInsnTree {
    public DivideInsnTree(InsnTree left, InsnTree right, int opcode) {
        super(left, right, opcode);
    }

    public static TypeInfo validate(TypeInfo left, TypeInfo right) {
        if (left.isNumber() && right.isNumber()) {
            return TypeInfos.widenUntilSameInt(left, right);
        }
        throw new InvalidOperandException("Can't divide " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    public static InsnTree create(ExpressionParser parser, InsnTree left, InsnTree right) throws ScriptParsingException {
        TypeInfo type = DivideInsnTree.validate(left.getTypeInfo(), right.getTypeInfo());
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return switch (type.getSort()) {
                case TypeInfo.Sort.INT -> InsnTrees.ldc(DivideInsnTree.divideExact(parser, leftConstant.asInt(), rightConstant.asInt()));
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(DivideInsnTree.divideExact(parser, leftConstant.asLong(), rightConstant.asLong()));
                case TypeInfo.Sort.FLOAT -> InsnTrees.ldc(leftConstant.asFloat() / rightConstant.asFloat());
                case TypeInfo.Sort.DOUBLE -> InsnTrees.ldc(leftConstant.asDouble() / rightConstant.asDouble());
                default -> throw new AssertionError(type);
            };
        }
        left = left.cast(parser, type, InsnTree.CastMode.EXPLICIT_THROW, false);
        right = right.cast(parser, type, InsnTree.CastMode.EXPLICIT_THROW, false);
        return new DivideInsnTree(left, right, type.getOpcode(108));
    }

    public static int divideExact(ExpressionParser parser, int a, int b) throws ScriptParsingException {
        if (b == 0) {
            throw new ScriptParsingException("Division by literal zero", parser.input);
        }
        int div = a / b;
        if (div * b == a) {
            return div;
        }
        throw new ScriptParsingException(a + " / " + b + " cannot be represented exactly as an int. Try doing " + a + ".0 / " + b + ".0 instead", parser.input);
    }

    public static long divideExact(ExpressionParser parser, long a, long b) throws ScriptParsingException {
        if (b == 0L) {
            throw new ScriptParsingException("Division by literal zero", parser.input);
        }
        long div = a / b;
        if (div * b == a) {
            return div;
        }
        throw new ScriptParsingException(a + " / " + b + " cannot be represented exactly as a long. Try doing " + a + ".0 / " + b + ".0 instead", parser.input);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.left.emitBytecode(method);
        this.right.emitBytecode(method);
        switch (this.opcode) {
            case 108: {
                method.node.visitMethodInsn(184, "java/lang/Math", "floorDiv", "(II)I", false);
                break;
            }
            case 109: {
                method.node.visitMethodInsn(184, "java/lang/Math", "floorDiv", "(JJ)J", false);
                break;
            }
            case 110: {
                method.node.visitInsn(110);
                break;
            }
            case 111: {
                method.node.visitInsn(111);
                break;
            }
            default: {
                throw new AssertionError(this.opcode);
            }
        }
    }
}

