/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.binary;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.binary.BinaryInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;

public class UnsignedLeftShiftInsnTree
extends BinaryInsnTree {
    public static final MethodInfo INT_SHIFT = MethodInfo.findMethod(UnsignedLeftShiftInsnTree.class, "shift", Integer.TYPE, Integer.TYPE, Integer.TYPE).pure();
    public static final MethodInfo LONG_SHIFT = MethodInfo.findMethod(UnsignedLeftShiftInsnTree.class, "shift", Long.TYPE, Long.TYPE, Integer.TYPE).pure();

    public UnsignedLeftShiftInsnTree(InsnTree left, InsnTree right, int opcode) {
        super(left, right, opcode);
    }

    public static TypeInfo validate(TypeInfo left, TypeInfo right) {
        if (left.isInteger() && right.isSingleWidthInt()) {
            return TypeInfos.widenToInt(left);
        }
        throw new InvalidOperandException("Can't unsigned left shift " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    public static InsnTree create(ExpressionParser parser, InsnTree left, InsnTree right) {
        TypeInfo type = UnsignedLeftShiftInsnTree.validate(left.getTypeInfo(), right.getTypeInfo());
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return switch (type.getSort()) {
                case TypeInfo.Sort.INT -> InsnTrees.ldc(UnsignedLeftShiftInsnTree.shift(leftConstant.asInt(), rightConstant.asInt()));
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(UnsignedLeftShiftInsnTree.shift(leftConstant.asLong(), rightConstant.asInt()));
                default -> throw new AssertionError(type);
            };
        }
        left = left.cast(parser, type, InsnTree.CastMode.IMPLICIT_THROW, false);
        right = right.cast(parser, TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, false);
        return new UnsignedLeftShiftInsnTree(left, right, switch (type.getSort()) {
            case TypeInfo.Sort.INT -> 262;
            case TypeInfo.Sort.LONG -> 263;
            default -> throw new AssertionError(type);
        });
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        TypeInfo leftType = this.left.getTypeInfo();
        int maxShift = leftType.isDoubleWidth() ? 64 : 32;
        ConstantValue rightConstant = this.right.getConstantValue();
        if (rightConstant.isConstant()) {
            this.left.emitBytecode(method);
            long shift = rightConstant.asLong();
            if (shift > 0L) {
                if (shift >= (long)maxShift) {
                    method.node.visitInsn(leftType.isDoubleWidth() ? 88 : 87);
                    InsnTrees.constant(0, leftType).emitBytecode(method);
                } else {
                    this.right.emitBytecode(method);
                    method.node.visitInsn(leftType.getOpcode(120));
                }
            } else if (shift < 0L) {
                if (shift <= (long)(-maxShift)) {
                    method.node.visitInsn(leftType.isDoubleWidth() ? 88 : 87);
                    InsnTrees.constant(0, leftType).emitBytecode(method);
                } else {
                    InsnTrees.ldc(-shift, TypeInfos.INT).emitBytecode(method);
                    method.node.visitInsn(leftType.getOpcode(124));
                }
            }
        } else {
            InsnTrees.invokeStatic(leftType.isDoubleWidth() ? LONG_SHIFT : INT_SHIFT, this.left, this.right).emitBytecode(method);
        }
    }

    public static int shift(int a, int b) {
        if (b >= 0) {
            return b >= 32 ? 0 : a << b;
        }
        return b <= -31 ? 0 : a >>> -b;
    }

    public static long shift(long a, int b) {
        if (b >= 0) {
            return b >= 64 ? 0L : a << b;
        }
        return b <= -63 ? 0L : a >>> -b;
    }
}

