/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.unary;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.unary.UnaryInsnTree;
import builderb0y.scripting.util.TypeInfos;

public class NegateInsnTree
extends UnaryInsnTree {
    public NegateInsnTree(InsnTree value) {
        super(value);
    }

    public static InsnTree create(InsnTree value) {
        TypeInfo type = TypeInfos.widenToInt(value.getTypeInfo());
        ConstantValue constant = value.getConstantValue();
        if (constant.isConstant()) {
            return switch (type.getSort()) {
                case TypeInfo.Sort.INT -> InsnTrees.ldc(-constant.asInt());
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(-constant.asLong());
                case TypeInfo.Sort.FLOAT -> InsnTrees.ldc(-constant.asFloat());
                case TypeInfo.Sort.DOUBLE -> InsnTrees.ldc(-constant.asDouble());
                default -> throw new InvalidOperandException("Can't negate non-number.");
            };
        }
        if (!value.getTypeInfo().isNumber()) {
            throw new InvalidOperandException("Can't negate non-number.");
        }
        return new NegateInsnTree(value);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.operand.emitBytecode(method);
        method.node.visitInsn(this.operand.getTypeInfo().getOpcode(116));
    }

    @Override
    public TypeInfo getTypeInfo() {
        return TypeInfos.widenToInt(this.operand.getTypeInfo());
    }
}

