/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.environments;

import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.randomLists.RandomList;
import builderb0y.bigglobe.scripting.wrappers.ArrayWrapper;
import builderb0y.bigglobe.scripting.wrappers.ConstantMap;
import builderb0y.bigglobe.scripting.wrappers.ConstantSet;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.collections.NormalListMapGetterInsnTree;
import builderb0y.scripting.environments.Handlers;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.parsing.special.ConstantMapSyntax;
import builderb0y.scripting.util.TypeInfos;
import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.random.RandomGenerator;

public class JavaUtilScriptEnvironment {
    public static final MethodInfo MAP_GET = MethodInfo.getMethod(Map.class, "get");
    public static final MethodInfo MAP_PUT = MethodInfo.getMethod(Map.class, "put");
    public static final MethodInfo MAP_ENTRY_GET_KEY = MethodInfo.getMethod(Map.Entry.class, "getKey");
    public static final MethodInfo MAP_ENTRY_GET_VALUE = MethodInfo.getMethod(Map.Entry.class, "getValue");
    public static final MethodInfo MAP_ENTRY_SET_VALUE = MethodInfo.inCaller("setEntryValue");
    public static final MethodInfo LIST_GET = MethodInfo.getMethod(List.class, "get");
    public static final MethodInfo LIST_SET = MethodInfo.getMethod(List.class, "set");
    public static final MethodInfo CONSTANT_LIST = MethodInfo.inCaller("constantList");
    public static final MethodInfo CONSTANT_MAP = MethodInfo.inCaller("constantMap");
    public static final MethodInfo CONSTANT_SET = MethodInfo.inCaller("constantSet");
    @Deprecated
    public static final MutableScriptEnvironment NO_ALLOCATE_NO_MODIFY = new MutableScriptEnvironment().addMethodInvokes(Object.class, "toString", "equals", "hashCode", "getClass").addType("Iterator", Iterator.class).addMethodInvokes(Iterator.class, "hasNext", "next").addType("ListIterator", ListIterator.class).addMethodInvokes(ListIterator.class, "hasPrevious", "previous", "nextIndex", "previousIndex").addType("Map", Map.class).addMethodMultiInvokes(Map.class, "size", "isEmpty", "containsKey", "containsValue", "get", "keySet", "values", "entrySet", "getOrDefault").addFieldInvokes(Map.class, "size", "isEmpty").addType("MapEntry", Map.Entry.class).addMethodInvokes(Map.Entry.class, "getKey", "getValue").addFieldInvoke("key", MAP_ENTRY_GET_KEY).addType("SortedMap", SortedMap.class).addMethodInvokes(SortedMap.class, "firstKey", "lastKey").addType("NavigableMap", NavigableMap.class).addMethodMultiInvokes(NavigableMap.class, "lowerEntry", "lowerKey", "floorEntry", "floorKey", "ceilingEntry", "ceilingKey", "higherEntry", "higherKey", "firstEntry", "lastEntry", "descendingMap", "navigableKeySet", "descendingKeySet", "subMap", "headMap", "tailMap").addType("TreeMap", TreeMap.class).addType("HashMap", HashMap.class).addType("LinkedHashMap", LinkedHashMap.class).addType("ConstantMap", ConstantMap.class).addMemberKeyword(TypeInfos.CLASS, "new", new MutableScriptEnvironment.MemberKeywordHandler.Named("ConstantMap.new(key1: value1, key2: value2, ...)", (parser, receiver, name, mode) -> {
        if (receiver.getConstantValue().isConstant() && receiver.getConstantValue().asJavaObject().equals(InsnTrees.type(ConstantMap.class))) {
            return InsnTrees.ldc(CONSTANT_MAP, JavaUtilScriptEnvironment.inflate(ConstantMapSyntax.parse(parser).keysAndValues()));
        }
        return null;
    })).addType("Iterable", Iterable.class).addMethodInvoke(Iterable.class, "iterator").addType("Collection", Collection.class).addMethodInvokes(Collection.class, "size", "isEmpty", "contains", "containsAll").addFieldInvokes(Collection.class, "size", "isEmpty").addType("Set", Set.class).addType("SortedSet", SortedSet.class).addMethodInvokes(SortedSet.class, "subSet", "headSet", "tailSet", "first", "last").addType("NavigableSet", NavigableSet.class).addMethodMultiInvokes(NavigableSet.class, "lower", "floor", "ceiling", "higher", "descendingSet", "descendingIterator", "subSet", "headSet", "tailSet").addType("TreeSet", TreeSet.class).addType("HashSet", HashSet.class).addType("LinkedHashSet", LinkedHashSet.class).addType("ConstantSet", ConstantSet.class).addQualifiedFunction(InsnTrees.type(ConstantSet.class), "new", new MutableScriptEnvironment.FunctionHandler.Named("ConstantSet.new(values)", (parser, name, arguments) -> {
        int elementCount = arguments.length;
        ConstantValue[] constants = new ConstantValue[elementCount];
        for (int index = 0; index < elementCount; ++index) {
            constants[index] = arguments[index].getConstantValue();
            if (constants[index].isConstantOrDynamic()) continue;
            throw new ScriptParsingException("Argument " + index + " is not a constant value: " + arguments[index].describe(), parser.input);
        }
        return new MutableScriptEnvironment.CastResult(InsnTrees.ldc(CONSTANT_SET, JavaUtilScriptEnvironment.inflate(constants)), false);
    })).addType("List", List.class).addMethodMultiInvokes(List.class, "addAll", "get", "indexOf", "lastIndexOf", "listIterator", "subList").addType("LinkedList", LinkedList.class).addType("ArrayList", ArrayList.class).addType("ConstantList", ArrayWrapper.class).addQualifiedFunction(InsnTrees.type(ArrayWrapper.class), "new", new MutableScriptEnvironment.FunctionHandler.Named("ConstantList.new(values)", (parser, name, arguments) -> {
        int argumentCount = arguments.length;
        ConstantValue[] constants = new ConstantValue[argumentCount];
        for (int index = 0; index < argumentCount; ++index) {
            constants[index] = arguments[index].getConstantValue();
            if (constants[index].isConstantOrDynamic()) continue;
            throw new ScriptParsingException("Argument " + index + " is not a constant value: " + arguments[index].describe(), parser.input);
        }
        return new MutableScriptEnvironment.CastResult(InsnTrees.ldc(CONSTANT_LIST, JavaUtilScriptEnvironment.inflate(constants)), false);
    })).addType("Queue", Queue.class).addMethodInvokes(Queue.class, "element", "peek").addType("Deque", Deque.class).addMethodInvokes(Deque.class, "getFirst", "getLast", "peekFirst", "peekLast").addType("ArrayDeque", ArrayDeque.class).addType("PriorityQueue", PriorityQueue.class).addType("RandomList", IRandomList.class).addMethodMultiInvokes(IRandomList.class, "getWeight", "iterator", "listIterator", "subList").addMethodInvokeSpecific(IRandomList.class, "getRandomElement", Object.class, RandomGenerator.class).addType("RandomArrayList", RandomList.class);
    @Deprecated
    public static final MutableScriptEnvironment ALL = new MutableScriptEnvironment().addAll(NO_ALLOCATE_NO_MODIFY).addMethodInvokes(Iterator.class, "remove").addMethodInvokes(ListIterator.class, "set", "add").addMethodMultiInvokes(Map.class, "put", "remove", "putAll", "clear", "putIfAbsent", "replace").addMethod(InsnTrees.type(Map.class), "", new MutableScriptEnvironment.MethodHandler.Named("Map.(key)", (parser, receiver, name, mode, arguments) -> {
        InsnTree key = ScriptEnvironment.castArgument(parser, "", TypeInfos.OBJECT, InsnTree.CastMode.IMPLICIT_THROW, arguments);
        return new MutableScriptEnvironment.CastResult(NormalListMapGetterInsnTree.from(receiver, MAP_GET, key, MAP_PUT, "Map", mode), key != arguments[0]);
    })).addMethodInvokes(Map.Entry.class, "setValue").addFieldGetterSetter(InsnTrees.type(Map.Entry.class), "value", MAP_ENTRY_GET_VALUE, MAP_ENTRY_SET_VALUE).addMethodMultiInvokes(NavigableMap.class, "pollFirstEntry", "pollLastEntry").addQualifiedSpecificConstructor(TreeMap.class, SortedMap.class).addQualifiedSpecificConstructor(TreeMap.class, Map.class).addQualifiedSpecificConstructor(TreeMap.class, new Class[0]).addQualifiedMultiConstructor(HashMap.class).addQualifiedMultiConstructor(LinkedHashMap.class).addMethodInvokes(Collection.class, "add", "addAll", "removeAll", "retainAll", "clear").addMethodRenamedInvoke("removeElement", Collection.class, "remove").addMethodMultiInvokes(NavigableSet.class, "pollFirst", "pollLast").addQualifiedSpecificConstructor(TreeSet.class, SortedSet.class).addQualifiedSpecificConstructor(TreeSet.class, Collection.class).addQualifiedSpecificConstructor(TreeSet.class, new Class[0]).addQualifiedSpecificConstructor(HashSet.class, new Class[0]).addQualifiedSpecificConstructor(HashSet.class, Integer.TYPE).addQualifiedSpecificConstructor(HashSet.class, Collection.class).addQualifiedSpecificConstructor(HashSet.class, Integer.TYPE, Float.TYPE).addQualifiedSpecificConstructor(LinkedHashSet.class, new Class[0]).addQualifiedSpecificConstructor(LinkedHashSet.class, Integer.TYPE).addQualifiedSpecificConstructor(LinkedHashSet.class, Collection.class).addQualifiedSpecificConstructor(LinkedHashSet.class, Integer.TYPE, Float.TYPE).addMethodMultiInvokes(List.class, "add", "set").addMethodMultiInvokeStatic(JavaUtilScriptEnvironment.class, "shuffle").addMethodInvokeStatic(Collections.class, "reverse").addMethodRenamedInvokeSpecific("removeIndex", List.class, "remove", Object.class, Integer.TYPE).addMethod(InsnTrees.type(List.class), "", new MutableScriptEnvironment.MethodHandler.Named("List.(index)", (parser, receiver, name, mode, arguments) -> {
        InsnTree index = ScriptEnvironment.castArgument(parser, "", TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, arguments);
        return new MutableScriptEnvironment.CastResult(NormalListMapGetterInsnTree.from(receiver, LIST_GET, index, LIST_SET, "List", mode), index != arguments[0]);
    })).addQualifiedMultiConstructor(LinkedList.class).addQualifiedMultiConstructor(ArrayList.class).addMethodInvokes(ArrayList.class, "trimToSize", "ensureCapacity").addMethodInvokes(Queue.class, "offer", "remove", "poll").addMethodInvokes(Deque.class, "addFirst", "addLast", "offerFirst", "offerLast", "removeFirst", "removeLast", "pollFirst", "pollLast", "removeFirstOccurrence", "removeLastOccurrence", "push", "pop").addQualifiedMultiConstructor(ArrayDeque.class).addQualifiedMultiConstructor(PriorityQueue.class).addMethodMultiInvokes(IRandomList.class, "setWeight", "add", "set").addQualifiedMultiConstructor(RandomList.class);

    public static Consumer<MutableScriptEnvironment> noAllocateNoModify() {
        return environment -> environment.addAll(NO_ALLOCATE_NO_MODIFY).addMethodInvoke("", MAP_GET).addMethodInvoke("", LIST_GET).addFieldInvoke("value", MAP_ENTRY_GET_VALUE);
    }

    public static Consumer<MutableScriptEnvironment> withoutRandom() {
        return environment -> environment.addAll(ALL);
    }

    public static Consumer<MutableScriptEnvironment> withRandom(InsnTree loadRandom) {
        return environment -> environment.addAll(ALL).addMethod(InsnTrees.type(List.class), "shuffle", Handlers.builder(JavaUtilScriptEnvironment.class, "shuffle").addReceiverArgument(List.class).addImplicitArgument(loadRandom).buildMethod());
    }

    public static void swap(Object[] array, int index1, int index2) {
        Object tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
    }

    public static <T> void shuffle(List<T> list, RandomGenerator random) {
        int size = list.size();
        if (size < 5 || list instanceof RandomAccess) {
            for (int index = size; index > 1; --index) {
                Collections.swap(list, index - 1, random.nextInt(index));
            }
        } else {
            Object[] array = list.toArray();
            for (int index = size; index > 1; --index) {
                JavaUtilScriptEnvironment.swap(array, index - 1, random.nextInt(index));
            }
            ListIterator<T> iterator = list.listIterator();
            for (Object element : array) {
                iterator.next();
                iterator.set(element);
            }
        }
    }

    public static <T> void shuffle(List<T> list, long seed) {
        int size = list.size();
        if (size < 5 || list instanceof RandomAccess) {
            for (int index = size; index > 1; --index) {
                Collections.swap(list, index - 1, Permuter.nextBoundedInt(seed += -7046029254386353131L, index));
            }
        } else {
            Object[] array = list.toArray();
            for (int index = size; index > 1; --index) {
                JavaUtilScriptEnvironment.swap(array, index - 1, Permuter.nextBoundedInt(seed += -7046029254386353131L, index));
            }
            ListIterator<T> iterator = list.listIterator();
            for (Object element : array) {
                iterator.next();
                iterator.set(element);
            }
        }
    }

    public static <K, V> void setEntryValue(Map.Entry<K, V> entry, V value) {
        entry.setValue(value);
    }

    public static ArrayWrapper<Object> constantList(MethodHandles.Lookup caller, String name, Class<?> type, Object ... contents) {
        return new ArrayWrapper<Object>(JavaUtilScriptEnvironment.deflate(contents));
    }

    public static ConstantMap<Object, Object> constantMap(MethodHandles.Lookup caller, String name, Class<?> type, Object ... arguments) {
        return new ConstantMap<Object, Object>(JavaUtilScriptEnvironment.deflate(arguments));
    }

    public static ConstantSet<Object> constantSet(MethodHandles.Lookup caller, String name, Class<?> type, Object ... args) {
        return new ConstantSet<Object>(JavaUtilScriptEnvironment.deflate(args));
    }

    public static ConstantValue[] inflate(ConstantValue[] args) {
        int length = args.length;
        ConstantValue[] result = new ConstantValue[(length * 22 + 20) / 21];
        int writeIndex = 0;
        for (int baseIndex = 0; baseIndex < length; baseIndex += 21) {
            long types = 0L;
            int typeIndex = writeIndex++;
            for (int offset = 0; offset < 21; ++offset) {
                int index = baseIndex + offset;
                if (index >= length) {
                    types >>>= 3;
                    continue;
                }
                int type = JavaUtilScriptEnvironment.inflateOne(args[index]);
                result[writeIndex++] = args[index];
                types = types >>> 3 | (long)type << 60;
            }
            result[typeIndex] = InsnTrees.constant(types);
        }
        assert (writeIndex == result.length);
        return result;
    }

    public static Object[] deflate(Object[] args) {
        int length = args.length;
        int writeIndex = 0;
        block0: for (int baseIndex = 0; baseIndex < length; baseIndex += 22) {
            long types = (Long)args[baseIndex];
            for (int offset = 1; offset < 22; ++offset) {
                int index = baseIndex + offset;
                if (index >= length) break block0;
                args[writeIndex++] = JavaUtilScriptEnvironment.deflateOne((int)types & 7, args[index]);
                types >>>= 3;
            }
        }
        return Arrays.copyOf(args, writeIndex);
    }

    public static int inflateOne(ConstantValue value) {
        return switch (value.getTypeInfo().getSort()) {
            case TypeInfo.Sort.BOOLEAN -> 1;
            case TypeInfo.Sort.BYTE -> 2;
            case TypeInfo.Sort.SHORT -> 3;
            case TypeInfo.Sort.CHAR -> 4;
            case TypeInfo.Sort.OBJECT, TypeInfo.Sort.ARRAY -> {
                if (value instanceof ConstantValue.NullConstantValue) {
                    yield 5;
                }
                yield 0;
            }
            default -> 0;
        };
    }

    public static Object deflateOne(int type, Object value) {
        return switch (type) {
            case 0 -> value;
            case 1 -> (Integer)value != 0;
            case 2 -> ((Integer)value).byteValue();
            case 3 -> ((Integer)value).shortValue();
            case 4 -> Character.valueOf((char)((Integer)value).intValue());
            case 5 -> null;
            default -> throw new IllegalArgumentException(String.valueOf(value) + " cannot be cast with type " + type);
        };
    }
}

