/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.environments;

import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class MultiScriptEnvironment
implements ScriptEnvironment {
    public List<ScriptEnvironment> environments;

    public MultiScriptEnvironment() {
        this.environments = new ArrayList<ScriptEnvironment>(8);
    }

    public MultiScriptEnvironment(MultiScriptEnvironment from) {
        this.environments = new ArrayList<ScriptEnvironment>(from.environments);
    }

    @Override
    @Nullable
    public InsnTree getVariable(ExpressionParser parser, String name) throws ScriptParsingException {
        List<ScriptEnvironment> environments = this.environments;
        int size = environments.size();
        for (int index = 0; index < size; ++index) {
            InsnTree variable = environments.get(index).getVariable(parser, name);
            if (variable == null) continue;
            return variable;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree getField(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.GetFieldMode mode) throws ScriptParsingException {
        List<ScriptEnvironment> environments = this.environments;
        int size = environments.size();
        for (int index = 0; index < size; ++index) {
            InsnTree field = environments.get(index).getField(parser, receiver, name, mode);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree getFunction(ExpressionParser parser, String name, InsnTree ... arguments) throws ScriptParsingException {
        List<ScriptEnvironment> environments = this.environments;
        int size = environments.size();
        for (int index = 0; index < size; ++index) {
            InsnTree function = environments.get(index).getFunction(parser, name, arguments);
            if (function == null) continue;
            return function;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree getMethod(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.GetMethodMode mode, InsnTree ... arguments) throws ScriptParsingException {
        List<ScriptEnvironment> environments = this.environments;
        int size = environments.size();
        for (int index = 0; index < size; ++index) {
            InsnTree method = environments.get(index).getMethod(parser, receiver, name, mode, arguments);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree parseKeyword(ExpressionParser parser, String name) throws ScriptParsingException {
        List<ScriptEnvironment> environments = this.environments;
        int size = environments.size();
        for (int index = 0; index < size; ++index) {
            InsnTree keyword = environments.get(index).parseKeyword(parser, name);
            if (keyword == null) continue;
            return keyword;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree parseMemberKeyword(ExpressionParser parser, InsnTree receiver, String name, ScriptEnvironment.MemberKeywordMode mode) throws ScriptParsingException {
        List<ScriptEnvironment> environments = this.environments;
        int size = environments.size();
        for (int index = 0; index < size; ++index) {
            InsnTree memberKeyword = environments.get(index).parseMemberKeyword(parser, receiver, name, mode);
            if (memberKeyword == null) continue;
            return memberKeyword;
        }
        return null;
    }

    @Override
    @Nullable
    public TypeInfo getType(ExpressionParser parser, String name) throws ScriptParsingException {
        List<ScriptEnvironment> environments = this.environments;
        int size = environments.size();
        for (int index = 0; index < size; ++index) {
            TypeInfo type = environments.get(index).getType(parser, name);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @Override
    @Nullable
    public InsnTree cast(ExpressionParser parser, InsnTree value, TypeInfo to, boolean implicit, boolean nullable) {
        List<ScriptEnvironment> environments = this.environments;
        int size = environments.size();
        for (int index = 0; index < size; ++index) {
            InsnTree result = environments.get(index).cast(parser, value, to, implicit, nullable);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Stream<ScriptEnvironment.IdentifierDescriptor> listIdentifiers() {
        return this.environments.stream().flatMap(ScriptEnvironment::listIdentifiers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + String.valueOf(this.environments);
    }
}

