/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.optimization;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.optimization.ClassOptimizer;
import builderb0y.scripting.util.TypeInfos;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class ConstantJumpOptimizer
implements ClassOptimizer.MethodOptimizer {
    public static final ConstantJumpOptimizer INSTANCE = new ConstantJumpOptimizer();

    @Override
    public boolean optimize(MethodNode method) {
        boolean changed = false;
        AbstractInsnNode maybeLoadConstant = method.instructions.getFirst();
        while (maybeLoadConstant != null) {
            AbstractInsnNode next = maybeLoadConstant.getNext();
            ConstantValue constant = ConstantJumpOptimizer.getConstant(maybeLoadConstant);
            if (constant != null) {
                Boolean willJump;
                AbstractInsnNode maybeJump = ConstantJumpOptimizer.getJumpTarget(next);
                switch (maybeJump.getOpcode()) {
                    case 153: {
                        Boolean bl = constant.asInt() == 0;
                        break;
                    }
                    case 154: {
                        Boolean bl = constant.asInt() != 0;
                        break;
                    }
                    case 158: {
                        Boolean bl = constant.asInt() <= 0;
                        break;
                    }
                    case 156: {
                        Boolean bl = constant.asInt() >= 0;
                        break;
                    }
                    case 155: {
                        Boolean bl = constant.asInt() < 0;
                        break;
                    }
                    case 157: {
                        Boolean bl = constant.asInt() > 0;
                        break;
                    }
                    case 198: {
                        Boolean bl = constant.asJavaObject() == null;
                        break;
                    }
                    case 199: {
                        Boolean bl = constant.asJavaObject() != null;
                        break;
                    }
                    default: {
                        Boolean bl = willJump = null;
                    }
                }
                if (willJump != null) {
                    if (willJump.booleanValue()) {
                        method.instructions.set(maybeLoadConstant, (AbstractInsnNode)new JumpInsnNode(167, ((JumpInsnNode)maybeJump).label));
                    } else {
                        LabelNode target = InsnTrees.labelNode();
                        method.instructions.insert(maybeJump, (AbstractInsnNode)target);
                        method.instructions.set(maybeLoadConstant, (AbstractInsnNode)new JumpInsnNode(167, target));
                    }
                    changed = true;
                }
            }
            maybeLoadConstant = next;
        }
        return changed;
    }

    @Nullable
    public static ConstantValue getConstant(AbstractInsnNode node) {
        return switch (node.getOpcode()) {
            case 2 -> InsnTrees.constant(-1);
            case 3 -> InsnTrees.constant(0);
            case 4 -> InsnTrees.constant(1);
            case 5 -> InsnTrees.constant(2);
            case 6 -> InsnTrees.constant(3);
            case 7 -> InsnTrees.constant(4);
            case 8 -> InsnTrees.constant(5);
            case 16, 17 -> InsnTrees.constant(((IntInsnNode)node).operand);
            case 18 -> {
                Object var2_1 = ((LdcInsnNode)node).cst;
                if (var2_1 instanceof Integer) {
                    Integer i = (Integer)var2_1;
                    yield InsnTrees.constant(i);
                }
                yield null;
            }
            case 1 -> InsnTrees.constant(null, TypeInfos.OBJECT);
            default -> null;
        };
    }

    public static AbstractInsnNode getJumpTarget(AbstractInsnNode maybeLabel) {
        Set starts = Collections.newSetFromMap(new IdentityHashMap(4));
        while (true) {
            if (!starts.add(maybeLabel)) {
                throw new IllegalStateException("Detected empty infinite loop in script");
            }
            if (maybeLabel instanceof LabelNode || maybeLabel instanceof LineNumberNode) {
                maybeLabel = maybeLabel.getNext();
                continue;
            }
            if (maybeLabel.getOpcode() != 167) break;
            maybeLabel = ((JumpInsnNode)maybeLabel).label;
        }
        return maybeLabel;
    }
}

