/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing;

import builderb0y.scripting.bytecode.ClassCompileContext;
import builderb0y.scripting.bytecode.FieldCompileContext;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.ArrayExtensions;
import builderb0y.scripting.util.TypeInfos;
import it.unimi.dsi.fastutil.HashCommon;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;

public class UserClassDefiner {
    public static final MethodInfo OBJECT_CONSTRUCTOR = MethodInfo.getConstructor(Object.class);
    public static final MethodInfo MAKE_CONCAT_WITH_CONSTANTS = MethodInfo.getMethod(StringConcatFactory.class, "makeConcatWithConstants");
    public static final MethodInfo HASH_MIX = MethodInfo.findMethod(HashCommon.class, "mix", Integer.TYPE, Integer.TYPE).pure();
    public final ExpressionParser parser;
    public final String className;
    public final ClassCompileContext innerClass;
    public final TypeInfo innerClassType;

    public UserClassDefiner(ExpressionParser parser, String className) {
        this.parser = parser;
        this.className = className;
        this.innerClass = parser.clazz.newInnerClass(9, parser.clazz.innerClassName(className), TypeInfos.OBJECT, (TypeInfo[])TypeInfo.ARRAY_FACTORY.empty());
        this.innerClassType = this.innerClass.info;
    }

    public List<FieldCompileContext> parse() throws ScriptParsingException {
        List<FieldCompileContext> fields = this.parseFields();
        List<FieldCompileContext> nonDefaulted = fields.stream().filter(field -> field.initializer == null).toList();
        this.addConstructors(fields, nonDefaulted);
        UserClassDefiner.addToString(this.innerClass, this.className, fields);
        this.addEquals(fields);
        this.addHashCode(fields);
        this.exposeToScript(fields, nonDefaulted);
        return fields;
    }

    public List<FieldCompileContext> parseFields() throws ScriptParsingException {
        this.parser.input.expectAfterWhitespace('(');
        ArrayList<FieldCompileContext> fields = new ArrayList<FieldCompileContext>(8);
        while (!this.parser.input.hasAfterWhitespace(')')) {
            String typeName = this.parser.input.expectIdentifierAfterWhitespace();
            TypeInfo type = this.parser.environment.getType(this.parser, typeName);
            if (type == null) {
                throw new ScriptParsingException("Unknown type: " + typeName, this.parser.input);
            }
            if (this.parser.input.hasOperatorAfterWhitespace("*")) {
                this.parser.input.expectAfterWhitespace('(');
                while (!this.parser.input.hasAfterWhitespace(')')) {
                    fieldName = this.parser.verifyName(this.parser.input.expectIdentifierAfterWhitespace(), "field");
                    this.processNextField(fields, fieldName, type);
                    this.parser.input.hasOperatorAfterWhitespace(",");
                }
            } else {
                fieldName = this.parser.verifyName(this.parser.input.expectIdentifierAfterWhitespace(), "field");
                this.processNextField(fields, fieldName, type);
            }
            if (this.parser.input.hasOperatorAfterWhitespace(",")) continue;
            this.parser.input.hasOperatorAfterWhitespace(",,");
        }
        return fields;
    }

    public void processNextField(List<FieldCompileContext> fields, String name, TypeInfo type) throws ScriptParsingException {
        FieldCompileContext field = this.innerClass.newField(1, name, type);
        fields.add(field);
        if (this.parser.input.hasOperatorAfterWhitespace("=")) {
            ConstantValue initializer = this.parser.nextSingleExpression().cast(this.parser, type, InsnTree.CastMode.IMPLICIT_THROW, false).getConstantValue();
            if (initializer.isConstant()) {
                field.initializer = initializer;
            } else {
                throw new ScriptParsingException("Field initializer must be constant", this.parser.input);
            }
        }
        FieldInfo fieldInfo = field.info;
        MethodCompileContext getter = this.innerClass.newMethod(1, name, type, new LazyVarInfo[0]);
        LazyVarInfo self = new LazyVarInfo("this", getter.clazz.info);
        InsnTrees.return_(InsnTrees.getField(InsnTrees.load(self), fieldInfo)).emitBytecode(getter);
        getter.endCode();
        MethodCompileContext setter = this.innerClass.newMethod(1, name, TypeInfos.VOID, new LazyVarInfo(name, fieldInfo.type));
        self = new LazyVarInfo("this", setter.clazz.info);
        LazyVarInfo value = new LazyVarInfo(fieldInfo.name, fieldInfo.type);
        InsnTrees.putField(InsnTrees.load(self), fieldInfo, InsnTrees.load(value)).emitBytecode(setter);
        InsnTrees.return_(InsnTrees.noop).emitBytecode(setter);
        setter.endCode();
    }

    public void addConstructors(List<FieldCompileContext> fields, List<FieldCompileContext> nonDefaulted) {
        MethodCompileContext noArgConstructor = this.innerClass.newMethod(1, "<init>", TypeInfos.VOID, new LazyVarInfo[0]);
        LazyVarInfo self = new LazyVarInfo("this", noArgConstructor.clazz.info);
        InsnTrees.invokeInstance(InsnTrees.load(self), OBJECT_CONSTRUCTOR, new InsnTree[0]).emitBytecode(noArgConstructor);
        for (FieldCompileContext field2 : fields) {
            if (field2.initializer == null) continue;
            InsnTrees.putField(InsnTrees.load(self), new FieldInfo(1, this.innerClassType, field2.name(), field2.info.type), InsnTrees.ldc(field2.initializer)).emitBytecode(noArgConstructor);
        }
        InsnTrees.return_(InsnTrees.noop).emitBytecode(noArgConstructor);
        noArgConstructor.endCode();
        if (!fields.isEmpty()) {
            MethodCompileContext fullArgConstructor = this.innerClass.newMethod(1, "<init>", TypeInfos.VOID, (LazyVarInfo[])fields.stream().map(field -> new LazyVarInfo(field.name(), field.info.type)).toArray((IntFunction<A[]>)LazyVarInfo.ARRAY_FACTORY));
            self = new LazyVarInfo("this", fullArgConstructor.clazz.info);
            InsnTrees.invokeInstance(InsnTrees.load(self), OBJECT_CONSTRUCTOR, new InsnTree[0]).emitBytecode(fullArgConstructor);
            for (FieldCompileContext field2 : fields) {
                InsnTrees.putField(InsnTrees.load(self), new FieldInfo(1, this.innerClassType, field2.name(), field2.info.type), InsnTrees.load(field2.name(), field2.info.type)).emitBytecode(fullArgConstructor);
            }
            InsnTrees.return_(InsnTrees.noop).emitBytecode(fullArgConstructor);
            fullArgConstructor.endCode();
        }
        if (nonDefaulted.size() != fields.size() && !nonDefaulted.isEmpty()) {
            MethodCompileContext someArgsConstructor = this.innerClass.newMethod(1, "<init>", TypeInfos.VOID, (LazyVarInfo[])nonDefaulted.stream().map(field -> new LazyVarInfo(field.name(), field.info.type)).toArray((IntFunction<A[]>)LazyVarInfo.ARRAY_FACTORY));
            self = new LazyVarInfo("this", someArgsConstructor.clazz.info);
            InsnTrees.invokeInstance(InsnTrees.load(self), OBJECT_CONSTRUCTOR, new InsnTree[0]).emitBytecode(someArgsConstructor);
            for (FieldCompileContext field2 : fields) {
                InsnTrees.putField(InsnTrees.load(self), new FieldInfo(1, this.innerClassType, field2.info.name, field2.info.type), field2.initializer != null ? InsnTrees.ldc(field2.initializer) : InsnTrees.load(field2.name(), field2.info.type)).emitBytecode(someArgsConstructor);
            }
            InsnTrees.return_(InsnTrees.noop).emitBytecode(someArgsConstructor);
            someArgsConstructor.endCode();
        }
    }

    public static void addToString(ClassCompileContext innerClass, String className, List<FieldCompileContext> fields) {
        MethodCompileContext toString = innerClass.newMethod(1, "toString", TypeInfos.STRING, new LazyVarInfo[0]);
        LazyVarInfo self = new LazyVarInfo("this", toString.clazz.info);
        StringBuilder pattern = new StringBuilder(className).append('(');
        for (FieldCompileContext field2 : fields) {
            pattern.append(field2.name()).append(": ").append('\u0001').append(", ");
        }
        pattern.setLength(pattern.length() - 2);
        pattern.append(')');
        InsnTrees.return_(InsnTrees.invokeDynamic(MAKE_CONCAT_WITH_CONSTANTS, new MethodInfo(9, TypeInfos.OBJECT, "toString", TypeInfos.STRING, (TypeInfo[])fields.stream().map(field -> field.info.type).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY)), new ConstantValue[]{InsnTrees.constant(pattern.toString())}, (InsnTree[])fields.stream().map(field -> InsnTrees.getField(InsnTrees.load(self), field.info)).toArray((IntFunction<A[]>)InsnTree.ARRAY_FACTORY))).emitBytecode(toString);
        toString.endCode();
    }

    public void addHashCode(List<FieldCompileContext> fields) {
        MethodCompileContext hashCode = this.innerClass.newMethod(1, "hashCode", TypeInfos.INT, new LazyVarInfo[0]);
        LazyVarInfo self = new LazyVarInfo("this", hashCode.clazz.info);
        if (fields.isEmpty()) {
            InsnTrees.return_(InsnTrees.ldc(0)).emitBytecode(hashCode);
        } else {
            InsnTrees.invokeStatic(HASH_MIX, ArrayExtensions.computeHashCode(InsnTrees.getField(InsnTrees.load(self), fields.get((int)0).info))).emitBytecode(hashCode);
            int size = fields.size();
            for (int index = 1; index < size; ++index) {
                InsnTrees.invokeStatic(HASH_MIX, InsnTrees.add(this.parser, InsnTrees.getFromStack(TypeInfos.INT), ArrayExtensions.computeHashCode(InsnTrees.getField(InsnTrees.load(self), fields.get((int)index).info)))).emitBytecode(hashCode);
            }
            InsnTrees.return_(InsnTrees.getFromStack(TypeInfos.INT)).emitBytecode(hashCode);
        }
        hashCode.endCode();
    }

    public void addEquals(List<FieldCompileContext> fields) {
        MethodCompileContext equals = this.innerClass.newMethod(1, "equals", TypeInfos.BOOLEAN, new LazyVarInfo("object", TypeInfos.OBJECT));
        LazyVarInfo self = new LazyVarInfo("this", equals.clazz.info);
        LazyVarInfo object = new LazyVarInfo("object", TypeInfos.OBJECT);
        if (fields.isEmpty()) {
            InsnTrees.return_(InsnTrees.instanceOf(InsnTrees.load(object), this.innerClassType)).emitBytecode(equals);
        } else {
            LazyVarInfo that = equals.scopes.addVariable("that", this.innerClassType);
            InsnTrees.ifThen(InsnTrees.not(InsnTrees.condition(this.parser, InsnTrees.instanceOf(InsnTrees.load(object), this.innerClassType))), InsnTrees.return_(InsnTrees.ldc(false))).emitBytecode(equals);
            InsnTrees.store(that, InsnTrees.load(object).cast(this.parser, this.innerClassType, InsnTree.CastMode.EXPLICIT_THROW, false)).emitBytecode(equals);
            for (FieldCompileContext field : fields) {
                InsnTrees.ifThen(InsnTrees.not(InsnTrees.condition(this.parser, ArrayExtensions.computeEquals(this.parser, InsnTrees.getField(InsnTrees.load(self), field.info), InsnTrees.getField(InsnTrees.load(that), field.info)))), InsnTrees.return_(InsnTrees.ldc(false))).emitBytecode(equals);
            }
            InsnTrees.return_(InsnTrees.ldc(true)).emitBytecode(equals);
        }
        equals.endCode();
    }

    public void exposeToScript(List<FieldCompileContext> fields, List<FieldCompileContext> nonDefaulted) {
        this.parser.environment.user().types.put(this.className, this.innerClassType);
        this.parser.environment.user().addConstructor(this.innerClassType, new MethodInfo(1, this.innerClassType, "<init>", TypeInfos.VOID, new TypeInfo[0]));
        if (!fields.isEmpty()) {
            this.parser.environment.user().addConstructor(this.innerClassType, new MethodInfo(1, this.innerClassType, "<init>", TypeInfos.VOID, (TypeInfo[])fields.stream().map(field -> field.info.type).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY)));
            if (nonDefaulted.size() != fields.size()) {
                this.parser.environment.user().addConstructor(this.innerClassType, new MethodInfo(1, this.innerClassType, "<init>", TypeInfos.VOID, (TypeInfo[])nonDefaulted.stream().map(field -> field.info.type).toArray((IntFunction<A[]>)TypeInfo.ARRAY_FACTORY)));
            }
        }
        fields.stream().map(field -> field.info).forEach(this.parser.environment.user()::addFieldGetterAndSetter);
    }
}

